/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPJDependente
extends ColecaoRendPJTitular {
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public ColecaoRendPJDependente(DeclaracaoIRPF dec) {
        super(dec.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes");
    }

    @Override
    public RendPJDependente instanciaNovoObjeto() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.declaracaoRef.get());
        return new RendPJDependente(declaracaoIRPF);
    }

    public RendPJDependente obterRendimentoPorChave(String niFontePagadora, String cpfBeneficiario) {
        for (RendPJTitular rend : this.itens()) {
            RendPJDependente rendDep = (RendPJDependente)rend;
            if (!rendDep.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendDep.getCpfDependente().naoFormatado().equals(cpfBeneficiario)) continue;
            return rendDep;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (RendPJDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            RendPJDependente rend = (RendPJDependente)((Object)it.next());
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            it.remove();
        }
    }

    public RendPJDependente getRendimentoVazioPorNIFontePagadora(CPF cpfDep, NI niFonte) {
        for (RendPJTitular obj : this.itens()) {
            RendPJDependente rend = (RendPJDependente)obj;
            if (!rend.getCpfDependente().naoFormatado().equals(cpfDep.naoFormatado()) || !rend.getNIFontePagadora().naoFormatado().equals(niFonte.naoFormatado()) || !rend.todosValoresZerados()) continue;
            return rend;
        }
        return null;
    }

    @Override
    public boolean existeRendimentoPreenchidoComNIFontePagadora(NI niFonte) {
        for (RendPJTitular rend : this.itens()) {
            if (!rend.getNIFontePagadora().naoFormatado().equals(niFonte.naoFormatado()) || rend.todosValoresZerados()) continue;
            return true;
        }
        return false;
    }

    public List<ObjetoNegocio> obterListaRendimentosDeDependentesQueSairamDoPais() {
        ArrayList<ObjetoNegocio> retorno = new ArrayList<ObjetoNegocio>();
        for (RendPJDependente rend : this.itens()) {
            if (!rend.getDependenteSaiuPaisMesmaDataDeclarante().naoFormatado().equals(Logico.SIM)) continue;
            retorno.add(rend);
        }
        return retorno;
    }

    public Valor obterRendimentosRecebidosPJPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendPJDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', rend.getRendRecebidoPJ());
        }
        return retorno;
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendPJDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', rend.getRendRecebidoPJ());
            retorno.append('+', rend.getDecimoTerceiro());
        }
        return retorno;
    }

    public Boolean existeContribuicaoPrevidenciariaOficialPorDependente(CPF cpf) {
        Boolean retorno = false;
        for (RendPJDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado()) || rend.getContribuicaoPrevOficial().isVazio()) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    @Override
    public String getNomeAba() {
        return "Dependentes";
    }

    public Valor obterTotalRendPJPorDependente(CPF cpf) {
        Valor rendimentos = new Valor();
        for (RendPJTitular rendPJ : this.itens()) {
            RendPJDependente RendPJDep = (RendPJDependente)rendPJ;
            if (!cpf.naoFormatado().equals(RendPJDep.getCpfDependente().naoFormatado())) continue;
            rendimentos.append('+', RendPJDep.getRendRecebidoPJ());
        }
        return rendimentos;
    }

    public Valor obterTotalPrevidenciaPorDependente(CPF cpf) {
        Valor rendimentos = new Valor();
        for (RendPJTitular rendPJ : this.itens()) {
            RendPJDependente RendPJDep = (RendPJDependente)rendPJ;
            if (!cpf.naoFormatado().equals(RendPJDep.getCpfDependente().naoFormatado())) continue;
            rendimentos.append('+', RendPJDep.getContribuicaoPrevOficial());
        }
        return rendimentos;
    }

    public Valor obterTotalRendPJPorDependenteSemAuxilioEmergencial(CPF cpf) {
        Valor rendimentos = new Valor();
        for (RendPJTitular rendPJ : this.itens()) {
            RendPJDependente RendPJDep = (RendPJDependente)rendPJ;
            if (!cpf.naoFormatado().equals(RendPJDep.getCpfDependente().naoFormatado()) || ConstantesGlobaisIRPF.CNPJ_AUXILIO_EMERGENCIAL.equals(rendPJ.getNIFontePagadora().naoFormatado())) continue;
            rendimentos.append('+', RendPJDep.getRendRecebidoPJ());
        }
        return rendimentos;
    }
}

