/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNegativo;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class MesRendPF
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_PESSOA_FISICA = "Pessoa F\u00edsica";
    public static final String NOME_ALUGUEIS = "Alugu\u00e9is";
    public static final String NOME_OUTROS = "Outros";
    public static final String NOME_EXTERIOR = "Exterior";
    public static final String NOME_PREV_OFICIAL = "Previd\u00eancia oficial";
    public static final String NOME_DEPENDENTES = "Dependentes";
    public static final String NOME_PENSAOALIM = "Pens\u00e3o Aliment\u00edcia";
    public static final String NOME_IMPOSTO_PAGO_EXTERIR_COMPENSAR = "Imposto Pago no Exterior a Compensar";
    public static final String NOME_LIVRO_CAIXA = "Livro Caixa";
    public static final String NOME_CARNE_LEAO = "Carn\u00ea-Le\u00e3o";
    public static final String NOME_DARF_PAGO = "Darf Pago c\u00f3d. 0190";
    private Inteiro mes = new Inteiro((ObjetoNegocio)this, "");
    private ValorPositivo pessoaFisica = new ValorPositivo(this, "Pessoa F\u00edsica");
    private ValorPositivo alugueis = new ValorPositivo(this, "Alugu\u00e9is");
    private ValorPositivo outros = new ValorPositivo(this, "Outros");
    private ValorPositivo exterior = new ValorPositivo(this, "Exterior");
    private ValorPositivo previdencia = new ValorPositivo(this, "Previd\u00eancia oficial");
    private ValorPositivo numDependentes = new ValorPositivo(this, "numDependentes", 3, 0);
    private ValorPositivo dependentes = new ValorPositivo(this, "Dependentes");
    private ValorPositivo pensao = new ValorPositivo(this, "Pens\u00e3o Aliment\u00edcia");
    private ValorPositivo livroCaixa = new ValorPositivo(this, "Livro Caixa");
    private ValorPositivo impostoPagoCompensarExterior = new ValorPositivo(this, "Imposto Pago no Exterior a Compensar");
    private ValorPositivo carneLeao = new ValorPositivo(this, "Carn\u00ea-Le\u00e3o");
    private ValorPositivo darfPago = new ValorPositivo(this, "Darf Pago c\u00f3d. 0190");
    private transient ContasMes contasMes;

    public MesRendPF(final int mes, ContasMes contasMes) {
        this.pessoaFisica.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.alugueis.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.outros.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.exterior.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.previdencia.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.dependentes.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.numDependentes.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.pensao.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.livroCaixa.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.impostoPagoCompensarExterior.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.carneLeao.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.darfPago.addValidador((ValidadorIf)new ValidadorNaoNegativo(3));
        this.mes.setConteudo(mes);
        this.contasMes = contasMes;
        this.contasMes.getTotalRendTrabNaoAssPF().addObservador(new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                MesRendPF.this.pessoaFisica.setConteudo((String)o2);
            }
        });
        this.getNumDependentes().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                Valor valorDeducao = new Valor();
                valorDeducao.setConteudo(TabelaAliquotasIRPF.obterDeducaoMensalDependente(mes + 1));
                valorDeducao.append('*', MesRendPF.this.getNumDependentes().naoFormatado());
                MesRendPF.this.getDependentes().setConteudo(valorDeducao);
            }
        });
        this.getDependentes().addObservador(new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                Valor valorDeducao = new Valor();
                valorDeducao.setConteudo(TabelaAliquotasIRPF.obterDeducaoMensalDependente(mes + 1));
                if (MesRendPF.this.getDependentes().comparacao(">=", valorDeducao)) {
                    MesRendPF.this.getNumDependentes().setConteudo(MesRendPF.this.getDependentes().divide(valorDeducao));
                } else {
                    MesRendPF.this.getNumDependentes().setConteudo("0");
                }
            }
        });
    }

    public void addObservador(Observador obs) {
        this.pessoaFisica.addObservador(obs);
        this.alugueis.addObservador(obs);
        this.outros.addObservador(obs);
        this.exterior.addObservador(obs);
        this.previdencia.addObservador(obs);
        this.dependentes.addObservador(obs);
        this.pensao.addObservador(obs);
        this.impostoPagoCompensarExterior.addObservador(obs);
        this.livroCaixa.addObservador(obs);
        this.carneLeao.addObservador(obs);
        this.darfPago.addObservador(obs);
    }

    public void removeObservador(Observador obs) {
        this.pessoaFisica.removeObservador(obs);
        this.alugueis.removeObservador(obs);
        this.outros.removeObservador(obs);
        this.exterior.removeObservador(obs);
        this.previdencia.removeObservador(obs);
        this.dependentes.removeObservador(obs);
        this.pensao.removeObservador(obs);
        this.impostoPagoCompensarExterior.removeObservador(obs);
        this.livroCaixa.removeObservador(obs);
        this.carneLeao.removeObservador(obs);
        this.darfPago.removeObservador(obs);
    }

    public Valor getCarneLeao() {
        return this.carneLeao;
    }

    public Valor getDependentes() {
        return this.dependentes;
    }

    public Valor getExterior() {
        return this.exterior;
    }

    public Valor getLivroCaixa() {
        return this.livroCaixa;
    }

    public Inteiro getMes() {
        return this.mes;
    }

    public Valor getPensao() {
        return this.pensao;
    }

    public Valor getPessoaFisica() {
        return this.pessoaFisica;
    }

    public Valor getAlugueis() {
        return this.alugueis;
    }

    public Valor getOutros() {
        return this.outros;
    }

    public Valor getImpostoPagoCompensarExterior() {
        return this.impostoPagoCompensarExterior;
    }

    public Valor getPrevidencia() {
        return this.previdencia;
    }

    public Valor getDarfPago() {
        return this.darfPago;
    }

    public boolean isVazio() {
        return this.pessoaFisica.isVazio() && this.exterior.isVazio() && this.previdencia.isVazio() && this.dependentes.isVazio() && this.pensao.isVazio() && this.livroCaixa.isVazio() && this.darfPago.isVazio() && this.alugueis.isVazio() && this.outros.isVazio();
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getDependentes());
        retorno.add(this.getPessoaFisica());
        retorno.add(this.getAlugueis());
        retorno.add(this.getOutros());
        retorno.add(this.getDarfPago());
        retorno.add(this.getExterior());
        retorno.add(this.getImpostoPagoCompensarExterior());
        retorno.add(this.getLivroCaixa());
        retorno.add(this.getPensao());
        retorno.add(this.getPrevidencia());
        return retorno;
    }

    public String getClasseFicha() {
        return NavegacaoIf.PAINEL_REND_TRIB_RECEB_PF_EXT;
    }

    public String getNomeAba() {
        if (this.getFicha().equals("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Titular")) {
            return "Titular";
        }
        if (this.getFicha().equals("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes")) {
            return NOME_DEPENDENTES;
        }
        return null;
    }

    public ContasMes getContasMes() {
        return this.contasMes;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior";
    }

    public Valor getNumDependentes() {
        return this.numDependentes;
    }

    public void limpar() {
        this.contasMes.setObservadoresAtivos(false);
        this.pessoaFisica.setObservadoresAtivos(false);
        this.alugueis.setObservadoresAtivos(false);
        this.outros.setObservadoresAtivos(false);
        this.exterior.setObservadoresAtivos(false);
        this.previdencia.setObservadoresAtivos(false);
        this.numDependentes.setObservadoresAtivos(false);
        this.dependentes.setObservadoresAtivos(false);
        this.pensao.setObservadoresAtivos(false);
        this.livroCaixa.setObservadoresAtivos(false);
        this.impostoPagoCompensarExterior.setObservadoresAtivos(false);
        this.carneLeao.setObservadoresAtivos(false);
        this.darfPago.setObservadoresAtivos(false);
        this.contasMes.clear();
        this.pessoaFisica.clear();
        this.alugueis.clear();
        this.outros.clear();
        this.exterior.clear();
        this.previdencia.clear();
        this.numDependentes.clear();
        this.dependentes.clear();
        this.pensao.clear();
        this.livroCaixa.clear();
        this.impostoPagoCompensarExterior.clear();
        this.carneLeao.clear();
        this.darfPago.clear();
        this.contasMes.setObservadoresAtivos(true);
        this.pessoaFisica.setObservadoresAtivos(true);
        this.alugueis.setObservadoresAtivos(true);
        this.outros.setObservadoresAtivos(true);
        this.exterior.setObservadoresAtivos(true);
        this.previdencia.setObservadoresAtivos(true);
        this.numDependentes.setObservadoresAtivos(true);
        this.dependentes.setObservadoresAtivos(true);
        this.pensao.setObservadoresAtivos(true);
        this.livroCaixa.setObservadoresAtivos(true);
        this.impostoPagoCompensarExterior.setObservadoresAtivos(true);
        this.carneLeao.setObservadoresAtivos(true);
        this.darfPago.setObservadoresAtivos(true);
    }
}

