/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpf.ValidadorValoresNaoPreenchidos;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class ItemRendPFDependente
extends ObjetoNegocio
implements ObjetoFicha {
    private RendPF rendimentos = new RendPF();
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF dependente");
    private Valor fooValoresPreenchidos = new Valor((ObjetoNegocio)this, "");
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public void addValidador(DeclaracaoIRPF dec) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.getCpf().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_invalido"));
        this.getCpf().addValidador((ValidadorIf)validadorCPF);
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemRendPFDependente.this.declaracaoRef.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(ItemRendPFDependente.this.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_nao_existe"), 3);
                }
                return null;
            }
        });
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemRendPFDependente.this.declaracaoRef.get());
                int qtdCpfs = 0;
                for (ItemRendPFDependente item : declaracaoIRPF.getRendPFDependente().itens()) {
                    if (!item.getCpf().naoFormatado().equals(ItemRendPFDependente.this.getCpf().naoFormatado())) continue;
                    ++qtdCpfs;
                }
                if (qtdCpfs > 1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpf_dependente_duplicado"), 3);
                }
                return null;
            }
        });
        this.fooValoresPreenchidos.addValidador((ValidadorIf)new ValidadorValoresNaoPreenchidos(3, this));
        this.getRendimentos().getNITPISPASEP().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                Alfa nitTitular = ((DeclaracaoIRPF)((Object)ItemRendPFDependente.this.declaracaoRef.get())).getRendPFTitular().getNITPISPASEP();
                if (!nitTitular.isVazio() && ItemRendPFDependente.this.getRendimentos().getNITPISPASEP().naoFormatado().equals(nitTitular.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("nit_dependente_igual_titular"), 3);
                }
                return null;
            }
        });
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public void aplicaNomeFicha() {
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        this.getRendimentos().setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        for (int i = 0; i < 12; ++i) {
            this.getRendimentos().getMesRendPFPorIndice(i).setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        }
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getCpf());
        lista.add(this.fooValoresPreenchidos);
        lista.add(this.getRendimentos().getNITPISPASEP());
        for (int i = 0; i < 12; ++i) {
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getCarneLeao());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getDarfPago());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getDependentes());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getExterior());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getLivroCaixa());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getPensao());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getPessoaFisica());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getAlugueis());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getOutros());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getImpostoPagoCompensarExterior());
            lista.add(this.getRendimentos().getMesRendPFPorIndice(i).getPrevidencia());
        }
        return lista;
    }

    public RendPF getRendimentos() {
        return this.rendimentos;
    }

    public void setRendimentos(RendPF rendimentos) {
        this.rendimentos = rendimentos;
    }

    public String getClasseFicha() {
        return PainelDadosEscrituracao.class.getName();
    }

    public String getNomeAba() {
        return "Outras Informa\u00e7\u00f5es";
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes";
    }
}

