/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.gui.rendavariavel.PainelDadosRendaVariavelFundosInvest;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class ItemFundosInvestimentosDependente
extends ObjetoNegocio
implements ObjetoFicha {
    private FundosInvestimentos fundosInvestimentos;
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF dependente");
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public ItemFundosInvestimentosDependente(DeclaracaoIRPF dec) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.fundosInvestimentos = new FundosInvestimentos();
        this.addValidador();
    }

    public void addValidador() {
        this.getCpf().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_invalido"));
        this.getCpf().addValidador((ValidadorIf)validadorCPF);
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemFundosInvestimentosDependente.this.declaracaoRef.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(ItemFundosInvestimentosDependente.this.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_nao_existe"), 3);
                }
                return null;
            }
        });
        this.getCpf().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)ItemFundosInvestimentosDependente.this.declaracaoRef.get());
                int qtdCpfs = 0;
                for (ItemFundosInvestimentosDependente item : declaracaoIRPF.getFundosInvestimentosDependente().itens()) {
                    if (!item.getCpf().naoFormatado().equals(ItemFundosInvestimentosDependente.this.getCpf().naoFormatado())) continue;
                    ++qtdCpfs;
                }
                if (qtdCpfs > 1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpf_dependente_duplicado"), 3);
                }
                return null;
            }
        });
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.cpf);
        return lista;
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public FundosInvestimentos getFundosInvestimentos() {
        return this.fundosInvestimentos;
    }

    public String getClasseFicha() {
        return PainelDadosRendaVariavelFundosInvest.class.getName();
    }

    public String getNomeAba() {
        return "Dependentes";
    }

    public String getTituloFichaDashboard() {
        return "Renda Vari\u00e1vel - Opera\u00e7\u00f5es de Fundos de Invest. Imobili\u00e1rio";
    }

    public ItemFundosInvestimentosDependente obterCopia() {
        ItemFundosInvestimentosDependente copia = new ItemFundosInvestimentosDependente((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        copia.getCpf().setConteudo(this.getCpf());
        FundosInvestimentos fundosOrigem = this.getFundosInvestimentos();
        FundosInvestimentos fundosDestino = copia.getFundosInvestimentos();
        for (int i = 0; i < 12; ++i) {
            MesFundosInvestimentos mesOrigem = fundosOrigem.getMeses()[i];
            MesFundosInvestimentos mesDestino = fundosDestino.getMeses()[i];
            mesDestino.getResultLiquidoMes().setConteudo(mesOrigem.getResultLiquidoMes());
            mesDestino.getResultNegativoAnterior().setConteudo(mesOrigem.getResultNegativoAnterior());
            mesDestino.getBaseCalcImposto().setConteudo(mesOrigem.getBaseCalcImposto());
            mesDestino.getPrejuizoCompensar().setConteudo(mesOrigem.getPrejuizoCompensar());
            mesDestino.getAliquotaImposto().setConteudo(mesOrigem.getAliquotaImposto());
            mesDestino.getImpostoDevido().setConteudo(mesOrigem.getImpostoDevido());
            mesDestino.getImpostoRetidoMesesAnteriores().setConteudo(mesOrigem.getImpostoRetidoMesesAnteriores());
            mesDestino.getImpostoRetidoFonte().setConteudo(mesOrigem.getImpostoRetidoFonte());
            mesDestino.getImpostoRetidoCompensar().setConteudo(mesOrigem.getImpostoRetidoCompensar());
            mesDestino.getImpostoAPagar().setConteudo(mesOrigem.getImpostoAPagar());
            mesDestino.getImpostoPago().setConteudo(mesOrigem.getImpostoPago());
        }
        return copia;
    }
}

