/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ObservadorRecuperacaoPrejuizoBolsaDeValores;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendaVariavelDependente
extends Colecao<ItemRendaVariavelDependente> {
    private static final String NOME_FICHA = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - Dependentes";
    private WeakReference<DeclaracaoIRPF> weakDec;
    private Valor totalBaseCalculo = new Valor((ObjetoNegocio)this, "");
    private Valor totalIRFonteDayTrade = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoAPagar = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "");
    private ObservadorRecuperacaoPrejuizoBolsaDeValores observadorRecuperacaoPrejuizoBolsaDeValores;

    public ColecaoRendaVariavelDependente(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha(NOME_FICHA);
    }

    public void adicionarObservGanhosRendaVar(Observador pObservador) {
        this.getTotalBaseCalculo().addObservador(pObservador);
        this.getTotalIRFonteDayTrade().addObservador(pObservador);
        this.getTotalImpostoAPagar().addObservador(pObservador);
        this.getTotalImpostoPago().addObservador(pObservador);
        this.getTotalImpostoRetidoFonteLei11033().addObservador(pObservador);
    }

    public void adicionarObservadorRecuperacaoPrejuizoBolsaDeValores(ObservadorRecuperacaoPrejuizoBolsaDeValores pObservador) {
        this.observadorRecuperacaoPrejuizoBolsaDeValores = pObservador;
    }

    public ItemRendaVariavelDependente instanciaNovoObjeto() {
        return new ItemRendaVariavelDependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public void objetoInserido(ItemRendaVariavelDependente item) {
        item.addValidador();
        item.setFicha(NOME_FICHA);
        item.getRendaVariavel().getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().addObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().addObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getDezembro().getOperacoesComuns().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getDezembro().getOperacoesDayTrade().getPrejuizoCompensar().addObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public void objetoRemovido(Object o) {
        ItemRendaVariavelDependente item = (ItemRendaVariavelDependente)((Object)o);
        item.getRendaVariavel().getJaneiro().getOperacoesComuns().getResultadoNegativoMesAnterior().removeObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getJaneiro().getOperacoesDayTrade().getResultadoNegativoMesAnterior().removeObservador(this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getDezembro().getOperacoesComuns().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
        item.getRendaVariavel().getDezembro().getOperacoesDayTrade().getPrejuizoCompensar().removeObservador((Observador)this.observadorRecuperacaoPrejuizoBolsaDeValores);
    }

    public boolean todosCpfsPreenchidos() {
        boolean preenchido = true;
        Iterator it = this.itens().iterator();
        while (it.hasNext() && preenchido) {
            ItemRendaVariavelDependente item = (ItemRendaVariavelDependente)((Object)it.next());
            preenchido = preenchido && !item.getCpf().isVazio();
        }
        return preenchido;
    }

    public Map<String, Valor> obterTotalAnual() {
        Map<String, Valor> retorno = null;
        for (ItemRendaVariavelDependente item : this.itens()) {
            if (retorno == null) {
                retorno = item.getRendaVariavel().obterTotalAnual();
                continue;
            }
            RendaVariavel.somarTotalAnual(retorno, item.getRendaVariavel().obterTotalAnual());
        }
        return retorno;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemRendaVariavelDependente item : this.itens()) {
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemRendaVariavelDependente item = (ItemRendaVariavelDependente)((Object)it.next());
            if (!cpf.equals(item.getCpf().naoFormatado())) continue;
            it.remove();
        }
    }

    public boolean temResultadoLiquido() {
        for (ItemRendaVariavelDependente item : this.itens()) {
            if (!item.getRendaVariavel().temResultadoLiquido()) continue;
            return true;
        }
        return false;
    }

    public boolean temIRRF() {
        for (ItemRendaVariavelDependente item : this.itens()) {
            if (!item.getRendaVariavel().temIRRF()) continue;
            return true;
        }
        return false;
    }

    public Valor getTotalBaseCalculo() {
        return this.totalBaseCalculo;
    }

    public Valor getTotalIRFonteDayTrade() {
        return this.totalIRFonteDayTrade;
    }

    public Valor getTotalImpostoRetidoFonteLei11033() {
        return this.totalImpostoRetidoFonteLei11033;
    }

    public Valor getTotalImpostoAPagar() {
        return this.totalImpostoAPagar;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor recuperarTotalRendimentosPorBeneficiario(CPF cpf) {
        Valor total = new Valor("0,00");
        for (ItemRendaVariavelDependente item : this.itens()) {
            if (!item.getCpf().naoFormatado().equals(cpf.naoFormatado())) continue;
            for (int i = 0; i < 12; ++i) {
                total.append('+', item.getRendaVariavel().getGanhosPorIndice(i).getOperacoesComuns().getResultadoLiquidoMes());
                total.append('+', item.getRendaVariavel().getGanhosPorIndice(i).getOperacoesDayTrade().getResultadoLiquidoMes());
            }
        }
        return total;
    }
}

