/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.rendacm.PainelDadosRendAcm;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendAcmTitular
extends Colecao<RendAcmTitular>
implements ObjetoFicha {
    public static final String NOME_TOTAIS_AJUSTE = "Totais Rend. Recebidos - Ajuste";
    protected Valor totaisJuros = new Valor((ObjetoNegocio)this, "Totais Juros");
    protected Valor totaisRendRecebidos = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos");
    protected Valor totaisContribuicaoPrevOficial = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial");
    protected Valor totaisPensaoAlimenticia = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia");
    protected Valor totaisImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte");
    protected Valor totaisImpostoDevidoRRA = new Valor((ObjetoNegocio)this, "Totais Imposto Devido RRA");
    protected Valor totaisRendRecebidosAjuste = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos - Ajuste");
    protected Valor totaisRendRecebidosExclusiva = new Valor((ObjetoNegocio)this, "Totais Rend. Recebidos - Exclusiva");
    protected Valor totaisContribuicaoPrevOficialAjuste = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial - Ajuste");
    protected Valor totaisContribuicaoPrevOficialExclusiva = new Valor((ObjetoNegocio)this, "Totais Contr. Prev. Oficial - Exclusiva");
    protected Valor totaisPensaoAlimenticiaAjuste = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia - Ajuste");
    protected Valor totaisPensaoAlimenticiaExclusiva = new Valor((ObjetoNegocio)this, "Totais Pens\u00e3o Aliment\u00edcia - Exclusiva");
    protected Valor totaisImpostoRetidoFonteAjuste = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte - Ajuste");
    protected Valor totaisImpostoRetidoFonteExclusiva = new Valor((ObjetoNegocio)this, "Totais Imposto Retido na Fonte - Exclusiva");
    protected WeakReference<DeclaracaoIRPF> weakDec = null;

    public ColecaoRendAcmTitular(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.totaisRendRecebidos.setReadOnly(true);
        this.totaisContribuicaoPrevOficial.setReadOnly(true);
        this.totaisPensaoAlimenticia.setReadOnly(true);
        this.totaisImpostoRetidoFonte.setReadOnly(true);
        this.totaisImpostoDevidoRRA.setReadOnly(true);
        this.setFicha("Rendimentos Recebidos Acumuladamente pelo Titular");
    }

    public void atualizarParcelaIsenta65Anos() {
        ValorPositivo totalParcelaIsenta65Anos = new ValorPositivo();
        totalParcelaIsenta65Anos.setConteudo(((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().getTotais());
        totalParcelaIsenta65Anos.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().obterTotalParcela65AnosAjuste());
        ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().getParcIsentaAposentadoria().setConteudo((Valor)totalParcelaIsenta65Anos);
    }

    public void objetoInserido(RendAcmTitular rendAcmTitular) {
        rendAcmTitular.setFicha(this.getFicha());
        this.atualizarParcelaIsenta65Anos();
    }

    public void objetoRemovido(Object o) {
        this.atualizarRendIsentosParcelaIsenta65Anos();
    }

    private void atualizarRendIsentosParcelaIsenta65Anos() {
        ValorPositivo totalParcelaIsenta65Anos = new ValorPositivo();
        totalParcelaIsenta65Anos.setConteudo(((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().getTotais());
        totalParcelaIsenta65Anos.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().obterTotalParcela65AnosAjuste());
        ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().getParcIsentaAposentadoria().setConteudo((Valor)totalParcelaIsenta65Anos);
    }

    public RendAcmTitular instanciaNovoObjeto() {
        return new RendAcmTitular((DeclaracaoIRPF)((Object)this.weakDec.get()), this);
    }

    public Valor getTotaisContribuicaoPrevOficial() {
        return this.totaisContribuicaoPrevOficial;
    }

    public Valor getTotaisImpostoDevidoRRA() {
        return this.totaisImpostoDevidoRRA;
    }

    public Valor getTotaisImpostoRetidoFonte() {
        return this.totaisImpostoRetidoFonte;
    }

    public Valor getTotaisRendRecebidos() {
        return this.totaisRendRecebidos;
    }

    public Valor getTotaisPensaoAlimenticia() {
        return this.totaisPensaoAlimenticia;
    }

    public Valor getTotaisRendRecebidosAjuste() {
        return this.totaisRendRecebidosAjuste;
    }

    public Valor getTotaisImpostoRetidoFonteExclusiva() {
        return this.totaisImpostoRetidoFonteExclusiva;
    }

    public Valor getTotaisContribuicaoPrevOficialAjuste() {
        return this.totaisContribuicaoPrevOficialAjuste;
    }

    public Valor getTotaisPensaoAlimenticiaAjuste() {
        return this.totaisPensaoAlimenticiaAjuste;
    }

    public Valor getTotaisImpostoRetidoFonteAjuste() {
        return this.totaisImpostoRetidoFonteAjuste;
    }

    public Valor getTotaisContribuicaoPrevOficialExclusiva() {
        return this.totaisContribuicaoPrevOficialExclusiva;
    }

    public Valor getTotaisPensaoAlimenticiaExclusiva() {
        return this.totaisPensaoAlimenticiaExclusiva;
    }

    public Valor getTotaisRendRecebidosExclusiva() {
        return this.totaisRendRecebidosExclusiva;
    }

    public Valor getTotaisJuros() {
        return this.totaisJuros;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = super.recuperarListaCamposPendencia();
        listaCamposPendencia.add(this.getTotaisRendRecebidos());
        return listaCamposPendencia;
    }

    public String getClasseFicha() {
        return PainelDadosRendAcm.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public boolean existeRendAcmComAlimentando(String nomeAlimentando) {
        for (RendAcmTitular rendAcm : this.itens()) {
            if (!rendAcm.getPensaoAlimenticiaQuadroAuxiliar().existeAlimentando(nomeAlimentando)) continue;
            return true;
        }
        return false;
    }

    public void excluirRendAcmComAlimentando(String nomeAlimentando) {
        for (RendAcmTitular rendAcm : this.itens()) {
            rendAcm.getPensaoAlimenticiaQuadroAuxiliar().excluirAlimentando(nomeAlimentando);
        }
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Recebidos Acumuladamente pelo Titular";
    }

    public Valor obterSomatorioParcelaIsenta65Anos() {
        Valor somatorio = new Valor();
        for (RendAcmTitular rendAcm : this.itens()) {
            if (!"A".equals(rendAcm.getOpcaoTributacao().naoFormatado())) continue;
            somatorio.append('+', (Valor)rendAcm.getParcIsenta65Anos());
        }
        return somatorio;
    }

    public Valor obterSomatorioJurosRRA() {
        ValorPositivo total = new ValorPositivo();
        for (RendAcmTitular rendAcm : this.itens()) {
            total.append('+', rendAcm.getValorJuros());
        }
        return total;
    }
}

