/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorCPFIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;

public class ItemQuadroTransporteDetalhado
extends ItemQuadroAuxiliar {
    private CPF cpfAlimentante = new CPF((ObjetoNegocio)this, "CPF do Alimentante");
    private CNPJ cnpjEmpresa = new CNPJ((ObjetoNegocio)this, "CNPJ da fonte pagadora");
    private Alfa nomeFonte = new Alfa((ObjetoNegocio)this, "Nome da fonte pagadora", 60);
    private boolean parcIsentaAposentadoria = false;

    public ItemQuadroTransporteDetalhado(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome((NI)this.cnpjEmpresa, this.nomeFonte);
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroTransporteDetalhado.this.getCodBem().naoFormatado()) || ItemQuadroTransporteDetalhado.this.getCodBem().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorCNPJ(3){

            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroTransporteDetalhado.this.getCodBem().naoFormatado()) || ItemQuadroTransporteDetalhado.this.getCodBem().isVazio()) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{this.getInformacao().getNomeCampo()}));
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNomeFonte().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFonte().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
        this.getCpfAlimentante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getCpfAlimentante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3));
    }

    public ItemQuadroTransporteDetalhado(final DeclaracaoIRPF dec, boolean parcIsentaAposentadoria) {
        this(dec);
        this.parcIsentaAposentadoria = parcIsentaAposentadoria;
        if (parcIsentaAposentadoria) {
            this.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    Data dataNascimento = null;
                    if (ItemQuadroTransporteDetalhado.this.getTipoBeneficiario().naoFormatado().equals("Titular")) {
                        dataNascimento = dec.getContribuinte().getDataNascimento();
                    }
                    return ItemQuadroTransporteDetalhado.verificaDataNascimento(dataNascimento);
                }
            });
            this.getCpfBeneficiario().addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    Dependente d;
                    Data dataNascimento = null;
                    if (ItemQuadroTransporteDetalhado.this.getTipoBeneficiario().naoFormatado().equals("Dependente") && (d = dec.getDependentes().getDependenteByCpf(ItemQuadroTransporteDetalhado.this.getCpfBeneficiario().naoFormatado())) != null) {
                        dataNascimento = d.getDataNascimento();
                    }
                    return ItemQuadroTransporteDetalhado.verificaDataNascimento(dataNascimento);
                }
            });
        }
    }

    private static RetornoValidacao verificaDataNascimento(Data dataNascimento) {
        if (dataNascimento != null) {
            String DATA_NASCIMENTO_65_ANOS = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 65);
            Data data65Anos = new Data();
            data65Anos.setConteudo(DATA_NASCIMENTO_65_ANOS);
            if (dataNascimento.maisNova(data65Anos)) {
                return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_quadro_auxiliar_parc_isenta_aposentadoria_idade_beneficiario"), 3);
            }
        }
        return null;
    }

    public ItemQuadroTransporteDetalhado(DeclaracaoIRPF dec, ObjetoNegocio parent) {
        this(dec);
        this.parent = new WeakReference<ObjetoNegocio>(parent);
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public CNPJ getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.cnpjEmpresa);
        this.camposPendencia.add(this.nomeFonte);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getCnpjEmpresa();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeFonte();
    }

    public boolean isParcIsentaAposentadoria() {
        return this.parcIsentaAposentadoria;
    }

    public void setParcIsentaAposentadoria(boolean parcIsentaAposentadoria) {
        this.parcIsentaAposentadoria = parcIsentaAposentadoria;
    }

    public CPF getCpfAlimentante() {
        return this.cpfAlimentante;
    }
}

