/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorCPFIRPF;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;

public class ItemQuadroPensaoAlimenticiaRendIsentos
extends ItemQuadroAuxiliar {
    private CPF cpfAlimentante = new CPF((ObjetoNegocio)this, "CPF do Alimentante");
    private Alfa nomeAlimentante = new Alfa((ObjetoNegocio)this, "Nome do Alimentante", 60);
    private boolean parcIsentaAposentadoria = false;

    public ItemQuadroPensaoAlimenticiaRendIsentos(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome((NI)this.cpfAlimentante, this.nomeAlimentante);
        this.getCpfAlimentante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getCpfAlimentante().addValidador((ValidadorIf)new ValidadorCPFIRPF(3));
        this.getCpfAlimentante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ItemQuadroPensaoAlimenticiaRendIsentos.this.getCpfBeneficiario().formatado().equals(this.getInformacao().formatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendisentos_cpf_alimentante_igual_cpf_alimentando"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getNomeAlimentante().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeAlimentante().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
    }

    public ItemQuadroPensaoAlimenticiaRendIsentos(DeclaracaoIRPF dec, ObjetoNegocio parent) {
        this(dec);
        this.parent = new WeakReference<ObjetoNegocio>(parent);
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.cpfAlimentante);
    }

    public boolean isParcIsentaAposentadoria() {
        return this.parcIsentaAposentadoria;
    }

    public void setParcIsentaAposentadoria(boolean parcIsentaAposentadoria) {
        this.parcIsentaAposentadoria = parcIsentaAposentadoria;
    }

    public CPF getCpfAlimentante() {
        return this.cpfAlimentante;
    }

    public Alfa getNomeAlimentante() {
        return this.nomeAlimentante;
    }
}

