/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ItemQuadroOutrosRendimentos
extends ItemQuadroAuxiliar {
    private NI cnpjEmpresa = new NI((ObjetoNegocio)this, "CPF/CNPJ da fonte pagadora");
    private Alfa nomeFonte = new Alfa((ObjetoNegocio)this, "Nome da fonte pagadora", 60);
    private Alfa descricaoRendimento = new Alfa((ObjetoNegocio)this, "Descri\u00e7\u00e3o do rendimento", 60);

    public ItemQuadroOutrosRendimentos(DeclaracaoIRPF dec) {
        super(dec);
        CacheNI.getInstancia().registrarNINome(this.cnpjEmpresa, this.nomeFonte);
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroOutrosRendimentos.this.getCodBem().naoFormatado()) || ItemQuadroOutrosRendimentos.this.getCodBem().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCnpjEmpresa().addValidador((ValidadorIf)new ValidadorNI(3){

            public RetornoValidacao validarImplementado() {
                if ("00000".equals(ItemQuadroOutrosRendimentos.this.getCodBem().naoFormatado()) || ItemQuadroOutrosRendimentos.this.getCodBem().isVazio()) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{this.getInformacao().getNomeCampo()}));
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNomeFonte().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFonte().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
        this.getDescricaoRendimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
    }

    public ItemQuadroOutrosRendimentos(DeclaracaoIRPF dec, ObjetoNegocio parent) {
        this(dec);
        this.parent = new WeakReference<ObjetoNegocio>(parent);
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public NI getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    public Alfa getDescricaoRendimento() {
        return this.descricaoRendimento;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.cnpjEmpresa);
        this.camposPendencia.add(this.nomeFonte);
        this.camposPendencia.add(this.descricaoRendimento);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getCnpjEmpresa();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeFonte();
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }
}

