/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroTransporteDetalhado
extends Colecao<ItemQuadroTransporteDetalhado> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;
    private boolean parcIsentaAposentadoria = false;
    private transient ObjetoNegocio parent;

    public ColecaoItemQuadroTransporteDetalhado() {
        this.getTotais().setReadOnly(true);
    }

    public ColecaoItemQuadroTransporteDetalhado(boolean parcIsentaAposentadoria) {
        this();
        this.parcIsentaAposentadoria = parcIsentaAposentadoria;
    }

    public ColecaoItemQuadroTransporteDetalhado(ObjetoNegocio parent) {
        this();
        this.parent = parent;
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroTransporteDetalhado itemQuadroTransporteDetalhado) {
        itemQuadroTransporteDetalhado.getValor().addObservador((Observador)this);
        itemQuadroTransporteDetalhado.getValor13Salario().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroTransporteDetalhado)((Object)o)).getValor().removeObservador((Observador)this);
        ((ItemQuadroTransporteDetalhado)((Object)o)).getValor13Salario().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroTransporteDetalhado itemQuadroAuxiliar = (ItemQuadroTransporteDetalhado)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
            if (!this.parcIsentaAposentadoria) continue;
            this.totais.append('+', (Valor)itemQuadroAuxiliar.getValor13Salario());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroTransporteDetalhado item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroTransporteDetalhado item = (ItemQuadroTransporteDetalhado)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroTransporteDetalhado instanciaNovoObjeto() {
        return this.parcIsentaAposentadoria ? new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get()), this.parcIsentaAposentadoria) : (this.parent == null ? new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get())) : new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get()), this.parent));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }

    public ObjetoNegocio getParent() {
        return this.parent;
    }
}

