/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroRendimentosNI;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroRendimentosNI
extends Colecao<ItemQuadroRendimentosNI> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroRendimentosNI() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroRendimentosNI itemQuadroRendimentosNI) {
        itemQuadroRendimentosNI.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroRendimentosNI)((Object)o)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroRendimentosNI itemQuadroAuxiliar = (ItemQuadroRendimentosNI)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroRendimentosNI item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroRendimentosNI item = (ItemQuadroRendimentosNI)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroRendimentosNI instanciaNovoObjeto() {
        return new ItemQuadroRendimentosNI((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }
}

