/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroGanhosAcoesOuro;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroGanhosAcoesOuro
extends Colecao<ItemQuadroGanhosAcoesOuro> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroGanhosAcoesOuro() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro) {
        itemQuadroGanhosAcoesOuro.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroGanhosAcoesOuro)((Object)o)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totais.clear();
        while (it.hasNext()) {
            ItemQuadroGanhosAcoesOuro itemQuadroAuxiliar = (ItemQuadroGanhosAcoesOuro)((Object)it.next());
            this.totais.append('+', itemQuadroAuxiliar.getValor());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public ItemQuadroGanhosAcoesOuro obterPorCPF(String cpf) {
        for (ItemQuadroGanhosAcoesOuro item : this.itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(cpf)) continue;
            return item;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroGanhosAcoesOuro item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroGanhosAcoesOuro item = (ItemQuadroGanhosAcoesOuro)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public Valor obterTotalPorCPF(String cpf, Valor valorAtual) {
        Valor total = new Valor();
        for (ItemQuadroGanhosAcoesOuro item : this.itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(cpf) || item.getValor() == valorAtual) continue;
            total.append('+', item.getValor());
        }
        return total;
    }

    public Set<String> obterCPFsQueExcederamLimite() {
        String chave;
        HashMap<String, Valor> mapaValores = new HashMap<String, Valor>();
        for (ItemQuadroGanhosAcoesOuro item : this.itens()) {
            chave = item.getCpfBeneficiario().formatado();
            if (mapaValores.containsKey(chave)) {
                mapaValores.put(chave, ((Valor)mapaValores.get(chave)).operacao('+', item.getValor()));
                continue;
            }
            mapaValores.put(chave, item.getValor());
        }
        Iterator iterator = mapaValores.keySet().iterator();
        while (iterator.hasNext()) {
            chave = (String)iterator.next();
            if (((Valor)mapaValores.get(chave)).comparacao(">", "240.000,00")) continue;
            iterator.remove();
        }
        return mapaValores.keySet();
    }

    public ItemQuadroGanhosAcoesOuro instanciaNovoObjeto() {
        return new ItemQuadroGanhosAcoesOuro((DeclaracaoIRPF)((Object)this.dec.get()), this);
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }
}

