/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao<Pagamento> {
    private Valor totalDeducoesInstrucao = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribuicaoPreviPrivada = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribuicaoFunpresp = new Valor((ObjetoNegocio)this, "");
    private Valor totalDespesasMedicas = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensaoCartoral = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Pagamentos(DeclaracaoIRPF dec) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Pagamentos Efetuados");
        this.inicializaGeradorIndices();
    }

    private void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.naoFormatado().trim().equals("") ? 0L : Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public void reordenaPorCodigo() {
        Collections.sort(this.itens(), new Comparator<Pagamento>(){

            @Override
            public int compare(Pagamento o1, Pagamento o2) {
                if (o1.getCodigo().asInteger() < o2.getCodigo().asInteger()) {
                    return -1;
                }
                if (o1.getCodigo().asInteger() > o2.getCodigo().asInteger()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void objetoInserido(Pagamento pagamento) {
        pagamento.setFicha(this.getFicha());
    }

    public Pagamento instanciaNovoObjeto() {
        Pagamento item = new Pagamento((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        item.getIndice().setConteudo(this.proximoIndice());
        return item;
    }

    public boolean existeValorPagoAlto() {
        for (Pagamento pgto : this.itens()) {
            if (!pgto.getValorPago().comparacao(">", "50.000,00")) continue;
            return true;
        }
        return false;
    }

    public String[] recuperarCNPJsMaioresPrevComplementar(int qtd) {
        Iterator it = this.itens().iterator();
        class CNPJValor {
            private String cnpj;
            private Valor totalValorPago;

            public CNPJValor(String cnpj, Valor totalValorPago) {
                this.cnpj = cnpj;
                this.totalValorPago = totalValorPago;
            }
        }
        HashMap<String, CNPJValor> totaisValores = new HashMap<String, CNPJValor>();
        while (it.hasNext()) {
            Pagamento pgto = (Pagamento)it.next();
            if (!pgto.isPrevidenciaPrivada()) continue;
            String cnpj = pgto.getNiBeneficiario().naoFormatado();
            CNPJValor v = (CNPJValor)totaisValores.get(cnpj);
            if (v == null) {
                v = new CNPJValor(cnpj, new Valor());
                totaisValores.put(cnpj, v);
            }
            v.totalValorPago.append('+', pgto.getValorPago());
        }
        ArrayList listaRet = new ArrayList(totaisValores.values());
        Collections.sort(listaRet, new Comparator<CNPJValor>(){

            @Override
            public int compare(CNPJValor o1, CNPJValor o2) {
                return o1.totalValorPago.compareTo(o2.totalValorPago);
            }
        });
        String[] maiores = new String[qtd];
        for (int i = maiores.length - 1; i >= 0; --i) {
            maiores[i] = i < listaRet.size() ? ((CNPJValor)listaRet.get((int)(listaRet.size() - 1 - i))).cnpj : "";
        }
        return maiores;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator it = this.itens().iterator();
        String cpfMaior = "";
        Valor maiorValor = null;
        while (it.hasNext()) {
            Pagamento pgto = (Pagamento)it.next();
            if (!pgto.getCodigo().naoFormatado().equals("30") && !pgto.getCodigo().naoFormatado().equals("31") && !pgto.getCodigo().naoFormatado().equals("33") && !pgto.getCodigo().naoFormatado().equals("34") || pgto.getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            if (maiorValor == null) {
                maiorValor = pgto.getValorPago();
                cpfMaior = pgto.getNiBeneficiario().naoFormatado().substring(0, 11);
                continue;
            }
            if (!pgto.getValorPago().comparacao(">", maiorValor)) continue;
            maiorValor = pgto.getValorPago();
            cpfMaior = pgto.getNiBeneficiario().naoFormatado().substring(0, 11);
        }
        return cpfMaior;
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        Iterator it = this.itens().iterator();
        String cpfMaior = "";
        Valor maiorValor = null;
        while (it.hasNext()) {
            Pagamento pgto = (Pagamento)it.next();
            if (!pgto.getCodigo().naoFormatado().equals("50") || pgto.getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            if (maiorValor == null) {
                maiorValor = pgto.getValorPago();
                cpfMaior = pgto.getNiBeneficiario().naoFormatado().substring(0, 11);
                continue;
            }
            if (!pgto.getValorPago().comparacao(">", maiorValor)) continue;
            maiorValor = pgto.getValorPago();
            cpfMaior = pgto.getNiBeneficiario().naoFormatado().substring(0, 11);
        }
        return cpfMaior;
    }

    public ArrayList<String[]> recuperarDadosTresMaioresEmpregadasDomesticas() {
        HashMap<String, Valor> empregadas = new HashMap<String, Valor>();
        for (Pagamento pgto : this.itens()) {
            if (!pgto.getCodigo().naoFormatado().equals("50") || pgto.getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            Object key = "";
            key = pgto.getNitEmpregadoDomestico().naoFormatado().length() > 0 ? pgto.getNiBeneficiario().naoFormatado() + "-" + pgto.getNitEmpregadoDomestico().naoFormatado() : pgto.getNiBeneficiario().naoFormatado() + "- ";
            if (empregadas.containsKey(key)) {
                ((Valor)empregadas.get(key)).append('+', pgto.getValorPago());
                continue;
            }
            Valor novo = new Valor();
            novo.setConteudo(pgto.getValorPago());
            empregadas.put((String)key, novo);
        }
        EmpregadasComparator comparador = new EmpregadasComparator(empregadas);
        TreeMap<String, Valor> empregadasOrdenadas = new TreeMap<String, Valor>(comparador);
        empregadasOrdenadas.putAll(empregadas);
        Set<String> keys = empregadasOrdenadas.keySet();
        ArrayList<String[]> empregadasSelecionadas = new ArrayList<String[]>();
        for (String key : keys) {
            empregadasSelecionadas.add(key.split("-"));
        }
        return empregadasSelecionadas;
    }

    public NI[] recuperarMaioresNIsDepesasMedicas(int quantidade) {
        HashMap<String, Valor> beneficiarios = new HashMap<String, Valor>();
        NI[] listaNIs = new NI[quantidade];
        ArrayList nomesOrdenadosPorValor = new ArrayList();
        for (Pagamento pagamento : this.itens()) {
            if (!"09".equals(pagamento.getCodigo().naoFormatado()) && !"10".equals(pagamento.getCodigo().naoFormatado()) && !"11".equals(pagamento.getCodigo().naoFormatado()) && !"12".equals(pagamento.getCodigo().naoFormatado()) && !"13".equals(pagamento.getCodigo().naoFormatado()) && !"14".equals(pagamento.getCodigo().naoFormatado()) && !"21".equals(pagamento.getCodigo().naoFormatado()) && !"26".equals(pagamento.getCodigo().naoFormatado())) continue;
            Valor total = (Valor)beneficiarios.get(pagamento.getNiBeneficiario().naoFormatado());
            if (total == null) {
                total = new Valor();
                beneficiarios.put(pagamento.getNiBeneficiario().naoFormatado(), total);
            }
            total.append('+', pagamento.getValorPago());
        }
        if (!beneficiarios.isEmpty()) {
            beneficiarios.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(beneficiario -> {
                Map.Entry entrada = beneficiario;
                nomesOrdenadosPorValor.add((String)entrada.getKey());
            });
            for (int i = 0; i < quantidade; ++i) {
                int indice = nomesOrdenadosPorValor.size() - 1 - i;
                if (indice < 0 || indice >= nomesOrdenadosPorValor.size()) continue;
                NI ni = new NI();
                ni.setConteudo((String)nomesOrdenadosPorValor.get(indice));
                listaNIs[i] = ni;
            }
        }
        return listaNIs;
    }

    public boolean possuiDependente(String nomeDependente) {
        this.excluirRegistrosEmBranco();
        Iterator it = this.itens().iterator();
        if (nomeDependente != null && !nomeDependente.isEmpty()) {
            while (it.hasNext()) {
                Pagamento pgto = (Pagamento)it.next();
                if (!pgto.getDependenteOuAlimentando().naoFormatado().equals(nomeDependente) || !pgto.getTipo().naoFormatado().equals("D")) continue;
                return true;
            }
        }
        return false;
    }

    public void excluirPagamentosComDependente(String nomeDependente) {
        this.excluirRegistrosEmBranco();
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            Pagamento pgto = (Pagamento)it.next();
            if (!pgto.getDependenteOuAlimentando().naoFormatado().equals(nomeDependente) || !pgto.getTipo().naoFormatado().equals("D")) continue;
            it.remove();
        }
    }

    public void excluirPagamentosComAlimentando(String nomeAlimentando) {
        this.excluirRegistrosEmBranco();
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            Pagamento pgto = (Pagamento)it.next();
            if (!pgto.getDependenteOuAlimentando().naoFormatado().equals(nomeAlimentando) || !pgto.getTipo().naoFormatado().equals("A")) continue;
            it.remove();
        }
    }

    public boolean existePagamentosComAlimentando(String nomeAlimentando) {
        this.excluirRegistrosEmBranco();
        for (Pagamento pgto : this.itens()) {
            if (pgto.getDependenteOuAlimentando().naoFormatado().isEmpty() || !pgto.getDependenteOuAlimentando().naoFormatado().equals(nomeAlimentando) || !pgto.getTipo().naoFormatado().equals("A")) continue;
            return true;
        }
        return false;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> listaDependentes = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            listaDependentes.add(pagamento.getDependenteOuAlimentando().formatado());
        }
        int tam = 0;
        if (!listaDependentes.isEmpty()) {
            tam = listaDependentes.size();
        }
        return tam;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> listaDependentes = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            listaDependentes.add(pagamento.getDependenteOuAlimentando().formatado());
        }
        int tam = 0;
        if (!listaDependentes.isEmpty()) {
            tam = listaDependentes.size();
        }
        return tam;
    }

    public Valor obterTotalFunprespAteLimite(String tipoPagador) {
        Valor total = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.isFunpresp() || !pagamento.getTipo().naoFormatado().equals(tipoPagador)) continue;
            total.append('+', pagamento.getValorPagoFunprespCalculado());
        }
        return total;
    }

    public Valor obterTotalFunprespAcimaLimite(String tipoPagador) {
        Valor total = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.isFunpresp() || !pagamento.getTipo().naoFormatado().equals(tipoPagador)) continue;
            total.append('+', pagamento.getValorPagoAtravesFunpresp());
        }
        return total;
    }

    public Valor obterTotalDedutivelInstrucaoPorDependente(CPF cpfDependente) {
        Valor total = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.getCodigo().naoFormatado().equals("01") || !pagamento.getCPFDependente().naoFormatado().equals(cpfDependente.naoFormatado())) continue;
            total.append('+', pagamento.getValorPago());
        }
        if (total.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor())) {
            total.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDespesaInstrucao.getValor());
        }
        return total;
    }

    public Valor obterTotalDedutivelDespesasMedicasPorDependente(CPF cpfDependente) {
        Valor total = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.getCodigo().naoFormatado().equals("09") && !pagamento.getCodigo().naoFormatado().equals("10") && !pagamento.getCodigo().naoFormatado().equals("11") && !pagamento.getCodigo().naoFormatado().equals("12") && !pagamento.getCodigo().naoFormatado().equals("13") && !pagamento.getCodigo().naoFormatado().equals("14") && !pagamento.getCodigo().naoFormatado().equals("15") && !pagamento.getCodigo().naoFormatado().equals("16") && !pagamento.getCodigo().naoFormatado().equals("17") && !pagamento.getCodigo().naoFormatado().equals("18") && !pagamento.getCodigo().naoFormatado().equals("19") && !pagamento.getCodigo().naoFormatado().equals("20") && !pagamento.getCodigo().naoFormatado().equals("21") && !pagamento.getCodigo().naoFormatado().equals("22") && !pagamento.getCodigo().naoFormatado().equals("26") || !pagamento.getCPFDependente().naoFormatado().equals(cpfDependente.naoFormatado())) continue;
            total.append('+', pagamento.getValorPago());
        }
        return total;
    }

    public Valor obterTotalDedutivelPrevidenciaPorDependente(CPF cpfDependente, Valor rendimentos) {
        Valor total12porcento = new Valor();
        Valor totalIlimitado = new Valor();
        Valor percentual12 = TabelaAliquotasIRPF.ConstantesAliquotas.deducaoPrevidenciaPrivada.getValor().operacao('/', "100,00");
        Valor limite12porcento = rendimentos.operacao('*', percentual12);
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.getCPFDependente().naoFormatado().equals(cpfDependente.naoFormatado())) continue;
            if (pagamento.getCodigo().naoFormatado().equals("36")) {
                total12porcento.append('+', pagamento.getValorPago());
                continue;
            }
            if (!pagamento.getCodigo().naoFormatado().equals("37")) continue;
            totalIlimitado.append('+', pagamento.getValorPagoFunprespCalculado());
            total12porcento.append('+', pagamento.getValorPagoAtravesFunpresp());
        }
        if (total12porcento.comparacao(">", limite12porcento)) {
            total12porcento.setConteudo(limite12porcento);
        }
        return totalIlimitado.operacao('+', total12porcento);
    }

    public Valor obterTotalPensaoAlimenticiaPorDependente(CPF cpfDependente) {
        Valor total = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.getCPFDependente().naoFormatado().equals(cpfDependente.naoFormatado()) || !pagamento.isPensao()) continue;
            total.append('+', pagamento.getValorPago());
            total.append('-', pagamento.getParcelaNaoDedutivel());
        }
        return total;
    }

    public List<String> recuperarNISeisMaioresPagamentos() {
        int i;
        ArrayList<String> nis = new ArrayList<String>();
        HashMap<String, Valor> listaSumarizada = new HashMap<String, Valor>();
        for (Pagamento pagamento : this.itens()) {
            if (!this.getCodigosPagamentosDedutiveis().containsKey(pagamento.getCodigo().formatado())) continue;
            Valor valor = (Valor)listaSumarizada.get(pagamento.getNiBeneficiario().naoFormatado());
            Valor valorNovo = pagamento.getValorPago().operacao('-', pagamento.getParcelaNaoDedutivel());
            if (valorNovo.comparacao("<", "0,00")) {
                valor = new Valor();
            }
            if (valor != null) {
                listaSumarizada.put(pagamento.getNiBeneficiario().naoFormatado(), valorNovo.operacao('+', valor));
                continue;
            }
            listaSumarizada.put(pagamento.getNiBeneficiario().naoFormatado(), valorNovo);
        }
        LinkedList listaOrdenada = new LinkedList(listaSumarizada.entrySet());
        Collections.sort(listaOrdenada, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry x1 = (Map.Entry)o1;
                Map.Entry x2 = (Map.Entry)o2;
                return ((Valor)x2.getValue()).compareTo((Valor)x1.getValue());
            }
        });
        int numMaximoNIs = listaOrdenada.size() > 6 ? 6 : listaOrdenada.size();
        for (i = 1; i <= numMaximoNIs; ++i) {
            Map.Entry entrada = (Map.Entry)listaOrdenada.get(i - 1);
            nis.add((String)entrada.getKey());
        }
        for (i = listaOrdenada.size(); i < 6; ++i) {
            nis.add("");
        }
        return nis;
    }

    public String recuperarCNPJMaiorPagamentoFunpresp() {
        String cnpj = "";
        Valor valorMaiorPagamento = new Valor("0,00");
        for (Pagamento pagamento : this.itens()) {
            if (!"37".equals(pagamento.getCodigo().formatado()) || !pagamento.getValorPago().comparacao(">", valorMaiorPagamento)) continue;
            valorMaiorPagamento.setConteudo(pagamento.getValorPago());
            cnpj = pagamento.getNiBeneficiario().naoFormatado();
        }
        return cnpj;
    }

    public HashMap<String, String> getCodigosPagamentosDedutiveis() {
        HashMap<String, String> codigosDedutiveis = new HashMap<String, String>();
        codigosDedutiveis.put("01", "01");
        codigosDedutiveis.put("09", "09");
        codigosDedutiveis.put("10", "10");
        codigosDedutiveis.put("11", "11");
        codigosDedutiveis.put("12", "12");
        codigosDedutiveis.put("13", "13");
        codigosDedutiveis.put("14", "14");
        codigosDedutiveis.put("21", "21");
        codigosDedutiveis.put("26", "26");
        codigosDedutiveis.put("30", "30");
        codigosDedutiveis.put("33", "33");
        codigosDedutiveis.put("36", "36");
        codigosDedutiveis.put("37", "37");
        codigosDedutiveis.put("50", "50");
        return codigosDedutiveis;
    }

    public void verificarLegadoPagamentos() {
        for (Pagamento pagamento : this.itens()) {
            pagamento.verificarLegadoPagamento();
        }
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoPreviPrivada() {
        return this.totalContribuicaoPreviPrivada;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }

    public Valor getTotalContribuicaoFunpresp() {
        return this.totalContribuicaoFunpresp;
    }

    class EmpregadasComparator
    implements Comparator<String> {
        Map<String, Valor> base;

        public EmpregadasComparator(Map<String, Valor> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            if (this.base.get(a).comparacao(">=", this.base.get(b))) {
                return -1;
            }
            return 1;
        }
    }
}

