/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.Observador;

public class ObservadorNomeDependente
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public ObservadorNomeDependente(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                Dependente dependente = (Dependente)((Object)valorNovo);
                dependente.getNome().addObservador((Observador)this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                Dependente dependente = (Dependente)((Object)valorNovo);
                dependente.getNome().removeObservador((Observador)this);
            } else if (nomePropriedade.equals("Nome")) {
                this.atualizaPagamentos((String)valorAntigo, (String)valorNovo);
            }
        }
    }

    private void atualizaPagamentos(String nomeAntigo, String nomeNovo) {
        if (nomeAntigo != null && !nomeAntigo.isEmpty()) {
            for (Pagamento pagamento : this.declaracaoIRPF.getPagamentos().itens()) {
                String tipoPagamento = pagamento.getTipo().naoFormatado();
                if (!tipoPagamento.equals("D") || !pagamento.getDependenteOuAlimentando().naoFormatado().equals(nomeAntigo)) continue;
                pagamento.getDependenteOuAlimentando().setConteudo(nomeNovo);
            }
        }
    }
}

