/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class ObservadorAlimentando
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public ObservadorAlimentando(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                Alimentando alimentando = (Alimentando)((Object)valorNovo);
                alimentando.getNome().addObservador((Observador)this);
                alimentando.getCpf().addObservador((Observador)this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                Alimentando alimentandos = (Alimentando)((Object)valorNovo);
                alimentandos.getNome().removeObservador((Observador)this);
                alimentandos.getCpf().removeObservador((Observador)this);
            } else if (nomePropriedade.equals("Nome do alimentando")) {
                this.atualizaPagamentos((String)valorAntigo, (String)valorNovo, true);
            } else if (nomePropriedade.equals("CPF")) {
                this.atualizaPagamentos((String)valorAntigo, (String)valorNovo, false);
            }
        }
    }

    private void atualizaPagamentos(String valorAntigo, String valorNovo, boolean isNome) {
        if (valorAntigo != null) {
            ItemQuadroPensaoAlimenticia item;
            List qdAux;
            for (Pagamento pagamento : this.declaracaoIRPF.getPagamentos().itens()) {
                String codPagamento = pagamento.getCodigo().getConteudoAtual(0);
                String tipoPagamento = pagamento.getTipo().naoFormatado();
                if (!tipoPagamento.equals("A") && !codPagamento.equals("30") && !codPagamento.equals("31") && !codPagamento.equals("33") && !codPagamento.equals("34")) continue;
                if (isNome) {
                    if (valorAntigo.isEmpty() || !pagamento.getDependenteOuAlimentando().naoFormatado().equals(valorAntigo)) continue;
                    pagamento.getDependenteOuAlimentando().setConteudo(valorNovo);
                    continue;
                }
                if (valorAntigo.isEmpty() || !pagamento.getNiBeneficiario().naoFormatado().equals(valorAntigo)) continue;
                pagamento.getNiBeneficiario().setConteudo(valorNovo);
            }
            for (RendAcmDependente rendDependente : this.declaracaoIRPF.getRendAcm().getColecaoRendAcmDependente().itens()) {
                qdAux = rendDependente.getPensaoAlimenticiaQuadroAuxiliar().itens();
                for (ObjetoNegocio qdAuxItem : qdAux) {
                    item = (ItemQuadroPensaoAlimenticia)qdAuxItem;
                    if (valorAntigo.isEmpty() || !item.getAlimentando().naoFormatado().equals(valorAntigo)) continue;
                    item.getAlimentando().setConteudo(valorNovo);
                }
            }
            for (RendAcmTitular rendTitular : this.declaracaoIRPF.getRendAcm().getColecaoRendAcmTitular().itens()) {
                qdAux = rendTitular.getPensaoAlimenticiaQuadroAuxiliar().itens();
                for (ObjetoNegocio qdAuxItem : qdAux) {
                    item = (ItemQuadroPensaoAlimenticia)qdAuxItem;
                    if (valorAntigo.isEmpty() || !item.getAlimentando().naoFormatado().equals(valorAntigo)) continue;
                    item.getAlimentando().setConteudo(valorNovo);
                }
            }
        }
    }
}

