/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.herdeiros;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.gui.herdeiros.PainelHerdeirosLista;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class Herdeiro
extends ObjetoNegocio
implements ObjetoFicha {
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do herdeiro", 60);
    private NI niHerdeiro = new NI((ObjetoNegocio)this, "CPF/CNPJ do herdeiro");
    private String chave = null;
    private transient IdentificadorDeclaracao identificadorDeclaracao = null;

    public Herdeiro(IdentificadorDeclaracao idDeclaracao) {
        this.identificadorDeclaracao = idDeclaracao;
        CacheNI.getInstancia().registrarNINome(this.niHerdeiro, this.nome);
        this.getNiHerdeiro().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Herdeiro.this.getNiHerdeiro().naoFormatado().equals(Herdeiro.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("herdeiro_cpf_igual_titular"), 3);
                }
                return null;
            }
        });
        this.getNiHerdeiro().addValidador((ValidadorIf)new ValidadorNI(3));
        this.getNiHerdeiro().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("herdeiro_cpf_branco")));
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("herdeiro_nome_branco")));
        this.getNome().addValidador((ValidadorIf)new ValidadorNomeIRPF());
        this.getNome().addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public boolean isVazio() {
        return this.getNiHerdeiro().naoFormatado().equals("") && this.getNome().naoFormatado().equals("");
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = super.recuperarListaCamposPendencia();
        campos.add(this.niHerdeiro);
        campos.add(this.nome);
        return campos;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public NI getNiHerdeiro() {
        return this.niHerdeiro;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public Herdeiro obterCopia() {
        Herdeiro copia = new Herdeiro(IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao());
        copia.setChave(this.getChave());
        copia.getNiHerdeiro().setConteudo(this.getNiHerdeiro());
        copia.getNome().setConteudo(this.getNome());
        return copia;
    }

    public String toString() {
        return this.nome.naoFormatado();
    }

    public String getClasseFicha() {
        return PainelHerdeirosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Herdeiros";
    }
}

