/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import serpro.ppgd.irpf.gcap.DemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class GcapUtil {
    private static final String ARQUIVO_INI = "GCAP.INI";
    public static final int EM_TELA_PRINCIPAL = -1;
    public static final int EM_PREENCHIMENTO = 0;
    public static final int EM_PENDENCIA = 1;
    public static final int EM_IMPORTACAO = 2;
    private static String nomeArquivo = null;
    private static int estadoSistema = 0;
    private static final String DIR_DADOS;
    private static String DIR_TMP;
    private static String PATH_XML_ID_DEMONSTRATIVOS;

    public static String abreArquivo(String pFilePath) {
        StringBuilder lConteudo = new StringBuilder(200);
        try (InputStream lInputStream = GcapUtil.class.getResourceAsStream(pFilePath);
             InputStreamReader lInputStreamReader = new InputStreamReader(lInputStream);
             BufferedReader lBuffer = new BufferedReader(lInputStreamReader);){
            String lLinha = null;
            while ((lLinha = lBuffer.readLine()) != null) {
                lConteudo.append(lLinha);
                lConteudo.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            ControladorGui.tratarException((Exception)e);
        }
        catch (IOException e) {
            ControladorGui.tratarException((Exception)e);
        }
        return lConteudo.toString();
    }

    public static boolean isDeclaracaoBrasileira(DemonstrativoGCAP pDemonstrativo) {
        IdDemonstrativoGCAP id = pDemonstrativo.getIdDemonstrativo();
        return GcapUtil.isDeclaracaoBrasileira(id);
    }

    public static boolean isDeclaracaoBrasileira(IdDemonstrativoGCAP idDemonstrativo) {
        return "105".equals(idDemonstrativo.getPaisDeclarante().naoFormatado());
    }

    public static void desabilitarValidadores(Informacao<?> info) {
        List validadores = info.getListaValidadores();
        for (ValidadorIf v : validadores) {
            ((ValidadorDefault)v).setValidadorAtivo(false);
        }
    }

    public static void habilitarValidadores(Informacao<?> info) {
        List validadores = info.getListaValidadores();
        for (ValidadorIf v : validadores) {
            ((ValidadorDefault)v).setValidadorAtivo(true);
        }
    }

    public static void setEstadoSistema(int estadoSistema) {
        GcapUtil.estadoSistema = estadoSistema;
    }

    public static int getEstadoSistema() {
        return estadoSistema;
    }

    public static boolean deleteDir(String dir) {
        return GcapUtil.deleteDir(new File(dir));
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = GcapUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    static {
        String executandoSobJWS = System.getProperty("ppgd.jws");
        if (executandoSobJWS != null && executandoSobJWS.trim().equals("true")) {
            DIR_DADOS = System.getProperty("user.home") + "/GCAP" + ConstantesGlobais.EXERCICIO + "/aplicacao/dados";
        } else {
            String arqConf = UtilitariosArquivo.getPathAplicacao() + ARQUIVO_INI;
            if (new File(arqConf).exists()) {
                try {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(arqConf));
                    String dirDados = (String)prop.get("aplicacao.diretorio.dados");
                    if (!dirDados.trim().equals("")) {
                        FabricaUtilitarios.getProperties().setProperty("aplicacao.diretorio.dados", dirDados);
                    }
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
            DIR_DADOS = UtilitariosArquivo.getPathDados();
            DIR_TMP = DIR_DADOS + System.getProperty("file.separator") + "tmp";
            PATH_XML_ID_DEMONSTRATIVOS = DIR_DADOS + File.separator + "iddemonstrativos.xml";
        }
    }
}

