/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.perguntas;

import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PerguntasImovel
extends ObjetoNegocio {
    public static final String RESPOSTA_1 = "1";
    public static final String RESPOSTA_2 = "2";
    public static final String RESPOSTA_3 = "3";
    public static final String RESPOSTA_4 = "4";
    public static final String TXT_RESPOSTA_1 = "Adquiri ou pretendo adquirir outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato.";
    public static final String TXT_RESPOSTA_2 = "N\u00e3o adquiri outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato.";
    public static final String TXT_RESPOSTA_3 = "Pretendia adquirir outro im\u00f3vel residencial em at\u00e9 180 dias contados da celebra\u00e7\u00e3o do contrato, mas n\u00e3o o fiz neste prazo.";
    public static final String TXT_RESPOSTA_4 = "J\u00e1 utilizei este benef\u00edcio em per\u00edodo inferior a 5 anos.";
    public static final String LABEL_CAMPO_MP252 = "O produto da aliena\u00e7\u00e3o foi ou ser\u00e1 aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no Brasil no prazo de cento e oitenta dias, em conformidade com o art. 39 da Lei n\u00ba 11.196, de 2005?";
    public static final String LABEL_CAMPO_MP252_PARTE2 = "Qual foi o valor aplicado na aquisi\u00e7\u00e3o de im\u00f3veis residenciais localizados no Pa\u00eds?";
    public static final String LABEL_CAMPO_MP252_PRIMEIRA_ALIENACAO = "Voc\u00ea fez alguma outra aliena\u00e7\u00e3o de im\u00f3vel residencial, nos 180 dias anteriores \u00e0 data desta aliena\u00e7\u00e3o, que tamb\u00e9m usou, ou usar\u00e1, a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005?";
    public static final String LABEL_CAMPO_DATA_PRIMEIRA_ALIENACAO = "Data da primeira aliena\u00e7\u00e3o";
    private final Logico propriedadeOutroImovel = new Logico((ObjetoNegocio)this, "Voc\u00ea possui outro im\u00f3vel, seja como propriet\u00e1rio individual, em condom\u00ednio ou em comunh\u00e3o?");
    private final Logico outraAlienacao = new Logico((ObjetoNegocio)this, "Nos \u00faltimos cinco anos, voc\u00ea efetuou outra aliena\u00e7\u00e3o de im\u00f3vel a qualquer t\u00edtulo, tributada ou n\u00e3o?");
    private final Logico mP252 = new Logico((ObjetoNegocio)this, "O produto da aliena\u00e7\u00e3o foi ou ser\u00e1 aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no Brasil no prazo de cento e oitenta dias, em conformidade com o art. 39 da Lei n\u00ba 11.196, de 2005?");
    private Logico mP252Parte2 = new Logico((ObjetoNegocio)this, "Qual foi o valor aplicado na aquisi\u00e7\u00e3o de im\u00f3veis residenciais localizados no Pa\u00eds?");
    private final Logico imovelResidencial = new Logico((ObjetoNegocio)this, "O im\u00f3vel objeto desta aliena\u00e7\u00e3o \u00e9 residencial?");
    private final Alfa propriedadeOutroImovelAux = new Alfa((ObjetoNegocio)this, "Propriet\u00e1rio de outro im\u00f3vel?");
    private final Alfa outraAlienacaoAux = new Alfa((ObjetoNegocio)this, "Nos \u00faltimos cinco anos voc\u00ea efetuou outra aliena\u00e7ao?");
    private final Alfa mP252Aux = new Alfa((ObjetoNegocio)this, "Valor da aliena\u00e7\u00e3o foi aplicado no prazo de 180 dias?");
    private final Alfa imovelResidencialAux = new Alfa((ObjetoNegocio)this, "Im\u00f3vel Residencial?");
    private Logico mP252PrimeiraAlienacao = new Logico((ObjetoNegocio)this, "Voc\u00ea fez alguma outra aliena\u00e7\u00e3o de im\u00f3vel residencial, nos 180 dias anteriores \u00e0 data desta aliena\u00e7\u00e3o, que tamb\u00e9m usou, ou usar\u00e1, a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005?");
    private Data dataPrimeiraAlienacao = new Data((ObjetoNegocio)this, "Data da primeira aliena\u00e7\u00e3o");

    public PerguntasImovel() {
        this.adicionaOpcaoSimNao(this.propriedadeOutroImovel);
        this.adicionaOpcaoSimNao(this.outraAlienacao);
        this.adicionaOpcaoSimNao(this.imovelResidencial);
        this.adicionaOpcoesReaplicacao(this.mP252);
        this.adicionaOpcoesReaplicacaoParte2(this.mP252Parte2);
        this.adicionaOpcaoSimNao(this.mP252PrimeiraAlienacao);
        this.setReadOnlyPerguntasImovel();
    }

    public void setReadOnlyPerguntasImovel() {
        this.propriedadeOutroImovel.setReadOnly(true);
        this.propriedadeOutroImovel.setHabilitado(false);
        this.outraAlienacao.setReadOnly(true);
        this.outraAlienacao.setHabilitado(false);
        this.mP252.setReadOnly(true);
        this.mP252.setHabilitado(false);
        this.mP252Parte2.setReadOnly(true);
        this.mP252Parte2.setHabilitado(false);
        this.imovelResidencial.setReadOnly(true);
        this.imovelResidencial.setHabilitado(false);
        this.mP252PrimeiraAlienacao.setReadOnly(true);
        this.mP252PrimeiraAlienacao.setHabilitado(false);
        this.dataPrimeiraAlienacao.setReadOnly(true);
        this.dataPrimeiraAlienacao.setHabilitado(false);
    }

    protected void adicionaOpcaoSimNao(Logico item) {
        item.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        item.addOpcao(Logico.NAO, Logico.LABEL_NAO);
    }

    protected void adicionaOpcoesReaplicacaoParte2(Logico item) {
        item.addOpcao(Logico.SIM, "Total");
        item.addOpcao("P", "Parcial");
    }

    protected void adicionaOpcoesReaplicacao(Logico item) {
        item.addOpcao(RESPOSTA_1, TXT_RESPOSTA_1);
        item.addOpcao(RESPOSTA_2, TXT_RESPOSTA_2);
        item.addOpcao(RESPOSTA_3, TXT_RESPOSTA_3);
        item.addOpcao(RESPOSTA_4, TXT_RESPOSTA_4);
    }

    public Logico getPropriedadeOutroImovel() {
        return this.propriedadeOutroImovel;
    }

    public Logico getOutraAlienacao() {
        return this.outraAlienacao;
    }

    public Logico getMP252() {
        return this.mP252;
    }

    public Logico getMP252PrimeiraAlienacao() {
        return this.mP252PrimeiraAlienacao;
    }

    public Data getDataPrimeiraAlienacao() {
        return this.dataPrimeiraAlienacao;
    }

    public Logico getImovelResidencial() {
        return this.imovelResidencial;
    }

    public Alfa getPropriedadeOutroImovelAux() {
        return this.propriedadeOutroImovelAux;
    }

    public Alfa getOutraAlienacaoAux() {
        return this.outraAlienacaoAux;
    }

    public Alfa getMP252Aux() {
        return this.mP252Aux;
    }

    public Alfa getImovelResidencialAux() {
        return this.imovelResidencialAux;
    }

    public boolean isImovelResidencial() {
        return Logico.SIM.equals(this.getImovelResidencial().naoFormatado());
    }

    public boolean isValorReaplicadoTotalmente() {
        return Logico.SIM.equals(this.getMP252Parte2().naoFormatado());
    }

    public boolean isValorReaplicadoParcialmente() {
        return "P".equals(this.getMP252Parte2().naoFormatado());
    }

    public boolean isValorReaplicado() {
        return this.isValorReaplicadoTotalmente() || this.isValorReaplicadoParcialmente();
    }

    public boolean naoTemOutraAlienacao() {
        return Logico.NAO.equals(this.getOutraAlienacao().naoFormatado());
    }

    public boolean unicoImovel() {
        return Logico.NAO.equals(this.getPropriedadeOutroImovel().naoFormatado());
    }

    public Logico getMP252Parte2() {
        return this.mP252Parte2;
    }
}

