/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.adquirente.ColecaoAdquirente;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoParcelaAlienacao;
import serpro.ppgd.irpf.gcap.apuracao.Apuracao;
import serpro.ppgd.irpf.gcap.psocietarias.ColecaoParcelaAquisicaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.psocietarias.ParticipacaoSocietaria;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;

public class AlienacaoParticipacaoSocietaria
extends Alienacao
implements ObjetoGCAP {
    public static final String VALOR_PS_ACOES_PEQUENO_VALOR = "20.000,00";
    public static final String VALOR_PS_OUTROS_PEQUENO_VALOR = "35.000,00";
    public static final String NOME_FICHA_PSOCIETARIA = "Participa\u00e7\u00f5es Societ\u00e1rias";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_APURACAO_CUSTO_AQUISICAO = "Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static final String CODIGO_ESPECIE_ACOES = "A";
    public static final String CODIGO_ESPECIE_FII = "F";
    public static final String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "P";
    public static final String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "C";
    public static final String CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES = "E";
    public static final String CODIGO_ESPECIE_QUOTAS = "Q";
    public static final String CODIGO_ESPECIE_OUTRAS = "O";
    public static final String DESCRICAO_ESPECIE_ACOES = "A\u00e7\u00f5es";
    public static final String DESCRICAO_ESPECIE_FII = "F.I.I. (Fundos de Investimento Imobili\u00e1rio)";
    public static final String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "Fundos de Investimentos em Participa\u00e7\u00f5es";
    public static final String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES = "Fundos de Investimentos em Cotas de Investimentos em Fundos de Participa\u00e7\u00f5es";
    public static final String DESCRICAO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES = "Fundos de Investimento em Empresas Emergentes";
    public static final String DESCRICAO_ESPECIE_QUOTAS = "Quotas";
    public static final String DESCRICAO_ESPECIE_OUTRAS = "Outras";
    private ParticipacaoSocietaria participacaoSocietaria = new ParticipacaoSocietaria();
    private Apuracao apuracao = new Apuracao();
    private ColecaoParcelaAlienacao colecaoParcelaAlienacao = new ColecaoParcelaAlienacao(this);
    private ColecaoParcelaAquisicaoParticipacaoSocietaria colecaoParcelaAquisicaoParticipacaoSocietaria = new ColecaoParcelaAquisicaoParticipacaoSocietaria(this);
    private ColecaoAdquirente adquirentes = new ColecaoAdquirente();
    private Alfa alienacaoAPrazoPartSocAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);

    public AlienacaoParticipacaoSocietaria() {
        this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaParticipacaoSocietaria());
    }

    public ParticipacaoSocietaria getParticipacaoSocietaria() {
        return this.participacaoSocietaria;
    }

    @Override
    public Apuracao getApuracao() {
        return this.apuracao;
    }

    public ColecaoParcelaAlienacao getColecaoParcelaAlienacao() {
        return this.colecaoParcelaAlienacao;
    }

    public ColecaoParcelaAquisicaoParticipacaoSocietaria getColecaoParcelaAquisicaoParticipacaoSocietaria() {
        return this.colecaoParcelaAquisicaoParticipacaoSocietaria;
    }

    public ColecaoAdquirente getAdquirentes() {
        return this.adquirentes;
    }

    public Alfa getAlienacaoAPrazoPartSocAux() {
        return this.alienacaoAPrazoPartSocAux;
    }

    @Override
    public String obterAliquotaFixa() {
        String aliquota = null;
        int codigoNatureza = -1;
        if (!this.getNatureza().isVazio()) {
            codigoNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        if (CODIGO_ESPECIE_FII.equals(this.participacaoSocietaria.getEspecie().naoFormatado())) {
            aliquota = "0,200000000";
        } else if (codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codigoNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.participacaoSocietaria.getEspecie().naoFormatado()) || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES.equals(this.participacaoSocietaria.getEspecie().naoFormatado()) || CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.participacaoSocietaria.getEspecie().naoFormatado())) {
            aliquota = "0,150000000";
        }
        return aliquota;
    }
}

