/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBem;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class AlienacaoBem
extends Alienacao {
    public static int CODIGO_NATUREZA_VENDA = 1;
    public static int CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = 2;
    public static int CODIGO_NATUREZA_DESAPROPRIACAO = 3;
    public static int CODIGO_NATUREZA_DACAO_EM_PAGAMENTO = 4;
    public static int CODIGO_NATUREZA_OUTRAS_DOACOES = 5;
    public static int CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = 6;
    public static int CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = 7;
    public static int CODIGO_NATUREZA_CESSAO_DE_DIREITOS = 8;
    public static int CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = 9;
    public static int CODIGO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO = 18;
    public static int CODIGO_NATUREZA_OUTROS = 10;
    public static int CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = 11;
    public static int CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = 12;
    public static int CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = 13;
    public static int CODIGO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = 14;
    public static int CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES = 15;
    public static int CODIGO_NATUREZA_ALIENACAO_ACOES_BALCAO = 16;
    public static int CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA = 17;
    public static String DESCRICAO_NATUREZA_VENDA = "Venda";
    public static String DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = "Permuta com Recebimento de Torna";
    public static String DESCRICAO_NATUREZA_DESAPROPRIACAO = "Desapropria\u00e7\u00e3o";
    public static String DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO = "Da\u00e7\u00e3o em Pagamento";
    public static String DESCRICAO_NATUREZA_OUTRAS_DOACOES = "Outras Doa\u00e7\u00f5es";
    public static String DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = "Procura\u00e7\u00e3o em Causa Pr\u00f3pria";
    public static String DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = "Promessa de Compra e Venda";
    public static String DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS = "Cess\u00e3o de Direitos/Cr\u00e9ditos";
    public static String DESCRICAO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = "Liquida\u00e7\u00e3o ou Resgate de Aplica\u00e7\u00e3o Financeira";
    public static String DESCRICAO_DEPOSITO_CONTA_CORRENTE_CARTAO_CREDITO_DEBITO = "Dep\u00f3sitos em conta corrente, cart\u00e3o de cr\u00e9dito ou d\u00e9bito";
    public static String DESCRICAO_NATUREZA_OUTROS = "Outros";
    public static String DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = "Dissolu\u00e7\u00e3o da Sociedade Conjugal ou Uni\u00e3o Est\u00e1vel";
    public static String DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = "Transmiss\u00e3o Causa Mortis";
    public static String DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = "Doa\u00e7\u00e3o em Adiantamento da Leg\u00edtima";
    public static String DESCRICAO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = "Aliena\u00e7\u00f5es, resgates e outras transfer\u00eancias";
    public static String DESCRICAO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES = "Aliena\u00e7\u00e3o de A\u00e7\u00f5es em Bolsa de Valores";
    public static String DESCRICAO_NATUREZA_ALIENACAO_ACOES_BALCAO = "Aliena\u00e7\u00e3o de A\u00e7\u00f5es em Balc\u00e3o";
    public static String DESCRICAO_CREDITO_JUROS_APLICACAO_FINANCEIRA = "Cr\u00e9dito de Juros de Aplica\u00e7\u00e3o Financeira";
    public static final String VALOR_BEM_PEQUENO_VALOR = "35.000,00";
    public static final String VALOR_BEM_PEQUENO_VALOR_ACOES_BALCAO = "20.000,00";
    private ValorPositivo valorAlienacaoReal = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - Moenda Nacional (R$)");
    private ValorPositivo valorAlienacaoDolar = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o - Moeda Nacional (US$)");
    private ValorPositivo valorCorretagemReal = new ValorPositivo(this, "Custo de Corretagem - Moeda Nacional (R$)");
    private ValorPositivo valorCorretagemDolar = new ValorPositivo(this, "Custo de Corretagem - Moeda Nacional (US$)");
    private ValorPositivo cotacaoDolarDataAlienacao = new ValorPositivo(this, "Cota\u00e7\u00e3o do d\u00f3lar na data de aliena\u00e7\u00e3o", 9, 4);
    private Codigo paisAcordo = new Codigo((ObjetoNegocio)this, "Pa\u00eds com acordo Internacional/Reciprocidade de Tratamento", CadastroTabelasIRPF.recuperarPaisesExterior());
    private ValorPositivo valorImpostoExteriorReal = new ValorPositivo(this, "Valor do imposto em Reais (R$)");
    private ColecaoParcelaAlienacaoBem colecaoParcelaAlienacao = new ColecaoParcelaAlienacaoBem(this);
    private Logico inCobranca = new Logico((ObjetoNegocio)this, "Indicador de que o imposto devido dever\u00e1 ser cobrado e enviado ao CCPF");

    public AlienacaoBem() {
        this.getInCobranca().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getInCobranca().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.setReadOnlyAlienacaoBem();
    }

    public void setReadOnlyAlienacaoBem() {
        this.valorAlienacaoDolar.setReadOnly(true);
        this.valorCorretagemDolar.setReadOnly(true);
        this.cotacaoDolarDataAlienacao.setReadOnly(true);
        this.paisAcordo.setReadOnly(true);
        this.paisAcordo.setHabilitado(false);
        this.valorImpostoExteriorReal.setReadOnly(true);
    }

    public ValorPositivo getCotacaoDolarDataAlienacao() {
        return this.cotacaoDolarDataAlienacao;
    }

    public ValorPositivo getValorAlienacaoDolar() {
        return this.valorAlienacaoDolar;
    }

    public ValorPositivo getValorCorretagemDolar() {
        return this.valorCorretagemDolar;
    }

    public ValorPositivo getValorAlienacaoReal() {
        return this.valorAlienacaoReal;
    }

    public ValorPositivo getValorCorretagemReal() {
        return this.valorCorretagemReal;
    }

    public Codigo getPaisAcordo() {
        return this.paisAcordo;
    }

    public ValorPositivo getValorImpostoExteriorReal() {
        return this.valorImpostoExteriorReal;
    }

    public ColecaoParcelaAlienacaoBem getColecaoParcelaAlienacao() {
        return this.colecaoParcelaAlienacao;
    }

    public Logico getInCobranca() {
        return this.inCobranca;
    }

    @Override
    public String obterAliquotaFixa() {
        String aliquota = null;
        int codigoNatureza = -1;
        if (!this.getNatureza().isVazio()) {
            codigoNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        if (codigoNatureza == CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || codigoNatureza == CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || codigoNatureza == CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS) {
            aliquota = "0,150000000";
        }
        return aliquota;
    }

    public ValorPositivo getValorIsencao() {
        ValorPositivo valorIsencao = new ValorPositivo(null, "valorIsencao", 10, 2);
        valorIsencao.setConteudo(VALOR_BEM_PEQUENO_VALOR);
        return valorIsencao;
    }

    public boolean isValorOperacaoMaior35K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isValorOperacaoMaior440K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (valorAlienacaoReal.comparacao(">", "440.000,00")) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isValorParcelasMaior35K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                valorAlienacaoReal.append('+', p.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                ValorPositivo somaParcela = new ValorPositivo();
                somaParcela.setConteudo(p.getValorRecebidoDolar());
                somaParcela.append('*', p.getCotacaoDolar());
                valorAlienacaoReal.append('+', somaParcela);
            }
        }
        if (valorAlienacaoReal.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            retorno = true;
        }
        return retorno;
    }

    @Override
    public boolean isAdquirenteRequerido() {
        boolean requerido = super.isAdquirenteRequerido();
        if (requerido && !this.isAlienacaoBrasil() && (String.valueOf(CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA).equals(this.getNatureza().naoFormatado()) || String.valueOf(CODIGO_NATUREZA_ALIENACAO_ACOES_BOLSA_VALORES).equals(this.getNatureza().naoFormatado()) || String.valueOf(CODIGO_NATUREZA_CREDITO_JUROS_APLICACAO_FINANCEIRA).equals(this.getNatureza().naoFormatado()))) {
            requerido = false;
        }
        return requerido;
    }

    public boolean podePreencherCalculo() {
        boolean retorno = true;
        if (this.getAlienacaoAPrazo().isVazio() || this.getNatureza().isVazio() || !this.isAlienacaoBrasil() && this.getAquisicao().getOrigemRendimentos().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    public boolean isValorParcelasMaior440K() {
        boolean retorno = false;
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                valorAlienacaoReal.append('+', p.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                ValorPositivo somaParcela = new ValorPositivo();
                somaParcela.setConteudo(p.getValorRecebidoDolar());
                somaParcela.append('*', p.getCotacaoDolar());
                valorAlienacaoReal.append('+', somaParcela);
            }
        }
        if (valorAlienacaoReal.comparacao(">", "440.000,00")) {
            retorno = true;
        }
        return retorno;
    }

    public abstract Aquisicao getAquisicao();

    @Override
    public abstract ApuracaoBem getApuracao();

    public abstract ApuracaoBem getApuracaoFinal();
}

