/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gcap.DemonstrativoGCAP;
import serpro.ppgd.irpf.txt.importacao.gcap.RepositorioXMLDadosGCAP;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class ProcessoImportacaoGCAP {
    public static void main(String[] args) {
        try {
            ProcessoImportacaoGCAP processo = new ProcessoImportacaoGCAP();
            DemonstrativoGCAP demonstrativoGCAP = processo.importar(new File("/home/01103312570/Desktop/12282577019-0101-3112-GCAP-2018.DEC"));
            System.out.println("Importou CPF: " + demonstrativoGCAP.getIdDemonstrativo().getCpf().formatado());
        }
        catch (AplicacaoException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public DemonstrativoGCAP importar(File arquivoZip) throws AplicacaoException {
        if (!arquivoZip.exists()) {
            throw new AplicacaoException("arquivo_inexistente");
        }
        File dirDestino = this.criarDiretorioDestino();
        if (dirDestino == null) {
            throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
        }
        try {
            File arqXML = this.descompatarDemonstrativo(arquivoZip, dirDestino);
            if (arqXML == null) {
                throw new AplicacaoException("gcap_arquivo_exportacao_invalido", new String[]{"1.6", String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)});
            }
            this.verificarVersaoDemonstrativo(dirDestino, arqXML);
            RepositorioXMLDadosGCAP repositorioXml = new RepositorioXMLDadosGCAP();
            DemonstrativoGCAP demonstrativoGCAP = repositorioXml.importaDados(arqXML);
            return demonstrativoGCAP;
        }
        catch (Exception ex) {
            if (ex instanceof AplicacaoException) {
                throw (AplicacaoException)ex;
            }
            throw new AplicacaoException("demonstrativo_gcap_corrompido");
        }
        finally {
            if (dirDestino != null) {
                try {
                    FileUtils.forceDelete((File)dirDestino);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File descompatarDemonstrativo(File arquivoZip, File dirDestino) throws AplicacaoException {
        File arqXML = null;
        try {
            if (dirDestino == null) {
                throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(arquivoZip));){
                try (ZipInputStream zin = new ZipInputStream(in);){
                    ZipEntry e;
                    while ((e = zin.getNextEntry()) != null) {
                        try (FileOutputStream out = new FileOutputStream(dirDestino.getAbsoluteFile() + File.separator + e.getName());){
                            byte[] b = new byte[512];
                            int len = 0;
                            while ((len = zin.read(b)) != -1) {
                                out.write(b, 0, len);
                            }
                            out.close();
                        }
                        if (arquivoZip.getName().length() != e.getName().length() || e.getName().length() <= 11) continue;
                        arqXML = new File(dirDestino.getAbsolutePath() + File.separator + e.getName());
                    }
                    zin.close();
                }
                ((InputStream)in).close();
            }
            return arqXML;
        }
        catch (IOException ioex) {
            throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
        }
    }

    private File criarDiretorioDestino() {
        File dirDestino = null;
        try {
            Path p = new File(UtilitariosArquivo.getPathDados()).toPath();
            p = Files.createTempDirectory(p, ".temp", new FileAttribute[0]);
            dirDestino = p.toFile();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return dirDestino;
    }

    private void verificarVersaoDemonstrativo(File dirConfig, File arquivoXML) throws AplicacaoException {
        File configFile = new File(dirConfig.getAbsoluteFile() + File.separator + "config.properties");
        if (!configFile.exists()) {
            throw new AplicacaoException("gcap_arquivo_exportacao_invalido", new String[]{"1.6", String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)});
        }
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(configFile);){
            props.load(input);
            String versao = props.getProperty("pgd_version");
            if (!"1.6".equals(versao)) {
                String msg = MensagemUtil.getMensagem("gcap_versao_invalida", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1), "1.6"});
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msg, "Erro", 0);
                throw new AplicacaoException("gcap_versao_invalida", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1), "1.6"});
            }
            String hLido = props.getProperty("hash");
            String hCalculado = IRPFFacade.calcularHashMD5(arquivoXML);
            if (!hCalculado.equals(hLido)) {
                throw new AplicacaoException("demonstrativo_gcap_corrompido", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)});
            }
        }
        catch (IOException ex) {
            throw new AplicacaoException("gcap_arquivo_exportacao_invalido", new String[]{"1.6", String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1)});
        }
    }
}

