/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap;

import java.util.List;
import java.util.Objects;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gui.gcap.bensimoveis.PainelListaBemImovel;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;

public class IdDemonstrativoGCAP
extends ObjetoNegocio
implements ObjetoGCAP,
ObjetoFicha {
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private DataHora dataUltimoAcesso = new DataHora((ObjetoNegocio)this, "Data \u00daltimo Acesso");
    private Alfa exercicio = new Alfa((ObjetoNegocio)this, "Exerc\u00edcio", 4);
    private Data dataInicioPermanencia = new Data((ObjetoNegocio)this, "Data Inicio Perman\u00eancia");
    private Data dataFimPermanencia = new Data((ObjetoNegocio)this, "Data Fim Perman\u00eancia");
    private Codigo paisDeclarante = new Codigo((ObjetoNegocio)this, "Pais Declarante", CadastroTabelasIRPF.recuperarPaises());
    private Alfa telefoneDeclarante = new Alfa((ObjetoNegocio)this, "Telefone Declarante", 10);
    private Alfa dddDeclarante = new Alfa((ObjetoNegocio)this, "Telefone Declarante", 2);
    private Logico territorioParaisoFiscal = new Logico((ObjetoNegocio)this, "Territ\u00f3rio Paraso Fiscal");

    public IdDemonstrativoGCAP() {
        this.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.setFicha("Ganhos de Capital");
    }

    public Alfa getNome() {
        return this.nome;
    }

    @Override
    public CPF getCpf() {
        return this.cpf;
    }

    public Alfa getExercicio() {
        return this.exercicio;
    }

    public DataHora getDataUltimoAcesso() {
        return this.dataUltimoAcesso;
    }

    @Override
    public Data getDataInicioPermanencia() {
        return this.dataInicioPermanencia;
    }

    @Override
    public Data getDataFimPermanencia() {
        return this.dataFimPermanencia;
    }

    public Codigo getPaisDeclarante() {
        return this.paisDeclarante;
    }

    public Alfa getTelefoneDeclarante() {
        return this.telefoneDeclarante;
    }

    public Alfa getDddDeclarante() {
        return this.dddDeclarante;
    }

    public Logico getTerritorioParaisoFiscal() {
        return this.territorioParaisoFiscal;
    }

    public boolean equals(Object obj) {
        return obj instanceof IdDemonstrativoGCAP && ((IdDemonstrativoGCAP)obj).getCpf().naoFormatado().equals(this.getCpf().naoFormatado());
    }

    public int hashCode() {
        return Objects.hash(this.cpf.naoFormatado());
    }

    public boolean paisTemTerritorioParaisoFiscal() {
        return !this.paisDeclarante.isVazio() && !"".equals(this.paisDeclarante.getConteudoAtual(3).trim());
    }

    public boolean isParaisoFiscal() {
        return this.getPaisDeclarante().getConteudoAtual(2).equals(Logico.SIM);
    }

    public boolean isTerritorioParaisoFiscal() {
        return this.getTerritorioParaisoFiscal().naoFormatado().equals(Logico.SIM);
    }

    public boolean isDemonstrativoBrasil() {
        return "105".equals(this.getPaisDeclarante().getConteudoAtual(0));
    }

    public boolean isDemonstrativoExterior() {
        return !"105".equals(this.getPaisDeclarante().getConteudoAtual(0));
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getCpf());
        return lista;
    }

    public String getClasseFicha() {
        return PainelListaBemImovel.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Ganho de Capital";
    }
}

