/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.ColecaoIdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.DemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoAlienacaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacao;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.consolidacao.ColecaoConsolidacao;
import serpro.ppgd.irpf.gcap.consolidacao.ColecaoConsolidacaoEspecie;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.irpf.gcap.consolidacao.ConsolidacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.ColecaoMoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.ColecaoTotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gcap.especie.MoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.TotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class GCAP
extends ObjetoNegocio {
    private ColecaoIdDemonstrativoGCAP ids = new ColecaoIdDemonstrativoGCAP();
    private ColecaoAlienacaoBemImovel bensImoveis = new ColecaoAlienacaoBemImovel();
    private ColecaoAlienacaoBemMovel bensMoveis = new ColecaoAlienacaoBemMovel();
    private ColecaoAlienacaoParticipacaoSocietaria pSocietarias = new ColecaoAlienacaoParticipacaoSocietaria();
    private ColecaoMoedaAlienada especie = new ColecaoMoedaAlienada();
    private ColecaoConsolidacao consolidacoesBrasil = new ColecaoConsolidacao();
    private ColecaoConsolidacao consolidacoesExterior = new ColecaoConsolidacao();
    private Consolidacao consolidacaoGeralBrasil = new Consolidacao();
    private Consolidacao consolidacaoGeralExterior = new Consolidacao();
    private ColecaoConsolidacaoEspecie consolidacaoGeralEspecie = new ColecaoConsolidacaoEspecie();
    private ColecaoTotalizacaoMoedasAlienadas colecaoTotalizacaoMoedasAlienadas = new ColecaoTotalizacaoMoedasAlienadas();

    public Alienacao obterAlienacaoPorCPFPeriodo(String cpf, String dataInicio, String dataFim, String idAlienacao, Colecao<? extends Alienacao> alienacoes) {
        for (Alienacao alienacao : alienacoes.itens()) {
            if (!alienacao.getCpf().naoFormatado().equals(cpf) || !alienacao.getDataInicioPermanencia().naoFormatado().equals(dataInicio) || !alienacao.getDataFimPermanencia().naoFormatado().equals(dataFim) || !alienacao.getCodigoOperacao().naoFormatado().equals(idAlienacao)) continue;
            return alienacao;
        }
        return null;
    }

    public AlienacaoBemImovel obterAlienacaoBemImovelPorCPFPeriodo(String cpf, String dataInicio, String dataFim, String idAlienacao, Colecao<AlienacaoBemImovel> alienacoes) {
        return (AlienacaoBemImovel)this.obterAlienacaoPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, alienacoes);
    }

    public AlienacaoBemMovel obterAlienacaoBemMovelPorCPFPeriodo(String cpf, String dataInicio, String dataFim, String idAlienacao, Colecao<AlienacaoBemMovel> alienacoes) {
        return (AlienacaoBemMovel)this.obterAlienacaoPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, alienacoes);
    }

    public AlienacaoParticipacaoSocietaria obterAlienacaoPArticipacaoSocietariaPorCPFPeriodo(String cpf, String dataInicio, String dataFim, String idAlienacao, Colecao<AlienacaoParticipacaoSocietaria> alienacoes) {
        return (AlienacaoParticipacaoSocietaria)this.obterAlienacaoPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, alienacoes);
    }

    public IdDemonstrativoGCAP obterIdDemonstrativoGCAP(String cpfDemonstrativo, String dataInicio, String dataFim) {
        for (IdDemonstrativoGCAP idDemonstrativo : this.getIds().itens()) {
            if (!idDemonstrativo.getCpf().naoFormatado().equals(cpfDemonstrativo) || !idDemonstrativo.getDataInicioPermanencia().naoFormatado().equals(dataInicio) || !idDemonstrativo.getDataFimPermanencia().naoFormatado().equals(dataFim)) continue;
            return idDemonstrativo;
        }
        return null;
    }

    public ColecaoIdDemonstrativoGCAP getIds() {
        return this.ids;
    }

    public ColecaoAlienacaoBemImovel getBensImoveis() {
        return this.bensImoveis;
    }

    public ColecaoAlienacaoBemMovel getBensMoveis() {
        return this.bensMoveis;
    }

    public ColecaoAlienacaoParticipacaoSocietaria getpSocietarias() {
        return this.pSocietarias;
    }

    public ColecaoMoedaAlienada getEspecie() {
        return this.especie;
    }

    public ColecaoConsolidacao getConsolidacoesBrasil() {
        return this.consolidacoesBrasil;
    }

    public ColecaoConsolidacao getConsolidacoesExterior() {
        return this.consolidacoesExterior;
    }

    public Consolidacao getConsolidacaoGeralBrasil() {
        return this.consolidacaoGeralBrasil;
    }

    public Consolidacao getConsolidacaoGeralExterior() {
        return this.consolidacaoGeralExterior;
    }

    public ColecaoConsolidacaoEspecie getConsolidacaoGeralEspecie() {
        return this.consolidacaoGeralEspecie;
    }

    public ColecaoTotalizacaoMoedasAlienadas getColecaoTotalizacaoMoedasAlienadas() {
        return this.colecaoTotalizacaoMoedasAlienadas;
    }

    public boolean existeDemonstrativoParaCPFPeriodo(CPF cpf, Data dataInicio, Data dataFim) {
        boolean retorno = false;
        for (IdDemonstrativoGCAP id : this.ids.itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf.naoFormatado()) || !id.getDataInicioPermanencia().naoFormatado().equals(dataInicio.naoFormatado()) || !id.getDataFimPermanencia().naoFormatado().equals(dataFim.naoFormatado())) continue;
            retorno = true;
        }
        return retorno;
    }

    public boolean existeDemonstrativoParaCPF(String cpf) {
        boolean retorno = false;
        for (IdDemonstrativoGCAP id : this.ids.itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf)) continue;
            retorno = true;
        }
        return retorno;
    }

    public IdDemonstrativoGCAP obterIdDemonstrativoGCAPAssociado(ObjetoGCAP objetoGCAP) {
        IdDemonstrativoGCAP id = null;
        for (IdDemonstrativoGCAP idDemonstrativoGCAP : this.getIds().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(idDemonstrativoGCAP, objetoGCAP)) continue;
            id = idDemonstrativoGCAP;
            break;
        }
        return id;
    }

    public static boolean objetoGCAPestaAssociadoAId(IdDemonstrativoGCAP id, ObjetoGCAP objGCAP) {
        boolean retorno = false;
        if (id.getCpf().naoFormatado().equals(objGCAP.getCpf().naoFormatado()) && id.getDataInicioPermanencia().naoFormatado().equals(objGCAP.getDataInicioPermanencia().naoFormatado()) && id.getDataFimPermanencia().naoFormatado().equals(objGCAP.getDataFimPermanencia().naoFormatado())) {
            retorno = true;
        }
        return retorno;
    }

    public boolean existeDemonstrativoJaImportado(DemonstrativoGCAP demonstrativoGCAP) {
        boolean existe = false;
        for (IdDemonstrativoGCAP idDemonstrativoGCAP : ControladorGui.getDemonstrativoAberto().getGCAP().getIds().itens()) {
            if (!GCAP.objetosGCAPIguais(demonstrativoGCAP.getIdDemonstrativo(), idDemonstrativoGCAP)) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public static boolean objetosGCAPIguais(ObjetoGCAP idA, ObjetoGCAP idB) {
        boolean iguais = false;
        if (idA.getCpf().naoFormatado().equals(idB.getCpf().naoFormatado()) && idA.getDataInicioPermanencia().naoFormatado().equals(idB.getDataInicioPermanencia().naoFormatado()) && idA.getDataFimPermanencia().naoFormatado().equals(idB.getDataFimPermanencia().naoFormatado())) {
            iguais = true;
        }
        return iguais;
    }

    public void removerObjetoGCAP(ObjetoGCAP id, Colecao colecao) {
        ObjetoGCAP objRemover = null;
        for (Object obj : colecao.itens()) {
            if (!(obj instanceof ObjetoGCAP) || !GCAP.objetosGCAPIguais(id, (ObjetoGCAP)obj)) continue;
            objRemover = (ObjetoGCAP)obj;
            break;
        }
        if (objRemover != null && objRemover instanceof ObjetoNegocio) {
            colecao.remove((ObjetoNegocio)objRemover);
        }
    }

    public void removerDemonstrativo(ObjetoGCAP objetoGCAPSelecionado) {
        IdDemonstrativoGCAP idRemover = null;
        ColecaoAlienacaoBemImovel bensImoveisRemover = new ColecaoAlienacaoBemImovel();
        ColecaoAlienacaoBemMovel bensMoveisRemover = new ColecaoAlienacaoBemMovel();
        ColecaoAlienacaoParticipacaoSocietaria pSocietariasRemover = new ColecaoAlienacaoParticipacaoSocietaria();
        ColecaoMoedaAlienada especieRemover = new ColecaoMoedaAlienada();
        ColecaoConsolidacao consolidacoesBRRemover = new ColecaoConsolidacao();
        ColecaoConsolidacao consolidacoesEXRemover = new ColecaoConsolidacao();
        ColecaoConsolidacaoEspecie consolidacoesEspecieRemover = new ColecaoConsolidacaoEspecie();
        ColecaoTotalizacaoMoedasAlienadas colecaoTotalizacaoMoedasAlienadasRemover = new ColecaoTotalizacaoMoedasAlienadas();
        for (IdDemonstrativoGCAP id : this.getIds().itens()) {
            if (!GCAP.objetosGCAPIguais(id, objetoGCAPSelecionado)) continue;
            idRemover = id;
            for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
                if (!GCAP.objetosGCAPIguais(imovel, objetoGCAPSelecionado)) continue;
                bensImoveisRemover.add(imovel);
            }
            for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
                if (!GCAP.objetosGCAPIguais(movel, objetoGCAPSelecionado)) continue;
                bensMoveisRemover.add(movel);
            }
            for (AlienacaoParticipacaoSocietaria pSocietaria : this.getpSocietarias().itens()) {
                if (!GCAP.objetosGCAPIguais(pSocietaria, objetoGCAPSelecionado)) continue;
                pSocietariasRemover.add(pSocietaria);
            }
            for (MoedaAlienada especie : this.getEspecie().itens()) {
                if (!GCAP.objetosGCAPIguais(especie, objetoGCAPSelecionado)) continue;
                especieRemover.add(especie);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacoesBrasil().itens()) {
                if (!GCAP.objetosGCAPIguais(consolidacao, objetoGCAPSelecionado)) continue;
                consolidacoesBRRemover.add(consolidacao);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacoesExterior().itens()) {
                if (!GCAP.objetosGCAPIguais(consolidacao, objetoGCAPSelecionado)) continue;
                consolidacoesEXRemover.add(consolidacao);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacaoGeralEspecie().itens()) {
                if (!GCAP.objetosGCAPIguais(consolidacao, objetoGCAPSelecionado)) continue;
                consolidacoesEspecieRemover.add(consolidacao);
            }
            for (TotalizacaoMoedasAlienadas totalizacao : this.getColecaoTotalizacaoMoedasAlienadas().itens()) {
                if (!GCAP.objetosGCAPIguais(totalizacao, objetoGCAPSelecionado)) continue;
                colecaoTotalizacaoMoedasAlienadasRemover.add(totalizacao);
            }
            this.getIds().remove(idRemover);
            for (AlienacaoBemImovel imovel : bensImoveisRemover.itens()) {
                this.getBensImoveis().remove(imovel);
            }
            for (AlienacaoBemMovel movel : bensMoveisRemover.itens()) {
                this.getBensMoveis().remove(movel);
            }
            for (AlienacaoParticipacaoSocietaria pSocietaria : pSocietariasRemover.itens()) {
                this.getpSocietarias().remove(pSocietaria);
            }
            for (MoedaAlienada especie : especieRemover.itens()) {
                this.getEspecie().remove(especie);
            }
            for (ObjetoNegocio consolidacao : consolidacoesBRRemover.itens()) {
                this.getConsolidacoesBrasil().remove(consolidacao);
            }
            for (ObjetoNegocio consolidacao : consolidacoesEXRemover.itens()) {
                this.getConsolidacoesExterior().remove(consolidacao);
            }
            for (ObjetoNegocio consolidacao : consolidacoesEspecieRemover.itens()) {
                this.getConsolidacaoGeralEspecie().remove(consolidacao);
            }
            for (TotalizacaoMoedasAlienadas totalizacao : colecaoTotalizacaoMoedasAlienadasRemover.itens()) {
                this.getColecaoTotalizacaoMoedasAlienadas().remove(totalizacao);
            }
        }
    }

    public void removerDemonstrativosPorCPF(String cpf) {
        IdDemonstrativoGCAP idRemover = null;
        ColecaoAlienacaoBemImovel bensImoveisRemover = new ColecaoAlienacaoBemImovel();
        ColecaoAlienacaoBemMovel bensMoveisRemover = new ColecaoAlienacaoBemMovel();
        ColecaoAlienacaoParticipacaoSocietaria pSocietariasRemover = new ColecaoAlienacaoParticipacaoSocietaria();
        ColecaoMoedaAlienada especieRemover = new ColecaoMoedaAlienada();
        ColecaoConsolidacao consolidacoesBRRemover = new ColecaoConsolidacao();
        ColecaoConsolidacao consolidacoesEXRemover = new ColecaoConsolidacao();
        ColecaoConsolidacaoEspecie consolidacoesEspecieRemover = new ColecaoConsolidacaoEspecie();
        ColecaoTotalizacaoMoedasAlienadas colecaoTotalizacaoMoedasAlienadasRemover = new ColecaoTotalizacaoMoedasAlienadas();
        for (IdDemonstrativoGCAP id : this.getIds().itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf)) continue;
            idRemover = id;
            for (AlienacaoBemImovel imovel : this.getBensImoveis().itens()) {
                if (!imovel.getCpf().naoFormatado().equals(cpf)) continue;
                bensImoveisRemover.add(imovel);
            }
            for (AlienacaoBemMovel movel : this.getBensMoveis().itens()) {
                if (!movel.getCpf().naoFormatado().equals(cpf)) continue;
                bensMoveisRemover.add(movel);
            }
            for (AlienacaoParticipacaoSocietaria pSocietaria : this.getpSocietarias().itens()) {
                if (!pSocietaria.getCpf().naoFormatado().equals(cpf)) continue;
                pSocietariasRemover.add(pSocietaria);
            }
            for (MoedaAlienada especie : this.getEspecie().itens()) {
                if (!especie.getCpf().naoFormatado().equals(cpf)) continue;
                especieRemover.add(especie);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacoesBrasil().itens()) {
                if (!consolidacao.getCpf().naoFormatado().equals(cpf)) continue;
                consolidacoesBRRemover.add(consolidacao);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacoesExterior().itens()) {
                if (!consolidacao.getCpf().naoFormatado().equals(cpf)) continue;
                consolidacoesEXRemover.add(consolidacao);
            }
            for (ObjetoNegocio consolidacao : this.getConsolidacaoGeralEspecie().itens()) {
                if (!consolidacao.getCpf().naoFormatado().equals(cpf)) continue;
                consolidacoesEspecieRemover.add(consolidacao);
            }
            for (TotalizacaoMoedasAlienadas totalizacao : this.getColecaoTotalizacaoMoedasAlienadas().itens()) {
                if (!totalizacao.getCpf().naoFormatado().equals(cpf)) continue;
                colecaoTotalizacaoMoedasAlienadasRemover.add(totalizacao);
            }
            this.getIds().remove(idRemover);
            for (AlienacaoBemImovel imovel : bensImoveisRemover.itens()) {
                this.getBensImoveis().remove(imovel);
            }
            for (AlienacaoBemMovel movel : bensMoveisRemover.itens()) {
                this.getBensMoveis().remove(movel);
            }
            for (AlienacaoParticipacaoSocietaria pSocietaria : pSocietariasRemover.itens()) {
                this.getpSocietarias().remove(pSocietaria);
            }
            for (MoedaAlienada especie : especieRemover.itens()) {
                this.getEspecie().remove(especie);
            }
            for (ObjetoNegocio consolidacao : consolidacoesBRRemover.itens()) {
                this.getConsolidacoesBrasil().remove(consolidacao);
            }
            for (ObjetoNegocio consolidacao : consolidacoesEXRemover.itens()) {
                this.getConsolidacoesExterior().remove(consolidacao);
            }
            for (ObjetoNegocio consolidacao : consolidacoesEspecieRemover.itens()) {
                this.getConsolidacaoGeralEspecie().remove(consolidacao);
            }
            for (TotalizacaoMoedasAlienadas totalizacao : colecaoTotalizacaoMoedasAlienadasRemover.itens()) {
                this.getColecaoTotalizacaoMoedasAlienadas().remove(totalizacao);
            }
        }
    }

    public void incluirDemonstrativo(DemonstrativoGCAP demonstrativoGCAP) {
        demonstrativoGCAP.associarAlienacoesIdDemonstrativo();
        this.getIds().add(demonstrativoGCAP.getIdDemonstrativo());
        for (AlienacaoBemImovel imovel : demonstrativoGCAP.getBensImoveis().itens()) {
            this.getBensImoveis().add(imovel);
        }
        for (AlienacaoBemMovel movel : demonstrativoGCAP.getBensMoveis().itens()) {
            this.getBensMoveis().add(movel);
        }
        for (AlienacaoParticipacaoSocietaria pSocietaria : demonstrativoGCAP.getParticipacoesSocietarias().itens()) {
            this.getpSocietarias().add(pSocietaria);
        }
        for (MoedaAlienada especie : demonstrativoGCAP.getMoedasAlienadas().itens()) {
            this.getEspecie().add(especie);
        }
        this.getColecaoTotalizacaoMoedasAlienadas().add(demonstrativoGCAP.getTotalizacaoMoedasAlienadas());
        this.removerObjetoGCAP(demonstrativoGCAP.getConsolidacaoBrasil(), this.getConsolidacoesBrasil());
        this.getConsolidacoesBrasil().add(demonstrativoGCAP.getConsolidacaoBrasil());
        this.removerObjetoGCAP(demonstrativoGCAP.getConsolidacaoExterior(), this.getConsolidacoesExterior());
        this.getConsolidacoesExterior().add(demonstrativoGCAP.getConsolidacaoExterior());
        this.getConsolidacaoGeralEspecie().adicionarConsolidacaoEspecia(demonstrativoGCAP.getMoedasAlienadas());
        this.recalcularConsolidacoes();
    }

    public void recalcularConsolidacoes() {
        ValorPositivo impostoDevidoAnoAtual = new ValorPositivo();
        ValorPositivo impostoDiferidoAnosAnteriores = new ValorPositivo();
        ValorPositivo ImpostoDiferidoAnosPosteriores = new ValorPositivo();
        ValorPositivo ImpostoReferenteAlienacaoAnoAtual = new ValorPositivo();
        ValorPositivo ImpostoTotal = new ValorPositivo();
        ValorPositivo totalImpostoPago = new ValorPositivo();
        ValorPositivo totalRendIsentosNaoTributaveis = new ValorPositivo();
        ValorPositivo totalRendSujeitosTributacao = new ValorPositivo();
        ValorPositivo ValorIRF = new ValorPositivo();
        ValorPositivo pValorIRF = new ValorPositivo();
        for (Consolidacao consolidacao : this.getConsolidacoesBrasil().itens()) {
            impostoDevidoAnoAtual.append('+', consolidacao.getImpostoDevidoAnoAtual());
            impostoDiferidoAnosAnteriores.append('+', consolidacao.getImpostoDiferidoAnosAnteriores());
            ImpostoDiferidoAnosPosteriores.append('+', consolidacao.getImpostoDiferidoAnosPosteriores());
            ImpostoReferenteAlienacaoAnoAtual.append('+', consolidacao.getImpostoReferenteAlienacaoAnoAtual());
            ImpostoTotal.append('+', consolidacao.getImpostoTotal());
            totalImpostoPago.append('+', consolidacao.getTotalImpostoPago());
            totalRendIsentosNaoTributaveis.append('+', consolidacao.getTotalRendIsentosNaoTributaveis());
            totalRendSujeitosTributacao.append('+', consolidacao.getTotalRendSujeitosTributacao());
            pValorIRF.clear();
            for (AlienacaoParticipacaoSocietaria alienacao : this.getpSocietarias().itens()) {
                if (!GCAP.objetosGCAPIguais(consolidacao, alienacao)) continue;
                pValorIRF.append('+', alienacao.getConsolidacao().getValorIRF());
            }
            consolidacao.getValorIRF().setConteudo(pValorIRF);
            ValorIRF.append('+', pValorIRF);
        }
        this.getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual().setConteudo(impostoDevidoAnoAtual);
        this.getConsolidacaoGeralBrasil().getImpostoDiferidoAnosAnteriores().setConteudo(impostoDiferidoAnosAnteriores);
        this.getConsolidacaoGeralBrasil().getImpostoDiferidoAnosPosteriores().setConteudo(ImpostoDiferidoAnosPosteriores);
        this.getConsolidacaoGeralBrasil().getImpostoReferenteAlienacaoAnoAtual().setConteudo(ImpostoReferenteAlienacaoAnoAtual);
        this.getConsolidacaoGeralBrasil().getImpostoTotal().setConteudo(ImpostoTotal);
        this.getConsolidacaoGeralBrasil().getTotalImpostoPago().setConteudo(totalImpostoPago);
        this.getConsolidacaoGeralBrasil().getTotalRendIsentosNaoTributaveis().setConteudo(totalRendIsentosNaoTributaveis);
        this.getConsolidacaoGeralBrasil().getTotalRendSujeitosTributacao().setConteudo(totalRendSujeitosTributacao);
        this.getConsolidacaoGeralBrasil().getValorIRF().setConteudo(ValorIRF);
        totalImpostoPago.clear();
        totalRendIsentosNaoTributaveis.clear();
        totalRendSujeitosTributacao.clear();
        for (Consolidacao consolidacao : this.getConsolidacoesExterior().itens()) {
            totalImpostoPago.append('+', consolidacao.getTotalImpostoPago());
            totalRendIsentosNaoTributaveis.append('+', consolidacao.getTotalRendIsentosNaoTributaveis());
            totalRendSujeitosTributacao.append('+', consolidacao.getTotalRendSujeitosTributacao());
        }
        this.getConsolidacaoGeralExterior().getTotalImpostoPago().setConteudo(totalImpostoPago);
        this.getConsolidacaoGeralExterior().getTotalRendIsentosNaoTributaveis().setConteudo(totalRendIsentosNaoTributaveis);
        this.getConsolidacaoGeralExterior().getTotalRendSujeitosTributacao().setConteudo(totalRendSujeitosTributacao);
        this.getConsolidacaoGeralEspecie().consolidar();
    }

    public void recalcularGCAPDeclaracaoIRPF() {
        this.associarRendimentosIsentos();
        this.associarRendimentosExclusivos();
    }

    public boolean temAlienacaoDeAcoes() {
        boolean retorno = false;
        for (AlienacaoParticipacaoSocietaria alienacao : this.getpSocietarias().itens()) {
            if (!"A".equals(alienacao.getParticipacaoSocietaria().getEspecie().naoFormatado())) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public void associarRendimentosIsentos() {
        DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
        dec.getRendIsentos().getBensPequenoValorTransportado().setConteudo((Valor)this.obterSomatorioIsentoBemPequenoValorGCAP());
        dec.getRendIsentos().getUnicoImovelTransportado().setConteudo(this.obterSomatorioIsentoUnicoImovelGCAP());
        dec.getRendIsentos().getOutrosBensImoveisTransportado().setConteudo(this.obterSomatorioIsentoSemPequenoSemUnicoGCAP().operacao('+', this.obterSomatorioIsentoSemPequenoSemUnicoGCME()));
    }

    public void associarRendimentosExclusivos() {
        DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
        dec.getRendTributacaoExclusiva().getGanhosCapital().setConteudo(this.getConsolidacaoGeralBrasil().getTotalRendSujeitosTributacao().naoFormatado());
        dec.getRendTributacaoExclusiva().getGanhosCapitalEstrangeira().setConteudo(this.getConsolidacaoGeralExterior().getTotalRendSujeitosTributacao().naoFormatado());
        dec.getRendTributacaoExclusiva().getGanhosCapitalEmEspecie().setConteudo(this.getConsolidacaoGeralEspecie().getGanhoCapitalTotal().naoFormatado());
    }

    public ValorPositivo obterSomatorioIsentoBemPequenoValorGCAP() {
        ValorPositivo retorno = new ValorPositivo();
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            if (!((AlienacaoBemImovel)alienacao).isIsentoPorPequenoValor()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            if (!alienacao.isIsento()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao alienacao : this.getpSocietarias().itens()) {
            if (!alienacao.isIsento()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoBemPequenoValorGCAPBrasil(IdDemonstrativoGCAP id) {
        ValorPositivo retorno = new ValorPositivo();
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, (ObjetoGCAP)((Object)alienacao)) || !((AlienacaoBemImovel)alienacao).isAlienacaoBrasil() || !((AlienacaoBemImovel)alienacao).isIsentoPorPequenoValor()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, (ObjetoGCAP)((Object)alienacao)) || !((AlienacaoBemMovel)alienacao).isAlienacaoBrasil() || !alienacao.isIsento()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao alienacao : this.getpSocietarias().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, (ObjetoGCAP)((Object)alienacao)) || !alienacao.isIsento()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoUnicoImovelGCAP() {
        ValorPositivo retorno = new ValorPositivo();
        for (AlienacaoBemImovel alienacao : this.getBensImoveis().itens()) {
            if (!alienacao.isIsentoPorUnicoImovel()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoUnicoImovelGCAPBrasil(IdDemonstrativoGCAP id) {
        ValorPositivo retorno = new ValorPositivo();
        for (AlienacaoBemImovel alienacao : this.getBensImoveis().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, alienacao) || !alienacao.isAlienacaoBrasil() || !alienacao.isIsentoPorUnicoImovel()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoSemPequenoSemUnicoGCAP() {
        ValorPositivo retorno = new ValorPositivo();
        for (AlienacaoBemImovel alienacao : this.getBensImoveis().itens()) {
            if (!alienacao.isAlienacaoBrasil() || alienacao.isIsentoPorPequenoValor() || alienacao.isIsentoPorUnicoImovel()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoSemPequenoSemUnicoGCAPBrasil(IdDemonstrativoGCAP id) {
        ValorPositivo retorno = new ValorPositivo();
        for (AlienacaoBemImovel alienacao : this.getBensImoveis().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, alienacao) || !alienacao.isAlienacaoBrasil() || alienacao.isIsentoPorPequenoValor() || alienacao.isIsentoPorUnicoImovel()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioIsentoSemPequenoSemUnicoGCME() {
        ValorPositivo retorno = new ValorPositivo();
        for (AlienacaoBemImovel alienacao : this.getBensImoveis().itens()) {
            if (alienacao.isAlienacaoBrasil() || alienacao.isIsentoPorPequenoValor() || alienacao.isIsentoPorUnicoImovel()) continue;
            retorno.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioGanhoCapital1AlienacoesGCAP(String cpf) {
        ValorPositivo retorno = new ValorPositivo();
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            if (!cpf.equals(alienacao.getCpf().naoFormatado()) || !((AlienacaoBemImovel)alienacao).isAlienacaoBrasil() || !ConstantesGlobais.ANO_BASE.equals(alienacao.getDataAlienacao().getAno())) continue;
            if (alienacao.isAlienacaoAVista()) {
                retorno.append('+', ((AlienacaoBemImovel)alienacao).getApuracao().getGanhoCapital1());
                continue;
            }
            for (ParcelaAlienacao parcela : ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens()) {
                retorno.append('+', parcela.getGanhoCapital1Proporcional());
            }
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            if (!cpf.equals(alienacao.getCpf().naoFormatado()) || !((AlienacaoBemMovel)alienacao).isAlienacaoBrasil() || !ConstantesGlobais.ANO_BASE.equals(alienacao.getDataAlienacao().getAno())) continue;
            if (alienacao.isAlienacaoAVista()) {
                retorno.append('+', ((AlienacaoBemMovel)alienacao).getApuracao().getGanhoCapital1());
                continue;
            }
            for (ParcelaAlienacao parcela : ((AlienacaoBem)alienacao).getColecaoParcelaAlienacao().itens()) {
                retorno.append('+', parcela.getGanhoCapital1Proporcional());
            }
        }
        for (Alienacao alienacao : this.getpSocietarias().itens()) {
            if (!cpf.equals(alienacao.getCpf().naoFormatado()) || !alienacao.isAlienacaoBrasil() || !ConstantesGlobais.ANO_BASE.equals(alienacao.getDataAlienacao().getAno())) continue;
            if (alienacao.isAlienacaoAVista()) {
                retorno.append('+', ((AlienacaoParticipacaoSocietaria)alienacao).getApuracao().getGanhoCapital1());
                continue;
            }
            for (ParcelaAlienacao parcela : ((AlienacaoParticipacaoSocietaria)alienacao).getColecaoParcelaAlienacao().itens()) {
                retorno.append('+', parcela.getGanhoCapital1Proporcional());
            }
        }
        return retorno;
    }

    public ValorPositivo obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME() {
        Object retornoAlienacao;
        ValorPositivo retorno = new ValorPositivo();
        int anoGCAP = AplicacaoPropertiesUtil.getExercicioAsInt() - 1;
        for (AlienacaoBem alienacao : this.getBensImoveis().itens()) {
            Object parcela2;
            if (((AlienacaoBemImovel)alienacao).isAlienacaoBrasil()) continue;
            if (alienacao.isAlienacaoAVista()) {
                retorno.append('+', alienacao.getCalculoImposto().getImpostoDevido());
                continue;
            }
            if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
                for (Object parcela2 : alienacao.getColecaoParcelaAlienacao().itens()) {
                    if (parcela2.getDataRecebimento().naoFormatado().length() != 8 || anoGCAP != Integer.parseInt(parcela2.getDataRecebimento().getAno())) continue;
                    retorno.append('+', parcela2.getImpostoDevido());
                }
                continue;
            }
            retornoAlienacao = new ValorPositivo();
            retornoAlienacao.setConteudo((Valor)alienacao.getAjuste().getImpostoDevido());
            parcela2 = alienacao.getColecaoParcelaAlienacao().itens().iterator();
            while (parcela2.hasNext()) {
                ParcelaAlienacaoBem parcela3 = (ParcelaAlienacaoBem)((Object)parcela2.next());
                if (parcela3.getDataRecebimento().naoFormatado().length() != 8 || anoGCAP <= Integer.parseInt(parcela3.getDataRecebimento().getAno())) continue;
                retornoAlienacao.append('-', (Valor)parcela3.getImpostoDevido());
            }
            retorno.append('+', (Valor)retornoAlienacao);
        }
        for (AlienacaoBem alienacao : this.getBensMoveis().itens()) {
            if (((AlienacaoBemMovel)alienacao).isAlienacaoBrasil()) continue;
            if (alienacao.isAlienacaoAVista()) {
                retorno.append('+', alienacao.getCalculoImposto().getImpostoDevido());
                continue;
            }
            if (alienacao.getDataRecebimentoUltimaParcela().isVazio()) {
                for (Object parcela2 : alienacao.getColecaoParcelaAlienacao().itens()) {
                    if (parcela2.getDataRecebimento().naoFormatado().length() != 8 || anoGCAP != Integer.parseInt(parcela2.getDataRecebimento().getAno())) continue;
                    retorno.append('+', parcela2.getImpostoDevido());
                }
                continue;
            }
            retornoAlienacao = new ValorPositivo();
            retornoAlienacao.setConteudo((Valor)alienacao.getAjuste().getImpostoDevido());
            for (ParcelaAlienacaoBem parcela3 : alienacao.getColecaoParcelaAlienacao().itens()) {
                if (parcela3.getDataRecebimento().naoFormatado().length() != 8 || anoGCAP <= Integer.parseInt(parcela3.getDataRecebimento().getAno())) continue;
                retornoAlienacao.append('-', (Valor)parcela3.getImpostoDevido());
            }
            retorno.append('+', (Valor)retornoAlienacao);
        }
        return retorno;
    }

    public ConsolidacaoEspecie obterConsolidacaoEspeciePorId(IdDemonstrativoGCAP id) {
        ConsolidacaoEspecie retorno = null;
        for (ConsolidacaoEspecie consolidacao : this.getConsolidacaoGeralEspecie().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, consolidacao)) continue;
            retorno = consolidacao;
        }
        return retorno;
    }

    public TotalizacaoMoedasAlienadas obterTotalizacaoMoedasAlienadasPorId(IdDemonstrativoGCAP id) {
        TotalizacaoMoedasAlienadas retorno = null;
        for (TotalizacaoMoedasAlienadas totalizacao : this.getColecaoTotalizacaoMoedasAlienadas().itens()) {
            if (!GCAP.objetoGCAPestaAssociadoAId(id, totalizacao)) continue;
            retorno = totalizacao;
        }
        return retorno;
    }

    public void atualizarCodigosOperacao() {
        Object strOperacao;
        int operacao = 0;
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            strOperacao = "0000" + String.valueOf(++operacao);
            strOperacao = ((String)strOperacao).substring(((String)strOperacao).length() - 4);
            alienacao.getCodigoOperacao().setConteudo((String)strOperacao);
        }
        for (Alienacao alienacao : this.getBensMoveis().itens()) {
            strOperacao = "0000" + String.valueOf(++operacao);
            strOperacao = ((String)strOperacao).substring(((String)strOperacao).length() - 4);
            alienacao.getCodigoOperacao().setConteudo((String)strOperacao);
        }
        for (Alienacao alienacao : this.getpSocietarias().itens()) {
            strOperacao = "0000" + String.valueOf(++operacao);
            strOperacao = ((String)strOperacao).substring(((String)strOperacao).length() - 4);
            alienacao.getCodigoOperacao().setConteudo((String)strOperacao);
        }
    }

    public boolean existeOperacaoTransmissaoCausaMortis() {
        boolean existe = false;
        for (Alienacao alienacao : this.getBensImoveis().itens()) {
            if (!alienacao.getNatureza().naoFormatado().equals(String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS))) continue;
            existe = true;
            break;
        }
        if (!existe) {
            for (Alienacao alienacao : this.getBensMoveis().itens()) {
                if (!alienacao.getNatureza().naoFormatado().equals(String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS))) continue;
                existe = true;
                break;
            }
        }
        if (!existe) {
            for (Alienacao alienacao : this.getpSocietarias().itens()) {
                if (!alienacao.getNatureza().naoFormatado().equals(String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS))) continue;
                existe = true;
                break;
            }
        }
        return existe;
    }

    public int obterFlagIsencaoImovel(String cpf) {
        int flag = 0;
        boolean temIsencao180Dias = false;
        boolean temIsencao180DiasAnterior = false;
        boolean temIsencaoImovelUnico = false;
        if (cpf != null && cpf.length() == 11) {
            for (AlienacaoBemImovel imovel : this.bensImoveis.itens()) {
                if (!imovel.getCpf().naoFormatado().equals(cpf)) continue;
                if (flag == 0) {
                    flag = 1;
                }
                if (ConstantesGlobais.ANO_BASE.equals(imovel.getDataAlienacao().getAno())) {
                    String anoAnteriorGCAP;
                    String dataAnterior;
                    if (imovel.isAlienacaoBrasil() || imovel.isAlienacaoAVista()) {
                        if (!(imovel.getApuracao().getValorReducaoUnicoImovel().isVazio() && imovel.getApuracao().getValorReducaoUnicoImovelOrigemMN().isVazio() && imovel.getApuracao().getValorReducaoUnicoImovelOrigemME().isVazio())) {
                            temIsencaoImovelUnico = true;
                        } else if (!(imovel.getApuracao().getValorReducaoAplicacaoOutroImovel().isVazio() && imovel.getApuracao().getValorReducaoAplicacaoOutroImovelOrigemMN().isVazio() && imovel.getApuracao().getValorReducaoAplicacaoOutroImovelOrigemME().isVazio())) {
                            temIsencao180Dias = true;
                            if (Logico.SIM.equals(imovel.getPerguntas().getMP252PrimeiraAlienacao().naoFormatado())) {
                                dataAnterior = imovel.getPerguntas().getDataPrimeiraAlienacao().naoFormatado();
                                anoAnteriorGCAP = String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 2);
                                if (dataAnterior.length() == 8 && anoAnteriorGCAP.equals(dataAnterior.substring(4))) {
                                    temIsencao180DiasAnterior = true;
                                }
                            }
                        }
                    } else if (!(imovel.getApuracaoFinal().getValorReducaoUnicoImovel().isVazio() && imovel.getApuracaoFinal().getValorReducaoUnicoImovelOrigemMN().isVazio() && imovel.getApuracaoFinal().getValorReducaoUnicoImovelOrigemME().isVazio())) {
                        temIsencaoImovelUnico = true;
                    } else if (!(imovel.getApuracaoFinal().getValorReducaoAplicacaoOutroImovel().isVazio() && imovel.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemMN().isVazio() && imovel.getApuracaoFinal().getValorReducaoAplicacaoOutroImovelOrigemME().isVazio())) {
                        temIsencao180Dias = true;
                        if (Logico.SIM.equals(imovel.getPerguntas().getMP252PrimeiraAlienacao().naoFormatado())) {
                            dataAnterior = imovel.getPerguntas().getDataPrimeiraAlienacao().naoFormatado();
                            anoAnteriorGCAP = String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 2);
                            if (dataAnterior.length() == 8 && anoAnteriorGCAP.equals(dataAnterior.substring(4))) {
                                temIsencao180DiasAnterior = true;
                            }
                        }
                    }
                    if (temIsencao180Dias) {
                        if (flag == 1) {
                            flag = 2;
                        } else if (flag == 3) {
                            flag = 4;
                        }
                    }
                    if (temIsencaoImovelUnico) {
                        if (flag == 1) {
                            flag = 3;
                        } else if (flag == 2) {
                            flag = 4;
                        }
                    }
                    if (temIsencao180DiasAnterior) {
                        if (flag == 2) {
                            flag = 5;
                        } else if (flag == 3 || flag == 4) {
                            flag = 6;
                        }
                    }
                }
                if (flag != 6) continue;
                break;
            }
        }
        return flag;
    }
}

