/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorAnoTransito
extends ValidadorDefault {
    private String tipoPartilha;

    public ValidadorAnoTransito(String tipoPartilha) {
        super((byte)3);
        this.tipoPartilha = tipoPartilha;
    }

    public RetornoValidacao validarImplementado() {
        Data dataTransito = (Data)this.getInformacao();
        if (!dataTransito.isVazio()) {
            try {
                Date dataServidor = ControladorGui.dataAtual();
                Data dataAtual = new Data();
                dataAtual.setConteudo(dataServidor);
                if (Integer.parseInt(dataTransito.getAno()) > Integer.parseInt(dataAtual.getAno())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ano_transito_posterior_atual", new String[]{this.tipoPartilha}), 3);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Espolio.class.getName()).log(Level.SEVERE, "N\u00e3o foi poss\u00edvel obter a data do servidor para validar a data do tr\u00e2nsito em julgado.");
            }
        }
        return null;
    }
}

