/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informerendimentos;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemPagamento;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendAcm;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendIsentoOuTributacaoExclusiva;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendPJ;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendPJComExigibilidade;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.HeaderInformeRendimentos;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemPagamento;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemPensaoAlimenticiaRendAcm;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemRendAcm;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class InformeRendimentosPJ
extends ObjetoNegocio {
    private HeaderInformeRendimentos header = new HeaderInformeRendimentos();
    private ColecaoItemRendPJ colecaoRendimentosPessoaJuridica = new ColecaoItemRendPJ();
    private ColecaoItemPagamento colecaoPagamentosPrevidenciaComplementar = new ColecaoItemPagamento();
    private ColecaoItemPagamento colecaoPagamentosPensaoAlimenticia = new ColecaoItemPagamento();
    private ColecaoItemRendIsentoOuTributacaoExclusiva rendimentosIsentos = new ColecaoItemRendIsentoOuTributacaoExclusiva();
    private ColecaoItemRendIsentoOuTributacaoExclusiva rendimentosTributacaoExclusiva = new ColecaoItemRendIsentoOuTributacaoExclusiva();
    private ColecaoItemRendAcm colecaoRendimentosRecebidosAcumuladamente = new ColecaoItemRendAcm();
    private ColecaoItemRendPJComExigibilidade colecaoRendimentosExigibilidadeSuspensa = new ColecaoItemRendPJComExigibilidade();
    private ColecaoItemPagamento pagamentos = new ColecaoItemPagamento();
    public static final int TIPO_INFORME_TITULAR = 1;
    public static final int TIPO_INFORME_DEPENDENTE = 2;
    private int tipoInforme = 0;

    public InformeRendimentosPJ() {
        this.adicionaValidadores();
    }

    public void adicionaValidadores() {
        this.getColecaoPagamentosPensaoAlimenticia().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ItemPagamento item = (ItemPagamento)((Object)valorNovo);
                item.getNomeBeneficiarioSelecionado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                item.getTipoPensaoAlimenticia().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
            }
        });
        this.getColecaoRendimentosRecebidosAcumuladamente().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ItemRendAcm item = (ItemRendAcm)((Object)valorNovo);
                item.getPensaoAlimenticiaQuadroAuxiliar().addObservador("ObjetoInserido", new Observador(){

                    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                        final ItemPensaoAlimenticiaRendAcm item = (ItemPensaoAlimenticiaRendAcm)((Object)valorNovo);
                        item.getNomeAlimentandoSelecionado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                            public RetornoValidacao validarImplementado() {
                                if (item.isImportar()) {
                                    return super.validarImplementado();
                                }
                                return null;
                            }
                        });
                    }
                });
            }
        });
        this.getPagamentos().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ItemPagamento item = (ItemPagamento)((Object)valorNovo);
                item.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                item.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                item.getNomeBeneficiarioSelecionado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar() && !item.getTipoBeneficiario().naoFormatado().equals("1")) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public void ajustar13PensoesAlimenticias() {
        for (ItemPagamento pensao : this.getColecaoPagamentosPensaoAlimenticia().itens()) {
            ValorPositivo valorRecebido = new ValorPositivo();
            valorRecebido.setConteudo(pensao.getValorPago());
            valorRecebido.append('+', pensao.getValorDecimoTerceiro());
            pensao.getValorPago().setConteudo(valorRecebido.naoFormatado());
        }
    }

    public static boolean validate(String xsdFullFilename, String xmlFullFilename) {
        Source xmlFile = null;
        try {
            xmlFile = new StreamSource(new File(xmlFullFilename));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(xsdFullFilename));
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            return false;
        }
        catch (IOException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public HeaderInformeRendimentos getHeader() {
        return this.header;
    }

    public ColecaoItemRendPJ getColecaoRendimentosPessoaJuridica() {
        return this.colecaoRendimentosPessoaJuridica;
    }

    public ColecaoItemPagamento getColecaoPagamentosPrevidenciaComplementar() {
        return this.colecaoPagamentosPrevidenciaComplementar;
    }

    public ColecaoItemPagamento getColecaoPagamentosPensaoAlimenticia() {
        return this.colecaoPagamentosPensaoAlimenticia;
    }

    public ColecaoItemRendIsentoOuTributacaoExclusiva getRendimentosIsentos() {
        return this.rendimentosIsentos;
    }

    public ColecaoItemRendIsentoOuTributacaoExclusiva getRendimentosTributacaoExclusiva() {
        return this.rendimentosTributacaoExclusiva;
    }

    public ColecaoItemRendAcm getColecaoRendimentosRecebidosAcumuladamente() {
        return this.colecaoRendimentosRecebidosAcumuladamente;
    }

    public ColecaoItemRendPJComExigibilidade getColecaoRendimentosExigibilidadeSuspensa() {
        return this.colecaoRendimentosExigibilidadeSuspensa;
    }

    public ColecaoItemPagamento getPagamentos() {
        return this.pagamentos;
    }

    public int getTipoInforme() {
        return this.tipoInforme;
    }

    public void setTipoInforme(int tipoInforme) {
        this.tipoInforme = tipoInforme;
    }
}

