/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.brasil;

import java.util.List;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ColecaoDividasARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.IdentificacaoImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ReceitasDespesas;
import serpro.ppgd.irpf.gui.atividaderural.PainelDadosImovel;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;

public class ARBrasil
extends ObjetoNegocio {
    private IdentificacaoImovelARBrasil identificacaoImovel = new IdentificacaoImovelARBrasil();
    private ReceitasDespesas receitasDespesas = new ReceitasDespesas();
    private ApuracaoResultadoBrasil apuracaoResultado = new ApuracaoResultadoBrasil();
    private MovimentacaoRebanho movimentacaoRebanho = new MovimentacaoRebanho();
    private ColecaoDividasARBrasil dividas = new ColecaoDividasARBrasil();

    public ARBrasil() {
        this.getMovimentacaoRebanho().setFicha("Movimenta\u00e7\u00e3o do Rebanho - BRASIL");
    }

    public ApuracaoResultadoBrasil getApuracaoResultado() {
        return this.apuracaoResultado;
    }

    public ColecaoDividasARBrasil getDividas() {
        return this.dividas;
    }

    public IdentificacaoImovelARBrasil getIdentificacaoImovel() {
        return this.identificacaoImovel;
    }

    public MovimentacaoRebanho getMovimentacaoRebanho() {
        return this.movimentacaoRebanho;
    }

    public ReceitasDespesas getReceitasDespesas() {
        return this.receitasDespesas;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        boolean temAlgumaOutraFichaPreenchida;
        List retorno = super.verificarPendencias(numeroItem);
        boolean bl = temAlgumaOutraFichaPreenchida = !this.getReceitasDespesas().isVazio() || !this.getApuracaoResultado().isVazio() || !this.getMovimentacaoRebanho().isVazio() || !this.getDividas().isVazio();
        if (this.getIdentificacaoImovel().isVazio() && temAlgumaOutraFichaPreenchida) {
            this.getIdentificacaoImovel().novoObjeto();
            ImovelARBrasil imovel = (ImovelARBrasil)this.getIdentificacaoImovel().itens().get(0);
            Pendencia p = new Pendencia(3, (Informacao)imovel.getCodigo(), imovel.getCodigo().getNomeCampo(), MensagemUtil.getMensagem("ar_imovel_nao_preenchido"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            p.setNomeAba(this.getNomeAba());
            retorno.add(p);
        }
        return retorno;
    }

    public String getClasseFicha() {
        return PainelDadosImovel.class.getName();
    }

    public String getNomeAba() {
        return "Brasil";
    }

    public ImovelARBrasil localizaImovelPorCIB(String cib) {
        for (ImovelARBrasil imovelARBrasil : this.getIdentificacaoImovel().itens()) {
            if (!imovelARBrasil.getCIB().naoFormatado().equals(cib)) continue;
            return imovelARBrasil;
        }
        return null;
    }
}

