/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import com.google.zxing.common.detector.MathUtils;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;

public class ValidadorCIB
extends ValidadorDefault {
    private String msgValidacao = "N\u00famero do im\u00f3vel na RFB inv\u00e1lido.";
    private static int[] fatores = new int[]{4, 3, 9, 5, 7, 1, 8};
    public static final String CIB_INVALIDO = "N\u00famero do Im\u00f3vel na Receita inv\u00e1lido.";
    public static final int MOD11_CASO_2 = 2;

    public ValidadorCIB(byte severidade) {
        super(severidade);
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retornoValidacao = ValidadorCIB.validarCIB(UtilitariosString.retiraMascara((String)this.getInformacao().getConteudoFormatado()));
        if (retornoValidacao == null) {
            return null;
        }
        retornoValidacao.setSeveridade(this.getSeveridade());
        retornoValidacao.setMensagemValidacao(this.msgValidacao);
        return retornoValidacao;
    }

    public static RetornoValidacao validarCIB(String pCIB) {
        if (pCIB.trim().length() < 8) {
            return new RetornoValidacao(CIB_INVALIDO, 2);
        }
        if (pCIB.trim().equals("00000000")) {
            return new RetornoValidacao(CIB_INVALIDO, 2);
        }
        if (pCIB.matches("\\d+") ? !Validador.validarModulo11((String)pCIB, null, (int)2) : ValidadorCIB.validarBase32(pCIB) == false) {
            return new RetornoValidacao(CIB_INVALIDO, 2);
        }
        return null;
    }

    private static Boolean validarBase32(String pCIB) {
        char div = ValidadorCIB.dvCIB(pCIB);
        return pCIB.charAt(pCIB.length() - 1) == div;
    }

    private static char dvCIB(String pCIB) {
        pCIB = String.format("%8s", pCIB).replace(' ', '0');
        int[] lista = new int[7];
        for (int i = 0; i < 7; ++i) {
            lista[i] = ValidadorCIB.deBase32(pCIB.charAt(i));
            lista[i] = lista[i] * fatores[i];
        }
        return ValidadorCIB.paraBase32(MathUtils.sum((int[])lista) % 31);
    }

    private static int deBase32(char pChar) {
        switch (pChar) {
            case '0': 
            case 'O': 
            case 'o': {
                return 0;
            }
            case '1': 
            case 'I': 
            case 'L': 
            case 'i': 
            case 'l': {
                return 1;
            }
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Integer.valueOf(String.valueOf(pChar));
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
            case 'G': 
            case 'g': {
                return 16;
            }
            case 'H': 
            case 'h': {
                return 17;
            }
            case 'J': 
            case 'j': {
                return 18;
            }
            case 'K': 
            case 'k': {
                return 19;
            }
            case 'M': 
            case 'm': {
                return 20;
            }
            case 'N': 
            case 'n': {
                return 21;
            }
            case 'P': 
            case 'p': {
                return 22;
            }
            case 'Q': 
            case 'q': {
                return 23;
            }
            case 'R': 
            case 'r': {
                return 24;
            }
            case 'S': 
            case 's': {
                return 25;
            }
            case 'T': 
            case 't': {
                return 26;
            }
            case 'V': 
            case 'v': {
                return 27;
            }
            case 'W': 
            case 'w': {
                return 28;
            }
            case 'X': 
            case 'x': {
                return 29;
            }
            case 'Y': 
            case 'y': {
                return 30;
            }
            case 'Z': 
            case 'z': {
                return 31;
            }
        }
        return 0;
    }

    private static char paraBase32(int numero) {
        switch (numero) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return String.valueOf(numero).charAt(0);
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
            case 16: {
                return 'G';
            }
            case 17: {
                return 'H';
            }
            case 18: {
                return 'J';
            }
            case 19: {
                return 'K';
            }
            case 20: {
                return 'M';
            }
            case 21: {
                return 'N';
            }
            case 22: {
                return 'P';
            }
            case 23: {
                return 'Q';
            }
            case 24: {
                return 'R';
            }
            case 25: {
                return 'S';
            }
            case 26: {
                return 'T';
            }
            case 27: {
                return 'V';
            }
            case 28: {
                return 'W';
            }
            case 29: {
                return 'X';
            }
            case 30: {
                return 'Y';
            }
            case 31: {
                return 'Z';
            }
        }
        return '0';
    }
}

