/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.negocio.Observador;

public class ObservadorRemoverPensaoRRA
extends Observador {
    private Alimentando alimentando;

    public ObservadorRemoverPensaoRRA(Alimentando alimentando) {
        this.alimentando = alimentando;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        String antigo = (String)valorAntigo;
        if (!antigo.isEmpty()) {
            boolean remover = false;
            boolean sair = false;
            DeclaracaoIRPF dec = ControladorGui.getDemonstrativoAberto();
            if (dec != null && !dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(antigo)) {
                List<RendAcmDependente> rendimentosacm = dec.getColecaoRendAcmDependente().obterRRAsPorCPF(antigo);
                for (RendAcmDependente rendacm : rendimentosacm) {
                    ArrayList<ItemQuadroPensaoAlimenticia> pensoes = new ArrayList<ItemQuadroPensaoAlimenticia>();
                    for (ItemQuadroPensaoAlimenticia pensao : rendacm.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                        if (pensao.getAlimentando().naoFormatado().equals(this.alimentando.getNome().naoFormatado())) {
                            if (!remover && !sair) {
                                if (GuiUtil.mostrarConfirma((String)"alimentando_confirma_remover_pensoes_rra", (String[])new String[]{this.alimentando.getNome().naoFormatado()})) {
                                    remover = true;
                                } else {
                                    sair = true;
                                    this.alimentando.getCpfResponsavel().setObservadoresAtivos(false);
                                    this.alimentando.getCpfResponsavel().setConteudo(antigo);
                                    this.alimentando.getCpfResponsavel().setObservadoresAtivos(true);
                                }
                            }
                            pensoes.add(pensao);
                        }
                        if (!sair) continue;
                        break;
                    }
                    if (remover) {
                        Iterator itPensoes = pensoes.iterator();
                        while (itPensoes.hasNext()) {
                            rendacm.getPensaoAlimenticiaQuadroAuxiliar().remove((ItemQuadroPensaoAlimenticia)((Object)itPensoes.next()));
                        }
                    }
                    if (!sair) continue;
                    break;
                }
            }
        }
    }
}

