/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCNPJ;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class EscrituracaoPublica
extends ObjetoNegocio
implements ObjetoFicha {
    private WeakReference<Alimentando> refAlimentando;
    private CNPJ cnpjCartorio = new CNPJ((ObjetoNegocio)this, "CNPJ do cart\u00f3rio");
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do cart\u00f3rio");
    private Alfa livro = new Alfa((ObjetoNegocio)this, "Livro", 7);
    private Alfa folhas = new Alfa((ObjetoNegocio)this, "Folhas", 7);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Data dataLavratura = new Data((ObjetoNegocio)this, "Data da lavratura");
    private String nomeAba;

    public EscrituracaoPublica(Alimentando alimentando, String nomeAba) {
        this.refAlimentando = new WeakReference<Alimentando>(alimentando);
        this.nomeAba = nomeAba;
        this.setFicha("Alimentandos");
        CacheNI.getInstancia().registrarNINome((NI)this.cnpjCartorio, this.nome);
        this.uf.setColunaFiltro(1);
        this.adicionarObservadores();
        this.adicionarValidadores();
    }

    private void adicionarValidadores() {
        this.getCnpjCartorio().addValidador((ValidadorIf)new ValidadorCNPJ(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno != null && retorno.getSeveridade() != 0) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{EscrituracaoPublica.this.getCnpjCartorio().getNomeCampo()}));
                }
                return retorno;
            }
        });
        this.getDataLavratura().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (((Alimentando)((Object)EscrituracaoPublica.this.refAlimentando.get())).isTipoProcessoCartorioAmbos()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDataLavratura().addValidador((ValidadorIf)new ValidadorData(3, 9999){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno == null || retorno.getSeveridade() == 0) {
                    Data calendario = new Data();
                    calendario.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
                    if (EscrituracaoPublica.this.getDataLavratura().maisAntiga(((Alimentando)((Object)EscrituracaoPublica.this.refAlimentando.get())).getDtNascimento()) || EscrituracaoPublica.this.getDataLavratura().maisNova(calendario)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("alimentando_data_lavratura_invalida", new String[]{ConstantesGlobais.ANO_BASE}));
                    }
                    return retorno;
                }
                retorno.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{EscrituracaoPublica.this.getDataLavratura().getNomeCampo()}));
                return retorno;
            }
        });
    }

    private void adicionarObservadores() {
        this.getUf().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (EscrituracaoPublica.this.uf.isVazio()) {
                    EscrituracaoPublica.this.municipio.setColecaoElementoTabela(new ArrayList());
                } else {
                    String strUf = EscrituracaoPublica.this.uf.getConteudoAtual(0);
                    EscrituracaoPublica.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipios(strUf, 1));
                }
            }
        });
    }

    public CNPJ getCnpjCartorio() {
        return this.cnpjCartorio;
    }

    public Data getDataLavratura() {
        return this.dataLavratura;
    }

    public Alfa getFolhas() {
        return this.folhas;
    }

    public Alfa getLivro() {
        return this.livro;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Codigo getUf() {
        return this.uf;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = this.recuperarCamposInformacao();
        for (Informacao info : campos) {
            info.setAba(this.getNomeAba());
        }
        return this.recuperarCamposInformacao();
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public String getNomeAba() {
        return this.nomeAba;
    }

    public String getTituloFichaDashboard() {
        return "Alimentandos";
    }
}

