/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class DecisaoJudicial
extends ObjetoNegocio
implements ObjetoFicha {
    private WeakReference<Alimentando> refAlimentando;
    private Alfa numProcessoJudicial = new Alfa((ObjetoNegocio)this, "N\u00b0 do processo judicial");
    private Alfa idVaraCivil = new Alfa((ObjetoNegocio)this, "Identifica\u00e7\u00e3o da vara c\u00edvel");
    private Alfa comarca = new Alfa((ObjetoNegocio)this, "Comarca");
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarSiglasUFs(0));
    private Data dtDecisaoJud = new Data((ObjetoNegocio)this, "Data da decis\u00e3o judicial");
    private String nomeAba;

    public DecisaoJudicial(Alimentando alimentando, String nomeAba) {
        this.refAlimentando = new WeakReference<Alimentando>(alimentando);
        this.nomeAba = nomeAba;
        this.setFicha("Alimentandos");
        this.getUf().setColunaFiltro(1);
        this.adicionarObservadores();
        this.adicionarValidadores();
    }

    private void adicionarValidadores() {
        this.getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (((Alimentando)((Object)DecisaoJudicial.this.refAlimentando.get())).isTipoProcessoJudicialAmbos()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDtDecisaoJud().addValidador((ValidadorIf)new ValidadorData(3, 9999){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno == null || retorno.getSeveridade() == 0) {
                    Data calendario = new Data();
                    calendario.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
                    if (DecisaoJudicial.this.getDtDecisaoJud().maisAntiga(((Alimentando)((Object)DecisaoJudicial.this.refAlimentando.get())).getDtNascimento()) || DecisaoJudicial.this.getDtDecisaoJud().maisNova(calendario)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("alimentando_data_decisao_judicial_invalida", new String[]{ConstantesGlobais.ANO_BASE}));
                    }
                    return retorno;
                }
                retorno.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{DecisaoJudicial.this.getDtDecisaoJud().getNomeCampo()}));
                return retorno;
            }
        });
    }

    private void adicionarObservadores() {
        this.getComarca().addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public Alfa getComarca() {
        return this.comarca;
    }

    public Data getDtDecisaoJud() {
        return this.dtDecisaoJud;
    }

    public Alfa getIdVaraCivil() {
        return this.idVaraCivil;
    }

    public Alfa getNumProcessoJudicial() {
        return this.numProcessoJudicial;
    }

    public Codigo getUf() {
        return this.uf;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = this.recuperarCamposInformacao();
        for (Informacao info : campos) {
            info.setAba(this.getNomeAba());
        }
        return this.recuperarCamposInformacao();
    }

    public boolean isVazio() {
        return this.getNumProcessoJudicial().isVazio() && this.getIdVaraCivil().isVazio() && this.getComarca().isVazio() && this.getUf().isVazio() && this.getDtDecisaoJud().isVazio();
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public String getNomeAba() {
        return this.nomeAba;
    }

    public String getTituloFichaDashboard() {
        return "Alimentandos";
    }
}

