/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jsignnet.aplicacao.JSignNet;
import jsignnet.aplicacao.LeitorCertificados;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.crypto.icp.FiltroICP;
import jsignnet.erro.JSignException;
import jsignnet.gui.ConfiguradorContainers;
import jsignnet.gui.ImagensPadrao;
import jsignnet.gui.ObservadorPainelCertificados;
import jsignnet.gui.PainelCertificados;
import jsignnet.gui.TelaProgressoIndeterminado;

public class DialogoCertificados
extends JDialog
implements ObservadorPainelCertificados {
    private static final long serialVersionUID = 1L;
    private PainelCertificados _painel;
    private X509CertificadoWrapper _certSelecionado;
    private JButton _botaoAbrir;
    private JButton _botaoRecarregar;
    private Action _acaoOk = new AcaoOk();
    private JButton _botaoCancelar;
    private boolean _fCertificadoSelecionado;
    private boolean _fCancelado = false;
    private boolean _fOk;
    private Logger _logger;
    private String _msgErroCarregamentoCertificado = "Erro ao encontrar os certificados instalados.\nAlguns de seus certificados n\u00e3o ser\u00e3o exibidos.\nVerifique se outros programas conseguem exibir todos os seus certificados digitais instalados e tente novamente.";
    private boolean _incluidoCertificadoPKCS12;
    private LeitorCertificados _leitorCertificados = JSignNet.getLeitorCertificados();
    private JButton _botaoAjuda;
    private JButton _botaoOk;
    private ConfiguradorContainers _configurador;
    private Icon _iconeProgresso = ImagensPadrao.CARREGANDO;
    private Icon _iconeDivisoria = ImagensPadrao.FAIXA;
    private String _tituloErro = "Receitanet";
    private String _tituloSemCertificados;
    private String _msgSemCertificados;
    private boolean _exibirMsgSemCertificados = false;
    private boolean _apenasICP = true;

    public DialogoCertificados(Dialog owner) throws HeadlessException {
        this(owner, owner.getTitle(), true);
    }

    public DialogoCertificados(Frame owner) throws HeadlessException {
        this(owner, owner.getTitle(), true);
    }

    public DialogoCertificados(Dialog owner, String title) throws HeadlessException {
        this(owner, title, true);
    }

    public DialogoCertificados(Frame owner, String title) throws HeadlessException {
        this(owner, title, true);
    }

    public DialogoCertificados(Dialog owner, String title, GraphicsConfiguration gc) throws HeadlessException {
        this(owner, title, gc, true);
    }

    public DialogoCertificados(Frame owner, String title, GraphicsConfiguration gc) {
        this(owner, title, gc, true);
    }

    public DialogoCertificados(Frame owner, String title, GraphicsConfiguration gc, boolean apenasICP) {
        super(owner, title, true, gc);
        this._apenasICP = apenasICP;
        this.montarGUI();
    }

    public DialogoCertificados(Dialog owner, String title, GraphicsConfiguration gc, boolean apenasICP) {
        super(owner, title, true, gc);
        this._apenasICP = apenasICP;
        this.montarGUI();
    }

    public DialogoCertificados(Frame owner, String title, boolean apenasICP) {
        super(owner, title, true);
        this._apenasICP = apenasICP;
        this.montarGUI();
    }

    public DialogoCertificados(Dialog owner, String title, boolean apenasICP) {
        super(owner, title, true);
        this._apenasICP = apenasICP;
        this.montarGUI();
    }

    private void montarGUI() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this._painel = new PainelCertificados(this, !this._apenasICP);
        this._painel.setName("PainelCertificados");
        this._painel.adicionarObservador(this);
        this._painel.setTitulo("Selecione um certificado digital");
        this._painel.setPreferredSize(new Dimension(600, 200));
        this._painel.setMnemonicoBotaoDetalha(88);
        this.getContentPane().add((Component)this._painel, "Center");
        this.getContentPane().add(this.montarPainelInferior(), "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                DialogoCertificados.this.carregarCertificadosIniciais();
                DialogoCertificados.this.repaint();
            }
        });
    }

    private Component montarPainelInferior() {
        Box box = Box.createVerticalBox();
        box.add(this.montarPainelBotoes());
        return box;
    }

    public void setAjuda(Action acao, Icon icone) {
        if (acao == null) {
            throw new IllegalArgumentException("A a\u00e7\u00e3o de ajuda precisa ser especificada.");
        }
        this._botaoAjuda.setAction(acao);
        if (icone != null) {
            this._botaoAjuda.setIcon(icone);
            this._botaoAjuda.setPreferredSize(new Dimension(icone.getIconWidth(), icone.getIconHeight()));
            this._botaoAjuda.setText("");
            this._botaoAjuda.setContentAreaFilled(false);
            this._botaoAjuda.setFocusPainted(false);
            this._botaoAjuda.setBorderPainted(false);
        }
        KeyStroke tecla = (KeyStroke)acao.getValue("AcceleratorKey");
        String chaveAcao = this.getClass().getName() + ".ajuda";
        this._botaoAjuda.getInputMap(2).put(tecla, chaveAcao);
        this._botaoAjuda.getActionMap().put(chaveAcao, acao);
        this._botaoAjuda.setVisible(true);
        this._botaoAjuda.invalidate();
    }

    public void setBotaoOk(String texto, int mnemonic) {
        this._botaoOk.setText(texto);
        this._botaoOk.setMnemonic(mnemonic);
    }

    private Component montarPainelBotoes() {
        Box box = Box.createHorizontalBox();
        this._botaoAjuda = new JButton();
        this._botaoAjuda.setName("DI.btAjuda");
        this._botaoAjuda.setVisible(false);
        box.add(this._botaoAjuda);
        box.add(Box.createHorizontalStrut(6));
        this._botaoAbrir = new JButton(new AcaoAbrirArquivo());
        this._botaoAbrir.setName("DI.btAbrir");
        this._botaoAbrir.setMnemonic(66);
        box.add(this._botaoAbrir);
        box.add(Box.createHorizontalStrut(6));
        this._botaoRecarregar = new JButton(new AcaoRecarregar());
        this._botaoRecarregar.setName("DI.btRecarregar");
        this._botaoRecarregar.setMnemonic(84);
        box.add(this._botaoRecarregar);
        box.add(Box.createHorizontalGlue());
        this._botaoOk = new JButton(this._acaoOk);
        this._botaoOk.setName("DI.btOk");
        this._botaoOk.setMnemonic(79);
        this._acaoOk.setEnabled(false);
        box.add(this._botaoOk);
        box.add(Box.createHorizontalStrut(6));
        AcaoCancelar acaoCancelar = new AcaoCancelar();
        this._botaoCancelar = new JButton(acaoCancelar);
        this._botaoCancelar.setName("DI.btSair");
        this._botaoCancelar.setMnemonic(67);
        KeyStroke teclaCancelar = (KeyStroke)acaoCancelar.getValue("AcceleratorKey");
        String chaveAcaoCancelar = this.getClass().getName() + ".cancelar";
        this._botaoCancelar.getInputMap(2).put(teclaCancelar, chaveAcaoCancelar);
        this._botaoCancelar.getActionMap().put(chaveAcaoCancelar, acaoCancelar);
        box.add(this._botaoCancelar);
        box.setBorder(new EmptyBorder(6, 6, 6, 6));
        return box;
    }

    private void carregarCertificadosIniciais() {
        new Thread((Runnable)new AcaoCarregarCertificados(), "DialogoCertificados:Carregando certificados digitais").start();
    }

    @Override
    public void certificadoSelecionado(PainelCertificados painel, X509CertificadoWrapper selecionado) {
        if (!this._painel.equals(painel)) {
            return;
        }
        if (selecionado == null) {
            return;
        }
        this._certSelecionado = selecionado;
        this._fCertificadoSelecionado = true;
        this.atualizarHabilitacaoComandoOK();
        if (this._certSelecionado.getDataVencimento().compareTo(new Date()) < 0) {
            String mensagem = "O certificado selecionado provavelmente j\u00e1 passou de sua data de validade.\nPode n\u00e3o ser poss\u00edvel us\u00e1-lo nesta aplica\u00e7\u00e3o.";
            JOptionPane.showMessageDialog(this, mensagem, this._tituloErro, 2);
        }
    }

    private void atualizarHabilitacaoComandoOK() {
        this._acaoOk.setEnabled(this._fCertificadoSelecionado);
    }

    public X509CertificadoWrapper getCertificadoSelecionado() {
        if (this._fCancelado || !this._fOk) {
            return null;
        }
        return this._certSelecionado;
    }

    private ConfiguradorContainers obterConfigurador() {
        if (this._configurador == null) {
            this.setConfigurador((File)null);
        }
        return this._configurador;
    }

    public void setConfigurador(ConfiguradorContainers conf) {
        this._configurador = conf;
        if (conf != null) {
            this._leitorCertificados.setFiltro(conf.getFiltro());
        }
    }

    public void setConfigurador(File diretorioConfiguracaoPKCS11) {
        ConfiguradorContainers configurador = new ConfiguradorContainers(this._leitorCertificados);
        if (diretorioConfiguracaoPKCS11 != null) {
            configurador.setPathContainerPKCS11(diretorioConfiguracaoPKCS11.getAbsolutePath());
        }
        if (this._apenasICP) {
            configurador.setFiltro(FiltroICP.singleton());
            this._leitorCertificados.setFiltro(FiltroICP.singleton());
        }
        configurador.adicionaContainer(ConfiguradorContainers.CAPI);
        configurador.adicionaContainer(ConfiguradorContainers.PKCS11);
        configurador.adicionaContainer(ConfiguradorContainers.KEYCHAINSTORE);
        configurador.setDono(this);
        this._configurador = configurador;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setMsgErroCarregamentoCertificado(String titulo, String mensagem) {
        if (mensagem != null) {
            this._msgErroCarregamentoCertificado = mensagem;
        }
        if (titulo != null) {
            this._tituloErro = titulo;
        }
    }

    public void setLogotipo(JComponent logotipo) {
        if (logotipo != null) {
            this.getContentPane().add((Component)logotipo, "North");
            this.invalidate();
            this.pack();
        }
    }

    public void setIconesTelaProgresso(Icon iconeProgresso, Icon iconeDivisoria) {
        this._iconeProgresso = iconeProgresso;
        this._iconeDivisoria = iconeDivisoria;
    }

    public void setMsgSemCertificados(String titulo, String mensagem) {
        if (titulo == null || mensagem == null) {
            throw new IllegalArgumentException("O t\u00edtulo e a mensagem n\u00e3o podem ser nulos.");
        }
        this._tituloSemCertificados = titulo;
        this._msgSemCertificados = mensagem;
        this._exibirMsgSemCertificados = true;
    }

    private class AcaoCancelar
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AcaoCancelar() {
            super("Cancelar");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoCertificados.this._fCancelado = true;
            DialogoCertificados.this.dispose();
        }
    }

    private class AcaoOk
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AcaoOk() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoCertificados.this._fOk = true;
            DialogoCertificados.this.dispose();
        }
    }

    private class AcaoRecarregar
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AcaoRecarregar() {
            super("Atualizar lista");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogoCertificados.this.obterConfigurador().limparCache();
            DialogoCertificados.this.carregarCertificadosIniciais();
            if (DialogoCertificados.this._incluidoCertificadoPKCS12) {
                String msg = "Os certificados que foram carregados de um arquivo foram removidos da lista.\nUse o comando \"Buscar certificado\" e os importe novamente caso necess\u00e1rio.";
                JOptionPane.showMessageDialog(DialogoCertificados.this, msg, DialogoCertificados.this._tituloErro, 2);
                DialogoCertificados.this._incluidoCertificadoPKCS12 = false;
            }
        }
    }

    private class AcaoAbrirArquivo
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AcaoAbrirArquivo() {
            super("Buscar certificado");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block5: {
                try {
                    int numIncluidos = DialogoCertificados.this._painel.incluirCertificadosPKCS12(DialogoCertificados.this._leitorCertificados, DialogoCertificados.this.getTitle(), "Informe a senha para o certificado digital");
                    if (numIncluidos > 0) {
                        DialogoCertificados.this._acaoOk.setEnabled(false);
                        DialogoCertificados.this._painel.selecionarCertificado(DialogoCertificados.this._painel.getNumCertificados() - 1);
                        DialogoCertificados.this._incluidoCertificadoPKCS12 = true;
                    } else if (numIncluidos == 0) {
                        String msg = "Nenhum certificado foi carregado do arquivo.\nOu n\u00e3o h\u00e1 certificados no arquivo ou nenhum dos certificados\npresentes no arquivo \u00e9 v\u00e1lido para esta aplica\u00e7\u00e3o.";
                        JOptionPane.showMessageDialog(DialogoCertificados.this, msg, DialogoCertificados.this._tituloErro, 2);
                    }
                }
                catch (JSignException exc) {
                    JOptionPane.showMessageDialog(DialogoCertificados.this, DialogoCertificados.this._msgErroCarregamentoCertificado, DialogoCertificados.this._tituloErro, 0);
                    if (DialogoCertificados.this._logger == null) break block5;
                    DialogoCertificados.this._logger.log(Level.WARNING, "Falha ao carregar certificados.", exc);
                }
            }
        }
    }

    private final class AcaoCarregarCertificados
    implements Runnable {
        private volatile TelaProgressoIndeterminado _telaProgresso;
        X509CertificadoWrapper[] _certificados;

        private AcaoCarregarCertificados() {
        }

        @Override
        public void run() {
            Runnable acaoFimCarregamento = new Runnable(){

                @Override
                public void run() {
                    while (!AcaoCarregarCertificados.this._telaProgresso.isVisible()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    Cursor padrao = Cursor.getDefaultCursor();
                    AcaoCarregarCertificados.this.trocarCursorMouse(padrao);
                    AcaoCarregarCertificados.this._telaProgresso.setVisible(false);
                    AcaoCarregarCertificados.this._telaProgresso.dispose();
                    DialogoCertificados.this._painel.repaint();
                    if ((AcaoCarregarCertificados.this._certificados == null || AcaoCarregarCertificados.this._certificados.length == 0) && DialogoCertificados.this._exibirMsgSemCertificados) {
                        JOptionPane.showMessageDialog(DialogoCertificados.this, DialogoCertificados.this._msgSemCertificados, DialogoCertificados.this._tituloSemCertificados, 1);
                    }
                }
            };
            this.exibirTelaProgresso(acaoFimCarregamento);
            try {
                Cursor ampulheta = Cursor.getPredefinedCursor(3);
                this.trocarCursorMouse(ampulheta);
                this._certificados = DialogoCertificados.this.obterConfigurador().getArrayCertificados();
                if (this._telaProgresso == null || !this._telaProgresso.foiCancelado()) {
                    DialogoCertificados.this._painel.setCertificados(this._certificados);
                }
            }
            finally {
                SwingUtilities.invokeLater(acaoFimCarregamento);
            }
        }

        private void trocarCursorMouse(Cursor cursor) {
            DialogoCertificados.this.setCursor(cursor);
        }

        private void exibirTelaProgresso(final Runnable acaoCancelamento) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AcaoCarregarCertificados.this._telaProgresso = new TelaProgressoIndeterminado(DialogoCertificados.this, "Verificando os certificados digitais...", true, DialogoCertificados.this._iconeProgresso, DialogoCertificados.this._iconeDivisoria);
                    AcaoCarregarCertificados.this._telaProgresso.setTexto("Verificando os certificados digitais. Favor aguardar alguns instantes.");
                    AcaoCarregarCertificados.this._telaProgresso.setAcaoCancelamento(acaoCancelamento);
                    AcaoCarregarCertificados.this._telaProgresso.setVisible(true);
                }
            });
        }
    }
}

