/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto.icp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.crypto.icp.CertificadoICPBrasil;
import jsignnet.crypto.icp.FiltroICPNomeAlternativo;
import jsignnet.erro.JSignException;

public class CertificadoICPBrasilNomeAlternativo
extends CertificadoICPBrasil {
    private static List<String> oidsPessoaFisica = Arrays.asList("2.16.76.1.3.1", "2.16.76.1.3.5");
    private static List<String> oidsPessoaJuridica = Arrays.asList("2.16.76.1.3.2", "2.16.76.1.3.3", "2.16.76.1.3.4");

    public CertificadoICPBrasilNomeAlternativo(X509CertificadoWrapper certificado) {
        super(certificado);
        if (!FiltroICPNomeAlternativo.singleton().isCertificadoValido(certificado)) {
            throw new IllegalArgumentException("O certificado informado n\u00e3o segue a estrutura da ICP-Brasil.");
        }
    }

    @Override
    public boolean eCertificadoPessoaFisica() throws IOException {
        return this.getOIDsSubjectAlternativeName().containsAll(oidsPessoaFisica);
    }

    @Override
    public boolean eCertificadoPessoaJuridica() throws IOException {
        return this.getOIDsSubjectAlternativeName().containsAll(oidsPessoaJuridica);
    }

    @Override
    public long getNI() throws IOException, JSignException {
        try {
            if (this.eCertificadoPessoaFisica()) {
                return Long.parseLong(this.getValorExtensao("2.16.76.1.3.1").substring(8, 19));
            }
            if (this.eCertificadoPessoaJuridica()) {
                return Long.parseLong(this.getValorExtensao("2.16.76.1.3.3"));
            }
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public long getNIResponsavel() throws IOException, JSignException {
        try {
            if (this.eCertificadoPessoaJuridica()) {
                return Long.parseLong(this.getValorExtensao("2.16.76.1.3.4").substring(8, 19));
            }
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public Date getDataNascimento() throws IOException, JSignException {
        try {
            if (this.eCertificadoPessoaFisica()) {
                String data = this.getValorExtensao("2.16.76.1.3.1").substring(0, 8);
                int dia = Integer.parseInt(data.substring(0, 2));
                int mes = Integer.parseInt(data.substring(2, 4));
                int ano = Integer.parseInt(data.substring(4, 8));
                Calendar c = GregorianCalendar.getInstance();
                c.set(ano, mes - 1, dia);
                return c.getTime();
            }
            if (this.eCertificadoPessoaJuridica()) {
                String data = this.getValorExtensao("2.16.76.1.3.4").substring(0, 8);
                int dia = Integer.parseInt(data.substring(0, 2));
                int mes = Integer.parseInt(data.substring(2, 4));
                int ano = Integer.parseInt(data.substring(4, 8));
                Calendar c = GregorianCalendar.getInstance();
                c.set(ano, mes - 1, dia);
                return c.getTime();
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }
}

