/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto.icp;

import java.io.IOException;
import java.util.Date;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.JSignException;

public abstract class CertificadoICPBrasil
extends X509CertificadoWrapper {
    private static String[][] OIDS_E_TIPOS = new String[][]{{"2.16.76.1.2.1", "A1"}, {"2.16.76.1.2.2", "A2"}, {"2.16.76.1.2.3", "A3"}, {"2.16.76.1.2.4", "A4"}, {"2.16.76.1.2.101", "S1"}, {"2.16.76.1.2.102", "S2"}, {"2.16.76.1.2.103", "S3"}, {"2.16.76.1.2.104", "S4"}};

    protected CertificadoICPBrasil(X509CertificadoWrapper certificado) {
        super(certificado);
    }

    public abstract boolean eCertificadoPessoaFisica() throws IOException;

    public abstract boolean eCertificadoPessoaJuridica() throws IOException;

    public abstract long getNI() throws IOException, JSignException;

    public abstract long getNIResponsavel() throws IOException, JSignException;

    public abstract Date getDataNascimento() throws IOException, JSignException;

    public String getTipoCertificado() throws IOException {
        for (String oidATestar : this.getOIDsPoliticasCertificados()) {
            for (int iOID = 0; iOID < OIDS_E_TIPOS.length; ++iOID) {
                if (!oidATestar.startsWith(OIDS_E_TIPOS[iOID][0])) continue;
                return OIDS_E_TIPOS[iOID][1];
            }
        }
        return null;
    }
}

