/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.aplicacao;

import java.security.Provider;
import java.security.Security;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import jsignnet.aplicacao.LeitorCertificados;
import jsignnet.aplicacao.ValidadorAssinatura;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.security.jgss.SunProvider;

public class JSignNet {
    public static Logger logger = Logger.getLogger("serpro.jsignnet");
    private static boolean fProvidersAdicionados;
    static final String JRE_REQUERIDA_PKCS11 = "1.5.0";
    public static final String NOME_CONTAINER_DEFAULT = "mycontainer.jks";
    public static final String SENHA_CONTAINER_DEFAULT = "receita01";
    static final String windowsSO = "win";
    static final String appleSO = "mac";

    public static void setLogger(Logger logger) {
        JSignNet.logger = logger;
    }

    static void adicionaProviders() {
        if (fProvidersAdicionados) {
            return;
        }
        if (JSignNet.checkSO(windowsSO)) {
            try {
                Class<?> classeSunMSCAPI = Class.forName("sun.security.mscapi.SunMSCAPI");
                Object provider = classeSunMSCAPI.newInstance();
                if (provider instanceof Provider) {
                    Security.addProvider((Provider)provider);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warning("Sem acesso aos certificados do IE.\n" + e.getLocalizedMessage());
            }
            catch (InstantiationException e) {
                logger.warning("Sem acesso aos certificados do IE.\n" + e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                logger.warning("Sem acesso aos certificados do IE.\n" + e.getLocalizedMessage());
            }
        }
        Security.addProvider(new BouncyCastleProvider());
        if (JSignNet.checkJRE(JRE_REQUERIDA_PKCS11)) {
            Security.addProvider(new SunProvider());
        }
        fProvidersAdicionados = true;
    }

    static boolean checkJRE(String versaoComparacao) {
        ComparableVersion versaoRequerida;
        ComparableVersion versaoAtual = new ComparableVersion(System.getProperty("java.version"));
        return versaoAtual.compareTo(versaoRequerida = new ComparableVersion(versaoComparacao)) >= 0;
    }

    static boolean checkSO(String so) {
        String nomeSO = System.getProperty("os.name").toLowerCase();
        return nomeSO.indexOf(so.toLowerCase()) > -1;
    }

    public static LeitorCertificados getLeitorCertificados() {
        return new LeitorCertificados();
    }

    public static ValidadorAssinatura getValidadorAssinatura() {
        return new ValidadorAssinatura();
    }

    static {
        logger.addHandler(new ConsoleHandler());
        JSignNet.adicionaProviders();
    }
}

