/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.aplicacao;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import jsignnet.aplicacao.Ambiente;
import jsignnet.aplicacao.JSignNet;

public class ConfiguradorPKCS11 {
    public static final Confirmacao CONFIGURAR_TODOS = new ConfigurarTodos();
    public static final String NOME_ARQUIVO_INDICE = "naodrivers.dat";
    private Ambiente ambiente = new Ambiente();
    private final File diretorioArquivosConfiguracao;
    private Map<Integer, List<BigInteger>> hashesDriversConfigurados = new HashMap<Integer, List<BigInteger>>();

    public ConfiguradorPKCS11(File diretorioArquivosConfiguracao) {
        if (diretorioArquivosConfiguracao == null) {
            throw new NullPointerException("O diret\u00f3rio de configura\u00e7\u00e3o de tokens precisa ser informado.");
        }
        this.diretorioArquivosConfiguracao = diretorioArquivosConfiguracao;
    }

    public void configurarDriversPKCS11(Confirmacao confirmacao) {
        List<File> arquivosConfiguracao = this.listarArquivosConfiguracao();
        List<File> bibliotecasConfiguradas = this.extrairBiblioteca(arquivosConfiguracao);
        Map<String, File> driversNaoConfigurados = this.reterApenasDriversNaoConfigurados(this.procurarBibliotecasPKCS11());
        for (String nome : driversNaoConfigurados.keySet()) {
            File bibliotecaEncontrada = driversNaoConfigurados.get(nome);
            if (!confirmacao.criarArquivoConfiguracaoPara(bibliotecaEncontrada)) continue;
            Map<String, String> conteudoConfiguracao = this.criarConteudoArquivoConfiguracao(nome, bibliotecaEncontrada);
            File novoArquivoConfiguracao = this.novoNomeArquivoConfiguracao(nome);
            this.gravarArquivoConfiguracao(conteudoConfiguracao, novoArquivoConfiguracao);
        }
    }

    private Map<String, File> reterApenasDriversNaoConfigurados(Map<String, File> drivers) {
        List<File> arquivosConfiguracao = this.listarArquivosConfiguracao();
        List<File> bibliotecasConfiguradas = this.extrairBiblioteca(arquivosConfiguracao);
        HashMap<String, File> copia = new HashMap<String, File>(drivers);
        Iterator it = copia.keySet().iterator();
        while (it.hasNext()) {
            String nome = (String)it.next();
            File bibliotecaEncontrada = (File)copia.get(nome);
            try {
                if (!this.estaPresente(bibliotecaEncontrada, bibliotecasConfiguradas)) continue;
                it.remove();
            }
            catch (IOException e) {
                JSignNet.logger.log(Level.WARNING, nome, e);
                it.remove();
            }
        }
        return copia;
    }

    private Map<String, String> criarConteudoArquivoConfiguracao(String nome, File driver) {
        HashMap<String, String> nova = new HashMap<String, String>();
        nova.put("name", nome);
        nova.put("library", driver.getAbsolutePath());
        return nova;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gravarArquivoConfiguracao(Map<String, String> conteudo, File destino) {
        PrintWriter pw = null;
        try {
            File pasta = destino.getParentFile();
            if (!pasta.exists()) {
                pasta.mkdirs();
            }
            pw = new PrintWriter(destino);
            pw.println("# Configuracao automatica de PKCS#11 - JSignNet");
            pw.println("name=" + conteudo.get("name"));
            pw.println("library=" + conteudo.get("library"));
        }
        catch (IOException e) {
            JSignNet.logger.log(Level.WARNING, "N\u00e3o gravou configura\u00e7\u00e3o para " + conteudo, e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private List<File> listarArquivosConfiguracao() {
        ArrayList<File> arquivos = new ArrayList<File>();
        if (this.diretorioArquivosConfiguracao.exists()) {
            File[] listagem;
            for (File listado : listagem = this.diretorioArquivosConfiguracao.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".cfg");
                }
            })) {
                arquivos.add(listado);
            }
        }
        return arquivos;
    }

    private List<File> extrairBiblioteca(List<File> configuracoes) {
        ArrayList<File> bibliotecas = new ArrayList<File>();
        for (File configuracao : configuracoes) {
            try {
                File extraida = this.extrairBiblioteca(configuracao);
                if (extraida == null) continue;
                bibliotecas.add(extraida);
            }
            catch (IOException e) {
                JSignNet.logger.log(Level.WARNING, "Falha ao ler a biblioteca do arquivo " + configuracao, e);
            }
        }
        return bibliotecas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extrairBiblioteca(File configuracao) throws IOException {
        BufferedReader leitor = new BufferedReader(new FileReader(configuracao));
        try {
            String linha = leitor.readLine();
            while (linha != null) {
                String[] partes = linha.split("=");
                if (partes.length == 2) {
                    String chave = partes[0];
                    String valor = partes[1];
                    if (chave.trim().equalsIgnoreCase("library")) {
                        File file = new File(valor.trim());
                        return file;
                    }
                }
                linha = leitor.readLine();
            }
        }
        finally {
            leitor.close();
        }
        return null;
    }

    private boolean estaPresente(File arquivo, List<File> lista) throws IOException {
        BigInteger hash = this.calcularHash(this.conteudo(arquivo));
        List<BigInteger> hashes = this.hashesDe(lista);
        return hashes.contains(hash);
    }

    private List<BigInteger> hashesDe(List<File> lista) throws IOException {
        int hash = lista.hashCode();
        if (this.hashesDriversConfigurados.containsKey(hash)) {
            return this.hashesDriversConfigurados.get(hash);
        }
        List<BigInteger> novosHashes = this.mapearHashEm(lista);
        this.hashesDriversConfigurados.put(hash, novosHashes);
        return novosHashes;
    }

    private List<BigInteger> mapearHashEm(List<File> lista) throws IOException {
        ArrayList<BigInteger> saida = new ArrayList<BigInteger>();
        for (File arquivo : lista) {
            saida.add(this.calcularHash(this.conteudo(arquivo)));
        }
        return saida;
    }

    private File novoNomeArquivoConfiguracao(String nome) {
        String nomeLimpo = this.limparNome(nome);
        File novoNome = new File(this.diretorioArquivosConfiguracao, "jsignnet-automatico-" + nomeLimpo + ".cfg");
        int i = 2;
        while (novoNome.exists()) {
            novoNome = new File(this.diretorioArquivosConfiguracao, "jsignnet-automatico-" + nomeLimpo + i + ".cfg");
            ++i;
        }
        return novoNome;
    }

    private String limparNome(String nome) {
        return nome.replaceAll(" ", "").toLowerCase();
    }

    private Iterable<File> pastasBibliotecasSistema() {
        if (this.ambiente.linux() || this.ambiente.macosx()) {
            ArrayList<File> pastas = new ArrayList<File>();
            pastas.add(new File("/usr/local/lib"));
            pastas.add(new File("/usr/lib"));
            return pastas;
        }
        if (this.ambiente.windows()) {
            String caminhoWindows = System.getenv("windir");
            return Collections.singletonList(new File(new File(caminhoWindows), "System32"));
        }
        return Collections.emptyList();
    }

    private Map<String, File> procurarBibliotecasPKCS11() {
        LeitorIndice leitor = new LeitorIndice();
        File arquivoIndice = new File(this.diretorioArquivosConfiguracao, NOME_ARQUIVO_INDICE);
        IndiceNaoDrivers indice = leitor.ler(arquivoIndice);
        return this.procurarBibliotecasPKCS11(indice);
    }

    private Map<String, File> procurarBibliotecasPKCS11(IndiceNaoDrivers indice) {
        int tamanhoOriginalIndice = indice.tamanho();
        HashMap<String, File> nomeArquivo = new HashMap<String, File>();
        try {
            double proporcao;
            int quantidadeArquivos = 0;
            for (File arquivo : this.listarArquivos(this.pastasBibliotecasSistema())) {
                ++quantidadeArquivos;
                if (indice.naoEDriver(arquivo)) continue;
                try {
                    if (this.eBibliotecaPKCS11(arquivo)) {
                        nomeArquivo.put(this.criarNomeToken(arquivo), arquivo);
                        continue;
                    }
                    indice.guardarComoNaoDriver(arquivo);
                }
                catch (IOException e) {
                    JSignNet.logger.log(Level.WARNING, "N\u00e3o conseguiu acessar o arquivo " + arquivo, e);
                }
            }
            double d = proporcao = quantidadeArquivos != 0 ? (double)tamanhoOriginalIndice / (double)quantidadeArquivos : 0.0;
            if (proporcao > 1.25 || Math.abs(proporcao) < 0.001) {
                File arquivoIndice = new File(this.diretorioArquivosConfiguracao, NOME_ARQUIVO_INDICE);
                GravadorIndice gravador = new GravadorIndice(arquivoIndice);
                indice.salvar(gravador);
            }
            this.eliminarArquivosDuplicados(nomeArquivo);
        }
        catch (IOException e) {
            JSignNet.logger.log(Level.WARNING, "N\u00e3o listou arquivos", e);
        }
        return nomeArquivo;
    }

    private Iterable<File> listarArquivos(Iterable<File> pastas) throws IOException {
        ArrayList<File> arquivos = new ArrayList<File>();
        for (File pasta : pastas) {
            for (File arquivo : pasta.listFiles()) {
                if (!arquivo.isFile()) continue;
                arquivos.add(arquivo);
            }
        }
        return arquivos;
    }

    private void eliminarArquivosDuplicados(Map<String, File> arquivos) throws IOException {
        HashMap<BigInteger, File> hashes = new HashMap<BigInteger, File>();
        Iterator<Map.Entry<String, File>> i = arquivos.entrySet().iterator();
        while (i.hasNext()) {
            File arquivo = i.next().getValue();
            if (!arquivo.isFile()) {
                i.remove();
                continue;
            }
            BigInteger hash = this.calcularHash(this.conteudo(arquivo));
            if (hashes.containsKey(hash)) {
                i.remove();
                continue;
            }
            hashes.put(hash, arquivo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] conteudo(File arquivo) throws IOException {
        FileInputStream fis = new FileInputStream(arquivo);
        try {
            byte[] buffer = new byte[4096];
            byte[] conteudo = new byte[(int)arquivo.length()];
            int quantidade = -1;
            int pos = 0;
            while ((quantidade = fis.read(buffer)) >= 0) {
                System.arraycopy(buffer, 0, conteudo, pos, quantidade);
                pos += quantidade;
            }
            byte[] byArray = conteudo;
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    private BigInteger calcularHash(byte[] dados) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            md5.update(dados);
            return new BigInteger(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algoritmo MD5 n\u00e3o dispon\u00edvel.");
        }
    }

    private boolean eBibliotecaPKCS11(File arquivo) throws IOException {
        ArrayList<byte[]> assinatura = new ArrayList<byte[]>();
        assinatura.add("C_Sign".getBytes("ascii"));
        assinatura.add("C_SignInit".getBytes("ascii"));
        assinatura.add("C_SignUpdate".getBytes("ascii"));
        assinatura.add("C_Login".getBytes("ascii"));
        assinatura.add("C_Logout".getBytes("ascii"));
        assinatura.add("C_OpenSession".getBytes("ascii"));
        byte[] conteudo = this.conteudo(arquivo);
        for (byte[] metodo : assinatura) {
            if (this.contem(conteudo, metodo)) continue;
            return false;
        }
        return true;
    }

    private boolean contem(byte[] dados, byte[] trecho) {
        int iDados = 0;
        int iTrecho = 0;
        int iMarca = -1;
        while (iDados + trecho.length < dados.length) {
            if (dados[iDados] != trecho[iTrecho]) {
                iTrecho = 0;
                if (iMarca == -1) {
                    ++iDados;
                    continue;
                }
                iDados = iMarca + 1;
                iMarca = -1;
                continue;
            }
            if (iMarca == -1) {
                iMarca = iDados;
            }
            ++iDados;
            if (++iTrecho != trecho.length) continue;
            return true;
        }
        return false;
    }

    private String criarNomeToken(File arquivo) {
        HashMap<String, String> conversoes = new HashMap<String, String>();
        conversoes.put("neoid", "NeoID");
        conversoes.put("serpro", "NeoID");
        conversoes.put("et", "SafeNet_eToken");
        conversoes.put("etoken", "eToken_SafeNet");
        String nome = arquivo.getName().replaceAll("lib", "").replaceAll("p11", "").replaceAll("PKCS11", "").replaceAll("Pkcs11", "").replaceAll(".so", "").replaceAll(".dll", "").replaceAll("pkcs11", "");
        if (conversoes.containsKey(nome.toLowerCase())) {
            return (String)conversoes.get(nome.toLowerCase());
        }
        return nome;
    }

    private static class LeitorIndice {
        private static final String SEPARADOR = "===";

        private LeitorIndice() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndiceNaoDrivers ler(File origem) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(origem));
                IndiceNaoDrivers indice = new IndiceNaoDrivers();
                String linha = null;
                while ((linha = br.readLine()) != null) {
                    String[] partes = linha.split(SEPARADOR);
                    if (partes.length != 2) continue;
                    String nome = partes[0];
                    String tamanho = partes[1];
                    indice.guardarComoNaoDriver(nome, Long.parseLong(tamanho));
                }
                IndiceNaoDrivers indiceNaoDrivers = indice;
                return indiceNaoDrivers;
            }
            catch (IOException e) {
                IndiceNaoDrivers indiceNaoDrivers = new IndiceNaoDrivers();
                return indiceNaoDrivers;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class GravadorIndice {
        private Map<String, Long> dados = new HashMap<String, Long>();
        private final File destino;

        public GravadorIndice(File destino) {
            this.destino = destino;
        }

        public void registrar(String nome, long tamanho) {
            this.dados.put(nome, tamanho);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gravar() {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(this.destino);
                for (Map.Entry<String, Long> dado : this.dados.entrySet()) {
                    if (dado.getKey().indexOf("===") != -1) continue;
                    pw.println(String.format("%s===%d", dado.getKey(), dado.getValue()));
                }
                this.dados.clear();
            }
            catch (IOException e) {
                JSignNet.logger.log(Level.WARNING, "N\u00e3o conseguiu gravar o arquivo de \u00edndice de n\u00e3o drivers em " + this.destino.getAbsolutePath(), e);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private static class IndiceNaoDrivers {
        private HashSet<ItemIndice> indice = new HashSet();

        private IndiceNaoDrivers() {
        }

        public boolean naoEDriver(File arquivo) {
            return this.indice.contains(new ItemIndice(arquivo));
        }

        public void guardarComoNaoDriver(File arquivo) {
            this.indice.add(new ItemIndice(arquivo));
        }

        public void guardarComoNaoDriver(String caminhoArquivo, long tamanho) {
            this.indice.add(new ItemIndice(caminhoArquivo, tamanho));
        }

        public void salvar(GravadorIndice gravador) {
            for (ItemIndice item : this.indice) {
                gravador.registrar(item.nome, item.tamanho);
            }
            gravador.gravar();
        }

        public int tamanho() {
            return this.indice.size();
        }

        private static class ItemIndice {
            private final String nome;
            private final long tamanho;

            public ItemIndice(File arquivo) {
                this.nome = arquivo.getAbsolutePath();
                this.tamanho = arquivo.length();
            }

            public ItemIndice(String nome, long tamanho) {
                this.nome = nome;
                this.tamanho = tamanho;
            }

            public int hashCode() {
                int result = 17;
                result = 31 * result + (this.nome != null ? this.nome.hashCode() : 0);
                result = 31 * result + (int)(this.tamanho ^ this.tamanho >>> 32);
                return result;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ItemIndice object = (ItemIndice)o;
                if (this.nome != null ? !this.nome.equals(object.nome) : object.nome != null) {
                    return false;
                }
                return this.tamanho == object.tamanho;
            }
        }
    }

    private static final class ConfigurarTodos
    implements Confirmacao {
        private ConfigurarTodos() {
        }

        @Override
        public boolean criarArquivoConfiguracaoPara(File arquivoDriver) {
            return true;
        }
    }

    public static interface Confirmacao {
        public boolean criarArquivoConfiguracaoPara(File var1);
    }
}

