/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrefixInputStream
extends FilterInputStream {
    private long _tamanhoPrefixo;
    private long _lidosAteAgora;

    public PrefixInputStream(InputStream in, long tamanhoPrefixo) {
        super(in);
        if (in == null) {
            throw new NullPointerException();
        }
        if (tamanhoPrefixo < 0L) {
            throw new IllegalArgumentException();
        }
        this._tamanhoPrefixo = tamanhoPrefixo;
    }

    public int read() throws IOException {
        if (this._lidosAteAgora >= this._tamanhoPrefixo) {
            return -1;
        }
        int b = this.in.read();
        ++this._lidosAteAgora;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._lidosAteAgora >= this._tamanhoPrefixo) {
            return -1;
        }
        long quantoFalta = this._tamanhoPrefixo - this._lidosAteAgora;
        len = (int)Math.min(quantoFalta, (long)len);
        int cb = this.in.read(b, off, len);
        this._lidosAteAgora += (long)cb;
        return cb;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

