/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendavariavel;

import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelRendaVariavelFundosInvestimentos
extends IRPFTableModelAb {
    private static final long serialVersionUID = 1L;
    private FundosInvestimentos fundosInvestimentos;
    private static final String LBL_MES = "<html><center>M\u00eas</center></html>";
    private static final String RES_LIQ_MES = "<html><center>Resultado<br>l\u00edquido<br>do m\u00eas</center></html>";
    private static final String RES_NEG_ATE_MES_ANT = "<html><center>Resultado<br>negativo<br>at\u00e9 o m\u00eas<br>anterior</center></html>";
    private static final String BASE_CALCULO_IMPOSTO = "<html><center>Base de<br>c\u00e1lculo do<br>imposto</center></html>";
    private static final String PREJUIZO_COMPENSAR = "<html><center>Preju\u00edzo a<br>compensar</center></html>";
    private static final String ALIQUOTA_IMPOSTO = "<html><center>Al\u00edquota do<br>imposto</center></html>";
    private static final String IMPOSTO_DEVIDO = "<html><center>Imposto<br>devido</center></html>";
    private static final String IMPOSTO_RETIDO_MESES_ANTERIORES = "<html><center>Saldo do<br>imposto<br>retido<br>nos meses<br>anteriores<br>(Lei<br>11.033/2004)</center></html>";
    private static final String IMPOSTO_RETIDO_FONTE = "<html><center>Imposto<br>retido<br>no m\u00eas<br>(Lei<br>11.033/2004)</center></html>";
    private static final String IMPOSTO_RETIDO_COMPENSAR = "<html><center>Imposto a<br>compensar<br>(Lei<br>11.033/2004)</center></html>";
    private static final String IMPOSTO_A_PAGAR = "<html><center>Imposto<br>a pagar</center></html>";
    private static final String IMPOSTO_PAGO = "<html><center>Imposto<br>pago</center></html>";

    public TableModelRendaVariavelFundosInvestimentos(FundosInvestimentos fundosInvestimentos) {
        super((ObjetoNegocio)fundosInvestimentos);
        this.fundosInvestimentos = fundosInvestimentos;
    }

    public int getRowCount() {
        return 12;
    }

    public int getColumnCount() {
        return 12;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getCelulaMes(rowIndex);
        }
        return this.getInformacaoAt(rowIndex, columnIndex);
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return LBL_MES;
            }
            case 1: {
                return RES_LIQ_MES;
            }
            case 2: {
                return RES_NEG_ATE_MES_ANT;
            }
            case 3: {
                return BASE_CALCULO_IMPOSTO;
            }
            case 4: {
                return PREJUIZO_COMPENSAR;
            }
            case 5: {
                return ALIQUOTA_IMPOSTO;
            }
            case 6: {
                return IMPOSTO_DEVIDO;
            }
            case 7: {
                return IMPOSTO_RETIDO_MESES_ANTERIORES;
            }
            case 8: {
                return IMPOSTO_RETIDO_FONTE;
            }
            case 9: {
                return IMPOSTO_RETIDO_COMPENSAR;
            }
            case 10: {
                return IMPOSTO_A_PAGAR;
            }
            case 11: {
                return IMPOSTO_PAGO;
            }
        }
        return "";
    }

    public Informacao getInformacaoAt(int row, int col) {
        MesFundosInvestimentos mes = null;
        switch (row) {
            case 0: {
                mes = this.fundosInvestimentos.getJan();
                break;
            }
            case 1: {
                mes = this.fundosInvestimentos.getFev();
                break;
            }
            case 2: {
                mes = this.fundosInvestimentos.getMar();
                break;
            }
            case 3: {
                mes = this.fundosInvestimentos.getAbr();
                break;
            }
            case 4: {
                mes = this.fundosInvestimentos.getMai();
                break;
            }
            case 5: {
                mes = this.fundosInvestimentos.getJun();
                break;
            }
            case 6: {
                mes = this.fundosInvestimentos.getJul();
                break;
            }
            case 7: {
                mes = this.fundosInvestimentos.getAgo();
                break;
            }
            case 8: {
                mes = this.fundosInvestimentos.getSet();
                break;
            }
            case 9: {
                mes = this.fundosInvestimentos.getOut();
                break;
            }
            case 10: {
                mes = this.fundosInvestimentos.getNov();
                break;
            }
            case 11: {
                mes = this.fundosInvestimentos.getDez();
                break;
            }
            default: {
                return null;
            }
        }
        switch (col) {
            case 1: {
                return mes.getResultLiquidoMes();
            }
            case 2: {
                return mes.getResultNegativoAnterior();
            }
            case 3: {
                return mes.getBaseCalcImposto();
            }
            case 4: {
                return mes.getPrejuizoCompensar();
            }
            case 5: {
                return mes.getAliquotaImposto();
            }
            case 6: {
                return mes.getImpostoDevido();
            }
            case 7: {
                return mes.getImpostoRetidoMesesAnteriores();
            }
            case 8: {
                return mes.getImpostoRetidoFonte();
            }
            case 9: {
                return mes.getImpostoRetidoCompensar();
            }
            case 10: {
                return mes.getImpostoAPagar();
            }
            case 11: {
                return mes.getImpostoPago();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Espolio espolio;
        Data dtLimite;
        if (columnIndex == 0 || columnIndex == 9 || columnIndex == 10 || columnIndex > 1 && columnIndex < 8 && (columnIndex != 2 || rowIndex != 0)) {
            return false;
        }
        boolean editavel = true;
        if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
            String mesCondicaoNaoResidente;
            Saida saida = IRPFFacade.getInstancia().getSaida();
            String string = mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
            if (rowIndex > Integer.valueOf(mesCondicaoNaoResidente) - 1) {
                editavel = false;
            }
        } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio() && !IRPFFacade.getInstancia().getDeclaracao().getEspolio().isBensInventariarMarcado() && !(dtLimite = (espolio = IRPFFacade.getInstancia().getEspolio()).obterDataLimiteParaCalculos()).isVazio()) {
            String mesDecisaoJudicial = dtLimite.getMes();
            editavel = !mesDecisaoJudicial.isEmpty() && rowIndex < Integer.valueOf(mesDecisaoJudicial);
        }
        return editavel && !ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isTransmitida();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Informacao val = this.getInformacaoAt(rowIndex, columnIndex);
        val.setConteudo((String)aValue);
    }

    private void setFundosInvestimentos(FundosInvestimentos investimentos) {
        if (this.fundosInvestimentos != null) {
            this.fundosInvestimentos.removeObservadores(new Class[]{JEditValor.class});
        }
        this.fundosInvestimentos = investimentos;
        this.fireTableDataChanged();
    }

    public ObjetoNegocio getObjetoNegocio() {
        return this.fundosInvestimentos;
    }

    public void setObjetoNegocio(ObjetoNegocio pObj) {
        this.setFundosInvestimentos((FundosInvestimentos)pObj);
    }
}

