/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendavariavel;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelFundosInvestimentosDependentes
extends TableListaModel {
    private static final long serialVersionUID = 1L;

    public TableModelFundosInvestimentosDependentes(ColecaoFundosInvestimentosDependente colecaoFundosInvestimentosDependente) {
        super((ObjetoNegocio)colecaoFundosInvestimentosDependente);
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "CPF";
            }
            case 2: {
                return "Nome";
            }
        }
        return "";
    }

    public Informacao getInformacaoAt(int row, int col) {
        ColecaoFundosInvestimentosDependente dependentes = (ColecaoFundosInvestimentosDependente)this.getObjetoNegocio();
        ItemFundosInvestimentosDependente item = (ItemFundosInvestimentosDependente)dependentes.itens().get(row);
        switch (col) {
            case 0: {
                return super.getInformacaoAt(row, col);
            }
            case 1: {
                return item.getCpf().naoFormatado().equals("1") ? null : item.getCpf();
            }
            case 2: {
                return item.getCpf().isVazio() ? null : this.getNomeByCpf(item.getCpf());
            }
        }
        return null;
    }

    private Alfa getNomeByCpf(CPF cpf) {
        Dependentes dependentes = IRPFFacade.getInstancia().getDependentes();
        for (Dependente d : dependentes.itens()) {
            if (!d.getCpfDependente().naoFormatado().equals(cpf.naoFormatado())) continue;
            return d.getNome();
        }
        return new Alfa();
    }
}

