/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendavariavel;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelComAbasAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.listener.DemonstrativoListener;
import serpro.ppgd.irpf.gui.rendavariavel.PainelRendaVariavelMensal;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;

public class PainelDadosRendaVariavel
extends PainelComAbasAb
implements PainelAbaIf,
DemonstrativoListener {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Demonstrativo de Apura\u00e7\u00e3o de Ganhos - Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns e Day-Trade";
    private static PainelDadosRendaVariavel instancia;
    private PainelDemonstrativoIf painelPai;
    private PainelRendaVariavelMensal janeiro;
    private PainelRendaVariavelMensal fevereiro;
    private PainelRendaVariavelMensal marco;
    private PainelRendaVariavelMensal abril;
    private PainelRendaVariavelMensal maio;
    private PainelRendaVariavelMensal junho;
    private PainelRendaVariavelMensal julho;
    private PainelRendaVariavelMensal agosto;
    private PainelRendaVariavelMensal setembro;
    private PainelRendaVariavelMensal outubro;
    private PainelRendaVariavelMensal novembro;
    private PainelRendaVariavelMensal dezembro;
    private PainelRendaVariavelMensal[] meses;

    public PainelDadosRendaVariavel(PainelDemonstrativoIf painelPai) {
        super("/icones/png40px/RV_daytrade.png");
        this.meses = new PainelRendaVariavelMensal[]{this.janeiro, this.fevereiro, this.marco, this.abril, this.maio, this.junho, this.julho, this.agosto, this.setembro, this.outubro, this.novembro, this.dezembro};
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.painelPai = painelPai;
        this.getTabbedPane().setTabPlacement(2);
        ControladorGui.addDemonstrativoListener((DemonstrativoListener)this);
    }

    public static PainelDadosRendaVariavel getInstancia(PainelDemonstrativoIf painelPai) {
        if (instancia == null) {
            instancia = new PainelDadosRendaVariavel(painelPai);
        }
        return instancia;
    }

    public static PainelDadosRendaVariavel getInstancia(PainelDemonstrativoIf painelPai, ItemRendaVariavelDependente item) {
        if (instancia == null) {
            instancia = PainelDadosRendaVariavel.getInstancia(painelPai);
        }
        instancia.setItem(item);
        return instancia;
    }

    protected void montarAbas() {
        this.janeiro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Janeiro");
        this.fevereiro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Fevereiro");
        this.marco = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Mar\u00e7o");
        this.abril = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Abril");
        this.maio = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Maio");
        this.junho = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Junho");
        this.julho = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Julho");
        this.agosto = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Agosto");
        this.setembro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Setembro");
        this.outubro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Outubro");
        this.novembro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Novembro");
        this.dezembro = new PainelRendaVariavelMensal((PainelDemonstrativoIf)this, "Dezembro");
        this.getTabbedPane().addTab(this.janeiro.getNomeAba(), (Component)((Object)this.janeiro));
        this.getTabbedPane().addTab(this.fevereiro.getNomeAba(), (Component)((Object)this.fevereiro));
        this.getTabbedPane().addTab(this.marco.getNomeAba(), (Component)((Object)this.marco));
        this.getTabbedPane().addTab(this.abril.getNomeAba(), (Component)((Object)this.abril));
        this.getTabbedPane().addTab(this.maio.getNomeAba(), (Component)((Object)this.maio));
        this.getTabbedPane().addTab(this.junho.getNomeAba(), (Component)((Object)this.junho));
        this.getTabbedPane().addTab(this.julho.getNomeAba(), (Component)((Object)this.julho));
        this.getTabbedPane().addTab(this.agosto.getNomeAba(), (Component)((Object)this.agosto));
        this.getTabbedPane().addTab(this.setembro.getNomeAba(), (Component)((Object)this.setembro));
        this.getTabbedPane().addTab(this.outubro.getNomeAba(), (Component)((Object)this.outubro));
        this.getTabbedPane().addTab(this.novembro.getNomeAba(), (Component)((Object)this.novembro));
        this.getTabbedPane().addTab(this.dezembro.getNomeAba(), (Component)((Object)this.dezembro));
    }

    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha((String)this.getTituloPainel());
    }

    protected String[] definirNomeAbas() {
        String[] abas = new String[12];
        for (int i = 0; i < abas.length; ++i) {
            abas[i] = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade";
        }
        return abas;
    }

    protected void configObservadores() {
    }

    public String getTituloPainel() {
        return this.getNomeAbas()[0];
    }

    public String getMensagemTela() {
        String retorno = null;
        retorno = "<html>Este demonstrativo deve ser preenchido pelo contribuinte pessoa f\u00edsica, residente ou domiciliado no Brasil, que durante o ano-calend\u00e1rio de " + ConstantesGlobais.EXERCICIO_ANTERIOR + " efetuou no Brasil:<br><br>a) aliena\u00e7\u00e3o de a\u00e7\u00f5es no mercado \u00e0 vista em bolsa de valores;<br>b) aliena\u00e7\u00e3o de ouro, ativo financeiro, no mercado dispon\u00edvel ou \u00e0 vista em bolsa de mercadorias,     de futuro ou diretamente junto a institui\u00e7\u00f5es financeiras;<br>c) opera\u00e7\u00f5es nos mercados a termo, de op\u00e7\u00f5es e futuro, realizadas em bolsa de valores,     de mercadorias e de futuros, com qualquer ativo.<br>d) opera\u00e7\u00f5es realizadas em mercados de liquida\u00e7\u00e3o futura, fora de bolsa, inclusive com op\u00e7\u00f5es flex\u00edveis.</html>";
        return retorno;
    }

    public boolean isTelaComMensagem() {
        return true;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public void preExibir() {
        if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
            Saida saida = IRPFFacade.getInstancia().getSaida();
            String mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
            for (int i = 0; i < 12; ++i) {
                this.getTabbedPane().setEnabledAt(i, i <= Integer.valueOf(mesCondicaoNaoResidente) - 1);
            }
        } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Espolio espolio = IRPFFacade.getInstancia().getEspolio();
                    Data dtLimite = espolio.obterDataLimiteParaCalculos();
                    String mesDecisaoJudicial = dtLimite.getMes();
                    if (!dtLimite.isVazio() && !IRPFFacade.getInstancia().getDeclaracao().getEspolio().isBensInventariarMarcado()) {
                        for (int i = 0; i < 12; ++i) {
                            boolean editavel = !mesDecisaoJudicial.isEmpty() && i < Integer.valueOf(mesDecisaoJudicial);
                            PainelDadosRendaVariavel.this.getTabbedPane().setEnabledAt(i, editavel);
                        }
                    } else {
                        for (int i = 0; i < 12; ++i) {
                            PainelDadosRendaVariavel.this.getTabbedPane().setEnabledAt(i, true);
                        }
                    }
                }
            });
        }
        if (!this.getTabbedPane().isEnabledAt(this.getTabbedPane().getSelectedIndex())) {
            this.getTabbedPane().setSelectedIndex(this.obterIndicePrimeiraAbaHabilitada());
        }
    }

    private int obterIndicePrimeiraAbaHabilitada() {
        int retorno = 0;
        for (int i = 0; i < 12; ++i) {
            if (!this.getTabbedPane().isEnabledAt(i)) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public void aposCriarAbas() {
    }

    public String getNomeAba() {
        return "Titular";
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public PainelRendaVariavelMensal[] getMeses() {
        return this.meses;
    }

    public void setItem(ItemRendaVariavelDependente item) {
        this.janeiro.setItem(item);
        this.fevereiro.setItem(item);
        this.marco.setItem(item);
        this.abril.setItem(item);
        this.maio.setItem(item);
        this.junho.setItem(item);
        this.julho.setItem(item);
        this.agosto.setItem(item);
        this.setembro.setItem(item);
        this.outubro.setItem(item);
        this.novembro.setItem(item);
        this.dezembro.setItem(item);
    }

    public void demonstrativoAberto() {
    }

    public boolean demonstrativoVaiFechar() {
        instancia = null;
        return true;
    }

    public void demonstrativoFechado() {
    }

    public void demonstrativoSalvo() {
    }

    public void mudouNumeroDemonstrativos() {
    }

    public void alterouOpcaoTributacao(DeclaracaoIRPF dec) {
    }

    public void demonstrativoVaiGravar() {
    }

    public void demonstrativoGravado() {
    }
}

