/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.ExecutaHiperlinkDicas;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.gui.HtmlParser;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.negocio.util.UtilitariosString;

public class PainelDicas
extends JPanel {
    public static final int DICAS_AVISO = 2;
    public static final int DICAS_ATENCAO = 1;
    public static final int DICAS_ERRO = 3;
    public static final int DICAS_ERRO_IMPEDITIVO = 5;
    private final int TAM_ICO_FECHARDICAS = 19;
    private final int ALT_ICO_FECHARDICAS = 16;
    private final int ALT_LB_TITULO = 24;
    private final int TAM_MARGEM = 5;
    private final ImageIcon ICO_FECHARDICAS = ConstantesGlobaisGUI.ICO_FECHARDICAS;
    private final ImageIcon ICO_FECHARDICASDESABILITADO = ConstantesGlobaisGUI.ICO_FECHARDICASDESABILITADO;
    private Box boxDicas;
    private Box boxTitulo;
    private JEditorPane editDicas;
    private JLabel lbTitulo;
    private JLabel lbIcone;

    public PainelDicas() {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.boxTitulo = new Box(0);
        this.lbTitulo = new JLabel();
        this.lbTitulo.setOpaque(true);
        this.boxTitulo.add(this.lbTitulo);
        this.lbIcone = new JLabel(this.ICO_FECHARDICAS);
        this.lbIcone.addMouseListener(new EsconderDicas());
        this.boxTitulo.add(this.lbIcone);
        this.editDicas = new JEditorPane("text/html", " ");
        this.editDicas.setEditable(false);
        this.editDicas.addHyperlinkListener(new ExecutaHiperlinkDicas());
        this.boxDicas = new Box(1);
        this.boxDicas.add(this.boxTitulo);
        this.add((Component)this.editDicas, "Center");
        this.add((Component)this.boxDicas, "North");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                PainelDicas.this.esconderPainelDicas();
            }
        });
    }

    public void mostrarPainelDicas(int tipo, String titulo, String texto, int x, int y, int tamMin, boolean pExibeFechar) {
        this.mostrarPainelDicas(tipo, titulo, texto, x, y, tamMin);
        this.lbIcone.setVisible(pExibeFechar);
    }

    public void mostrarPainelDicas(int tipo, String titulo, String texto, int x, int y, int tamMin) {
        Color c = null;
        Color corTitulo = null;
        String fonteHTML = null;
        switch (tipo) {
            case 2: {
                c = ConstantesGlobaisGUI.COR_BORDA_PAINEL_DICAS_AVISO;
                corTitulo = ConstantesGlobaisGUI.COR_TITULO_PAINEL_DICAS_AVISO;
                break;
            }
            case 1: {
                c = ConstantesGlobaisGUI.COR_BORDA_PAINEL_DICAS_ATENCAO;
                corTitulo = ConstantesGlobaisGUI.COR_TITULO_PAINEL_DICAS_ATENCAO;
                break;
            }
            case 3: {
                c = ConstantesGlobaisGUI.COR_BORDA_PAINEL_DICAS_ERRO;
                corTitulo = ConstantesGlobaisGUI.COR_TITULO_PAINEL_DICAS_ERRO;
                break;
            }
            default: {
                c = ConstantesGlobaisGUI.COR_BORDA_PAINEL_DICAS_DEFAULT;
                corTitulo = ConstantesGlobaisGUI.COR_TITULO_PAINEL_DICAS_DEFAULT;
            }
        }
        boolean isLinux = System.getProperty("os.name").toUpperCase().indexOf("LINUX") != -1;
        fonteHTML = isLinux ? "<font size=\"2\" face=\"Verdana\">" : "<font size=\"3\">";
        this.lbTitulo.setText("<HTML><B>" + titulo + "</B></HTML>");
        this.lbTitulo.setBackground(c);
        this.lbTitulo.setForeground(corTitulo);
        this.editDicas.setForeground(c);
        this.boxTitulo.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
        this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, c));
        this.setBackground(c);
        texto = UtilitariosString.expandeStringHTML((String)texto, (String)fonteHTML, (int)0);
        this.editDicas.setText(texto);
        FontMetrics fm = this.getFontMetrics(this.editDicas.getFont());
        int tamTitulo = SwingUtilities.computeStringWidth(fm, titulo);
        tamMin = Math.max(tamMin, tamTitulo + 5) + 19;
        ParserCallbackLocal callback = new ParserCallbackLocal(fm, tamMin - 4, texto.length());
        new HtmlParser(texto, callback);
        int nrLinhas = callback.getNrLinhas();
        int ajuste = 0;
        if (nrLinhas <= 3) {
            ajuste = 3;
        } else if (nrLinhas > 35) {
            tamTitulo *= 3;
            nrLinhas = 35;
        }
        int alt = (nrLinhas + 1) * (fm.getHeight() + ajuste) + 24;
        if (alt > 500) {
            tamMin += 100;
            alt -= 50;
        }
        tamMin = Math.max(tamMin, tamTitulo + 5) + 19;
        if (nrLinhas >= 6) {
            alt += 3;
        }
        UtilitariosGUI.setParametrosGUI((JComponent)this.lbTitulo, tamMin - 19, 16);
        UtilitariosGUI.setParametrosGUI((JComponent)this.editDicas, tamMin, alt - 24);
        Rectangle r = this.getRootPane().getBounds();
        Insets i = this.getRootPane().getInsets();
        if ((double)(x + tamMin) > r.getWidth()) {
            x = (int)r.getWidth() - tamMin - i.right - i.left - 10;
        }
        if ((double)(y + alt) > r.getHeight()) {
            y = (int)r.getHeight() - alt - i.top - i.bottom - 10;
        }
        this.setBounds(x, y, tamMin, alt);
        this.setVisible(true);
    }

    public void esconderPainelDicas() {
        this.setVisible(false);
    }

    class EsconderDicas
    extends MouseAdapter {
        EsconderDicas() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PainelDicas.this.lbIcone.setIcon(PainelDicas.this.ICO_FECHARDICASDESABILITADO);
            FabricaGUI.mudaCursorNoComponente((Component)e.getSource(), 12);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PainelDicas.this.lbIcone.setIcon(PainelDicas.this.ICO_FECHARDICAS);
            FabricaGUI.mudaCursorNoComponente((Component)e.getSource(), 0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PainelDicas.this.esconderPainelDicas();
        }
    }

    class ParserCallbackLocal
    extends HTMLEditorKit.ParserCallback {
        private FontMetrics fm;
        private int tamMax;
        private int posFinal;
        private String htmlTexto;
        private int nrLinhasHtml;

        public ParserCallbackLocal(FontMetrics fm, int tamMax, int posFinal) {
            this.fm = fm;
            this.tamMax = tamMax;
            this.posFinal = posFinal;
            this.nrLinhasHtml = 0;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t.breaksFlow() || pos >= this.posFinal) {
                this.nrLinhasHtml += this.calculaNrLinhas(this.htmlTexto);
                this.htmlTexto = null;
            }
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (t.toString().equals("html")) {
                this.nrLinhasHtml += this.calculaNrLinhas(this.htmlTexto);
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            this.htmlTexto = this.htmlTexto == null ? String.copyValueOf(data) : this.htmlTexto + String.copyValueOf(data);
        }

        public int getNrLinhas() {
            return this.nrLinhasHtml;
        }

        private int calculaNrLinhas(String texto) {
            String s = "";
            String lin = "";
            int count = 0;
            if (texto == null) {
                return 0;
            }
            StringTokenizer sToken = new StringTokenizer(texto);
            if (sToken.countTokens() == 0) {
                return 0;
            }
            if (sToken.countTokens() == 1) {
                return 1;
            }
            while (sToken.hasMoreTokens()) {
                String token = sToken.nextToken();
                s = lin + token + " ";
                int tam = SwingUtilities.computeStringWidth(this.fm, s);
                if (tam >= this.tamMax) {
                    lin = "";
                    ++count;
                }
                lin = lin + token + " ";
            }
            if (s != "") {
                ++count;
            }
            return count;
        }
    }
}

