/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.strings.StringDecoderImpl;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;

public class BoundedStringDecoderImpl
extends StringDecoderImpl {
    protected final int valueMaxLength;
    protected final int valuePartitionCapacity;
    protected int globalID;
    protected LocalIDMap[] localIdMapping;

    public BoundedStringDecoderImpl(boolean localValuePartitions, int valueMaxLength, int valuePartitionCapacity) {
        super(localValuePartitions);
        this.valueMaxLength = valueMaxLength;
        this.valuePartitionCapacity = valuePartitionCapacity;
        this.globalID = -1;
        if (valuePartitionCapacity > 0 && localValuePartitions) {
            this.localIdMapping = new LocalIDMap[valuePartitionCapacity];
        }
    }

    public void addValue(QNameContext context, StringValue value) {
        if (this.valueMaxLength < 0 || value.getCharactersLength() <= this.valueMaxLength) {
            if (this.valuePartitionCapacity < 0) {
                super.addValue(context, value);
            } else if (this.valuePartitionCapacity != 0) {
                assert (!this.globalValues.contains(value));
                if (++this.globalID == this.valuePartitionCapacity) {
                    this.globalID = 0;
                }
                if (this.globalValues.size() > this.globalID) {
                    Value prev = this.globalValues.set(this.globalID, value);
                    if (prev != null && this.localValuePartitions) {
                        LocalIDMap lvsFree = this.localIdMapping[this.globalID];
                        assert (lvsFree != null);
                    }
                } else {
                    assert (!this.globalValues.contains(value));
                    this.globalValues.add(value);
                }
                if (this.localValuePartitions) {
                    this.localIdMapping[this.globalID] = new LocalIDMap(this.getNumberOfStringValues(context), context);
                    this.addLocalValue(context, value);
                }
            }
        }
    }

    public void clear() {
        super.clear();
        this.globalID = -1;
    }

    static class LocalIDMap {
        final int localID;
        final QNameContext context;

        public LocalIDMap(int localID, QNameContext context) {
            this.localID = localID;
            this.context = context;
        }
    }
}

