/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIBodyEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.EncodingOptions;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.AbstractEXIBodyCoder;
import com.siemens.ct.exi.core.EXIHeaderEncoder;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.WhiteSpace;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.AttributeNS;
import com.siemens.ct.exi.grammars.event.Characters;
import com.siemens.ct.exi.grammars.event.DatatypeEvent;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementNS;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.GrammarType;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.TypeEncoder;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import com.siemens.ct.exi.values.QNameValue;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import com.siemens.ct.exi.values.ValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public abstract class AbstractEXIBodyEncoder
extends AbstractEXIBodyCoder
implements EXIBodyEncoder {
    protected final EXIHeaderEncoder exiHeader = new EXIHeaderEncoder();
    protected String sePrefix = null;
    protected EncoderChannel channel;
    protected final TypeEncoder typeEncoder;
    protected final StringEncoder stringEncoder;
    protected final EncodingOptions encodingOptions;
    protected List<Value> bChars;
    protected boolean isXmlSpacePreserve;
    protected EventType lastEvent;
    private char[] cbuffer;

    public AbstractEXIBodyEncoder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.typeEncoder = exiFactory.createTypeEncoder();
        this.stringEncoder = exiFactory.createStringEncoder();
        this.encodingOptions = exiFactory.getEncodingOptions();
        this.bChars = new ArrayList<Value>();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.learnedProductions = 0;
        this.stringEncoder.clear();
        if (this.exiFactory.getSharedStrings() != null) {
            this.stringEncoder.setSharedStrings(this.exiFactory.getSharedStrings());
        }
        this.bChars.clear();
        this.isXmlSpacePreserve = false;
    }

    protected QNameContext encodeQName(String namespaceUri, String localName, EncoderChannel channel) throws IOException {
        AbstractEXIBodyCoder.RuntimeUriContext ruc = this.encodeUri(namespaceUri, channel);
        return this.encodeLocalName(localName, ruc, channel);
    }

    protected AbstractEXIBodyCoder.RuntimeUriContext encodeUri(String namespaceUri, EncoderChannel channel) throws IOException {
        int numberBitsUri = MethodsBag.getCodingLength(this.getNumberOfUris() + 1);
        AbstractEXIBodyCoder.RuntimeUriContext ruc = this.getUri(namespaceUri);
        if (ruc == null) {
            channel.encodeNBitUnsignedInteger(0, numberBitsUri);
            channel.encodeString(namespaceUri);
            ruc = this.addUri(namespaceUri);
        } else {
            channel.encodeNBitUnsignedInteger(ruc.namespaceUriID + 1, numberBitsUri);
        }
        return ruc;
    }

    protected void encodeQNamePrefix(QNameContext qnContext, String prefix, EncoderChannel channel) throws IOException {
        AbstractEXIBodyCoder.RuntimeUriContext ruc;
        int numberOfPrefixes;
        int namespaceUriID = qnContext.getNamespaceUriID();
        if (namespaceUriID != 0 && (numberOfPrefixes = (ruc = this.getUri(namespaceUriID)).getNumberOfPrefixes()) > 1) {
            int pfxID = ruc.getPrefixID(prefix);
            if (pfxID == -1) {
                pfxID = 0;
            }
            channel.encodeNBitUnsignedInteger(pfxID, MethodsBag.getCodingLength(numberOfPrefixes));
        }
    }

    protected QNameContext encodeLocalName(String localName, AbstractEXIBodyCoder.RuntimeUriContext ruc, EncoderChannel channel) throws IOException {
        QNameContext qnc = ruc.getQNameContext(localName);
        if (qnc == null) {
            channel.encodeUnsignedInteger(localName.length() + 1);
            channel.encodeStringOnly(localName);
            qnc = ruc.addQNameContext(localName);
        } else {
            channel.encodeUnsignedInteger(0);
            int n = MethodsBag.getCodingLength(ruc.getNumberOfQNames());
            channel.encodeNBitUnsignedInteger(qnc.getLocalNameID(), n);
        }
        return qnc;
    }

    protected void encodeNamespacePrefix(AbstractEXIBodyCoder.RuntimeUriContext uriContext, String prefix, EncoderChannel channel) throws IOException {
        int nPfx = MethodsBag.getCodingLength(uriContext.getNumberOfPrefixes() + 1);
        int pfxID = uriContext.getPrefixID(prefix);
        if (pfxID == -1) {
            channel.encodeNBitUnsignedInteger(0, nPfx);
            channel.encodeString(prefix);
            uriContext.addPrefix(prefix);
        } else {
            channel.encodeNBitUnsignedInteger(pfxID + 1, nPfx);
        }
    }

    public void flush() throws IOException {
        this.channel.flush();
    }

    protected void writeString(String text) throws IOException {
        this.channel.encodeString(text);
    }

    protected boolean isTypeValid(Datatype datatype, Value value) {
        return this.typeEncoder.isValid(datatype, value);
    }

    protected abstract void writeValue(QNameContext var1) throws IOException;

    protected void encode1stLevelEventCode(int pos) throws IOException {
        int codeLength = this.fidelityOptions.get1stLevelEventCodeLength(this.getCurrentGrammar());
        if (codeLength > 0) {
            this.channel.encodeNBitUnsignedInteger(pos, codeLength);
        }
    }

    protected void encode2ndLevelEventCode(int pos) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        this.channel.encodeNBitUnsignedInteger(currentGrammar.getNumberOfEvents(), this.fidelityOptions.get1stLevelEventCodeLength(currentGrammar));
        int ch2 = this.fidelityOptions.get2ndLevelCharacteristics(currentGrammar);
        assert (pos < ch2);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch2));
    }

    protected void encode3rdLevelEventCode(int pos) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        this.channel.encodeNBitUnsignedInteger(currentGrammar.getNumberOfEvents(), this.fidelityOptions.get1stLevelEventCodeLength(currentGrammar));
        int ch2 = this.fidelityOptions.get2ndLevelCharacteristics(currentGrammar);
        int ec2 = ch2 > 0 ? ch2 - 1 : 0;
        this.channel.encodeNBitUnsignedInteger(ec2, MethodsBag.getCodingLength(ch2));
        int ch3 = this.fidelityOptions.get3rdLevelCharacteristics();
        assert (pos < ch3);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch3));
    }

    public void encodeStartDocument() throws EXIException, IOException {
        if (this.channel == null) {
            throw new EXIException("No valid EXI OutputStream set for encoding. Please use setOutput( ... )");
        }
        this.initForEachRun();
        Production ei = this.getCurrentGrammar().getProduction(EventType.START_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for startDocument");
        }
        this.updateCurrentRule(ei.getNextGrammar());
        this.lastEvent = EventType.START_DOCUMENT;
    }

    public void encodeEndDocument() throws EXIException, IOException {
        this.checkPendingCharacters(EventType.END_DOCUMENT);
        Production ei = this.getCurrentGrammar().getProduction(EventType.END_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for endDocument");
        }
        this.encode1stLevelEventCode(ei.getEventCode());
        this.lastEvent = EventType.END_DOCUMENT;
    }

    public void encodeStartElement(QName se) throws EXIException, IOException {
        this.encodeStartElement(se.getNamespaceURI(), se.getLocalPart(), se.getPrefix());
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException, IOException {
        Grammar updContextRule;
        StartElement nextSE;
        this.checkPendingCharacters(EventType.START_ELEMENT);
        this.sePrefix = prefix;
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getStartElementProduction(uri, localName);
        if (ei != null) {
            assert (ei.getEvent().isEventType(EventType.START_ELEMENT));
            this.encode1stLevelEventCode(ei.getEventCode());
            nextSE = (StartElement)ei.getEvent();
            if (this.preservePrefix) {
                this.encodeQNamePrefix(nextSE.getQNameContext(), prefix, this.channel);
            }
            updContextRule = ei.getNextGrammar();
        } else {
            ei = currentGrammar.getStartElementNSProduction(uri);
            if (ei != null) {
                assert (ei.getEvent().isEventType(EventType.START_ELEMENT_NS));
                this.encode1stLevelEventCode(ei.getEventCode());
                StartElementNS seNS = (StartElementNS)ei.getEvent();
                AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(seNS.getNamespaceUriID());
                QNameContext qnc = this.encodeLocalName(localName, uc, this.channel);
                if (this.preservePrefix) {
                    this.encodeQNamePrefix(qnc, prefix, this.channel);
                }
                updContextRule = ei.getNextGrammar();
                nextSE = this.getGlobalStartElement(qnc);
            } else {
                ei = currentGrammar.getProduction(EventType.START_ELEMENT_GENERIC);
                if (ei != null) {
                    assert (ei.getEvent().isEventType(EventType.START_ELEMENT_GENERIC));
                    this.encode1stLevelEventCode(ei.getEventCode());
                    updContextRule = ei.getNextGrammar();
                } else {
                    int ecSEundeclared = this.fidelityOptions.get2ndLevelEventCode(EventType.START_ELEMENT_GENERIC_UNDECLARED, currentGrammar);
                    if (ecSEundeclared == -1) {
                        throw new EXIException("Unexpected SE {" + uri + "}" + localName + ", " + this.exiFactory.toString());
                    }
                    switch (this.limitGrammars()) {
                        case XSI_TYPE: {
                            this.insertXsiTypeAnyType();
                            currentGrammar = this.getCurrentGrammar();
                            ei = currentGrammar.getProduction(EventType.START_ELEMENT_GENERIC);
                            assert (ei != null);
                            this.encode1stLevelEventCode(ei.getEventCode());
                            updContextRule = ei.getNextGrammar();
                            break;
                        }
                        default: {
                            this.encode2ndLevelEventCode(ecSEundeclared);
                            updContextRule = currentGrammar.getElementContentGrammar();
                        }
                    }
                }
                QNameContext qnc = this.encodeQName(uri, localName, this.channel);
                if (this.preservePrefix) {
                    this.encodeQNamePrefix(qnc, prefix, this.channel);
                }
                nextSE = this.getGlobalStartElement(qnc);
                currentGrammar.learnStartElement(nextSE);
                this.productionLearningCounting(currentGrammar);
            }
        }
        this.pushElement(updContextRule, nextSE);
        this.lastEvent = EventType.START_ELEMENT;
    }

    private final void productionLearningCounting(Grammar g) {
        if (this.limitGrammarLearning && this.maxBuiltInProductions >= 0 && !g.isSchemaInformed() && g.getGrammarType() != GrammarType.BUILT_IN_FRAGMENT_CONTENT) {
            ++this.learnedProductions;
        }
    }

    private final ProfileDisablingMechanism limitGrammars() throws EXIException, IOException {
        ProfileDisablingMechanism retVal = ProfileDisablingMechanism.NONE;
        Grammar currGrammar = this.getCurrentGrammar();
        if (this.limitGrammarLearning && this.grammar.isSchemaInformed() && !currGrammar.isSchemaInformed()) {
            int csize;
            if (this.maxBuiltInElementGrammars != -1 && (csize = this.runtimeGlobalElements.size()) > this.maxBuiltInElementGrammars) {
                if (currGrammar.getNumberOfEvents() == 0) {
                    retVal = ProfileDisablingMechanism.XSI_TYPE;
                } else if (this.isBuiltInStartTagGrammarWithAtXsiTypeOnly(currGrammar)) {
                    retVal = ProfileDisablingMechanism.XSI_TYPE;
                }
            }
            if (this.maxBuiltInProductions != -1 && retVal == ProfileDisablingMechanism.NONE && this.learnedProductions >= this.maxBuiltInProductions) {
                if (this.lastEvent == EventType.START_ELEMENT || this.lastEvent == EventType.NAMESPACE_DECLARATION) {
                    retVal = ProfileDisablingMechanism.XSI_TYPE;
                } else {
                    retVal = ProfileDisablingMechanism.GHOST_PRODUCTION;
                    currGrammar.stopLearning();
                }
            }
        }
        return retVal;
    }

    private final void insertXsiTypeAnyType() throws EXIException, IOException {
        String pfx = null;
        if (this.preservePrefix && (pfx = this.getPrefix("http://www.w3.org/2001/XMLSchema")) == null) {
            pfx = "xsdP";
            this.encodeNamespaceDeclaration("http://www.w3.org/2001/XMLSchema", pfx);
        }
        QNameValue type = new QNameValue("http://www.w3.org/2001/XMLSchema", "anyType", pfx);
        this.encodeAttributeXsiType(type, pfx, true);
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException, IOException {
        this.declarePrefix(prefix, uri);
        if (this.preservePrefix) {
            assert (this.sePrefix != null);
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.NAMESPACE_DECLARATION, currentGrammar);
            assert (this.fidelityOptions.get2ndLevelEventType(ec2, currentGrammar) == EventType.NAMESPACE_DECLARATION);
            this.encode2ndLevelEventCode(ec2);
            AbstractEXIBodyCoder.RuntimeUriContext euc = this.encodeUri(uri, this.channel);
            this.encodeNamespacePrefix(euc, prefix, this.channel);
            this.channel.encodeBoolean(prefix.equals(this.sePrefix));
            this.lastEvent = EventType.NAMESPACE_DECLARATION;
        }
    }

    public void encodeEndElement() throws EXIException, IOException {
        this.checkPendingCharacters(EventType.END_ELEMENT);
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getProduction(EventType.END_ELEMENT);
        if (ei != null) {
            this.encode1stLevelEventCode(ei.getEventCode());
        } else {
            int ecEEundeclared = this.fidelityOptions.get2ndLevelEventCode(EventType.END_ELEMENT_UNDECLARED, currentGrammar);
            if (ecEEundeclared == -1) {
                try {
                    this.encodeCharactersForce(StringCoder.EMPTY_STRING_VALUE);
                    currentGrammar = this.getCurrentGrammar();
                    ei = currentGrammar.getProduction(EventType.END_ELEMENT);
                    this.encode1stLevelEventCode(ei.getEventCode());
                }
                catch (Exception e) {
                    throw new EXIException("Unexpected EE {" + this.getElementContext() + ", " + this.exiFactory.toString());
                }
            } else {
                switch (this.limitGrammars()) {
                    case XSI_TYPE: {
                        this.insertXsiTypeAnyType();
                        currentGrammar = this.getCurrentGrammar();
                        ei = currentGrammar.getProduction(EventType.END_ELEMENT);
                        assert (ei != null);
                        this.encode1stLevelEventCode(ei.getEventCode());
                        break;
                    }
                    default: {
                        this.encode2ndLevelEventCode(ecEEundeclared);
                        currentGrammar.learnEndElement();
                        this.productionLearningCounting(currentGrammar);
                    }
                }
            }
        }
        AbstractEXIBodyCoder.ElementContext ec = this.popElement();
        if (ec.isXmlSpacePreserve() != null) {
            boolean isOtherPreserve = false;
            for (int i = this.elementContextStackIndex; i >= 0; --i) {
                Boolean isP = this.elementContextStack[i].isXmlSpacePreserve();
                if (isP == null) continue;
                isOtherPreserve = isP;
                break;
            }
            this.isXmlSpacePreserve = isOtherPreserve;
        }
        this.lastEvent = EventType.END_ELEMENT;
    }

    public void encodeAttributeList(AttributeList attributes) throws EXIException, IOException {
        int i;
        for (i = 0; i < attributes.getNumberOfNamespaceDeclarations(); ++i) {
            NamespaceDeclaration ns = attributes.getNamespaceDeclaration(i);
            this.encodeNamespaceDeclaration(ns.namespaceURI, ns.prefix);
        }
        if (attributes.hasXsiType()) {
            this.encodeAttributeXsiType(new StringValue(attributes.getXsiTypeRaw()), attributes.getXsiTypePrefix());
        }
        if (attributes.hasXsiNil()) {
            this.encodeAttributeXsiNil(new StringValue(attributes.getXsiNil()), attributes.getXsiNilPrefix());
        }
        for (i = 0; i < attributes.getNumberOfAttributes(); ++i) {
            this.encodeAttribute(attributes.getAttributeURI(i), attributes.getAttributeLocalName(i), attributes.getAttributePrefix(i), new StringValue(attributes.getAttributeValue(i)));
        }
    }

    public void encodeAttributeXsiType(Value type, String pfx) throws EXIException, IOException {
        boolean force2ndLevelProduction = false;
        if (this.limitGrammars() == ProfileDisablingMechanism.XSI_TYPE) {
            force2ndLevelProduction = true;
        }
        this.encodeAttributeXsiType(type, pfx, force2ndLevelProduction);
    }

    private void encodeAttributeXsiType(Value type, String pfx, boolean force2ndLevelProduction) throws EXIException, IOException {
        QNameContext qncType;
        String qnameLocalName;
        String qnamePrefix;
        String qnameURI;
        if (type instanceof QNameValue) {
            QNameValue qv = (QNameValue)type;
            qnameURI = qv.getNamespaceUri();
            qnamePrefix = qv.getPrefix();
            qnameLocalName = qv.getLocalName();
        } else {
            String sType = type.toString();
            qnamePrefix = QNameUtilities.getPrefixPart(sType);
            qnameURI = this.getURI(qnamePrefix);
            if (qnameURI == null) {
                qnameURI = "";
                qnameLocalName = sType;
            } else {
                qnameLocalName = QNameUtilities.getLocalPart(sType);
            }
        }
        Grammar currentGrammar = this.getCurrentGrammar();
        int ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_TYPE, currentGrammar);
        if (ec2 != -1) {
            assert (this.fidelityOptions.get2ndLevelEventType(ec2, currentGrammar) == EventType.ATTRIBUTE_XSI_TYPE);
            this.encode2ndLevelEventCode(ec2);
            if (this.preservePrefix) {
                this.encodeQNamePrefix(this.getXsiTypeContext(), pfx, this.channel);
            }
        } else {
            Production ei = force2ndLevelProduction ? null : currentGrammar.getAttributeProduction("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                QNameContext qncType2;
                if (!force2ndLevelProduction) {
                    ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC);
                }
                if (ei != null) {
                    this.encode1stLevelEventCode(ei.getEventCode());
                } else {
                    ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, currentGrammar);
                    if (ec2 != -1) {
                        this.encode2ndLevelEventCode(ec2);
                        qncType2 = this.getXsiTypeContext();
                        if (this.limitGrammarLearning) {
                            if (this.runtimeGlobalElements.size() > this.maxBuiltInElementGrammars && currentGrammar.getNumberOfEvents() == 0) {
                                currentGrammar.stopLearning();
                            } else {
                                this.productionLearningCounting(currentGrammar);
                            }
                        }
                        currentGrammar.learnAttribute(new Attribute(qncType2));
                    } else {
                        throw new EXIException("TypeCast " + type + " not encodable!");
                    }
                }
                qncType2 = this.getXsiTypeContext();
                this.encodeQName(qncType2.getNamespaceUri(), qncType2.getLocalName(), this.channel);
                if (this.preservePrefix) {
                    this.encodeQNamePrefix(qncType2, pfx, this.channel);
                }
            }
        }
        if (this.preserveLexicalValues) {
            if (qnamePrefix.length() > 0 && !this.preservePrefix) {
                throw new EXIException("[EXI] xsi:type='" + type + "' not encodable. Preserve lexicalValues requires prefixes preserved as well!");
            }
            this.typeEncoder.isValid(BuiltIn.DEFAULT_DATATYPE, type);
            this.typeEncoder.writeValue(this.getXsiTypeContext(), this.channel, this.stringEncoder);
            AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(qnameURI);
            qncType = uc != null ? uc.getQNameContext(qnameLocalName) : null;
        } else {
            qncType = this.encodeQName(qnameURI, qnameLocalName, this.channel);
            if (this.preservePrefix) {
                this.encodeQNamePrefix(qncType, qnamePrefix, this.channel);
            }
        }
        if (qncType != null && qncType.getTypeGrammar() != null) {
            this.updateCurrentRule(qncType.getTypeGrammar());
        }
        this.lastEvent = EventType.ATTRIBUTE_XSI_TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeAttributeXsiNil(Value nil, String pfx) throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        if (currentGrammar.isSchemaInformed()) {
            SchemaInformedGrammar siCurrentRule = (SchemaInformedGrammar)currentGrammar;
            if (this.booleanDatatype.isValid(nil)) {
                if (!(this.preserveLexicalValues || this.booleanDatatype.getBoolean() || this.encodingOptions.isOptionEnabled("INCLUDE_INSIGNIFICANT_XSI_NIL"))) {
                    return;
                }
                int ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_NIL, siCurrentRule);
                if (ec2 != -1) {
                    this.encode2ndLevelEventCode(ec2);
                    if (this.preservePrefix) {
                        this.encodeQNamePrefix(this.getXsiNilContext(), pfx, this.channel);
                    }
                    if (this.preserveLexicalValues) {
                        this.typeEncoder.isValid(this.booleanDatatype, nil);
                        this.typeEncoder.writeValue(this.getXsiTypeContext(), this.channel, this.stringEncoder);
                    } else {
                        this.booleanDatatype.writeValue(null, this.channel, this.stringEncoder);
                    }
                    if (this.booleanDatatype.getBoolean()) {
                        this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)siCurrentRule).getTypeEmpty());
                    }
                } else {
                    Production ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC);
                    if (ei == null) throw new EXIException("Attribute xsi=nil='" + nil + "' cannot be encoded!");
                    this.encode1stLevelEventCode(ei.getEventCode());
                    AbstractEXIBodyCoder.RuntimeUriContext euc = this.encodeUri("http://www.w3.org/2001/XMLSchema-instance", this.channel);
                    this.encodeLocalName("nil", euc, this.channel);
                    if (this.preservePrefix) {
                        this.encodeQNamePrefix(this.getXsiNilContext(), pfx, this.channel);
                    }
                    if (this.preserveLexicalValues) {
                        this.typeEncoder.isValid(this.booleanDatatype, nil);
                        this.typeEncoder.writeValue(this.getXsiNilContext(), this.channel, this.stringEncoder);
                    } else {
                        this.booleanDatatype.writeValue(null, this.channel, this.stringEncoder);
                    }
                    if (this.booleanDatatype.getBoolean()) {
                        this.updateCurrentRule(((SchemaInformedFirstStartTagGrammar)siCurrentRule).getTypeEmpty());
                    }
                }
            } else {
                SchemaInformedGrammar sig = (SchemaInformedGrammar)currentGrammar;
                this.encodeSchemaInvalidAttributeEventCode(sig.getNumberOfDeclaredAttributes());
                AbstractEXIBodyCoder.RuntimeUriContext euc = this.encodeUri("http://www.w3.org/2001/XMLSchema-instance", this.channel);
                this.encodeLocalName("nil", euc, this.channel);
                if (this.preservePrefix) {
                    this.encodeQNamePrefix(this.getXsiNilContext(), pfx, this.channel);
                }
                Datatype datatype = BuiltIn.DEFAULT_DATATYPE;
                this.isTypeValid(datatype, nil);
                this.writeValue(this.getXsiTypeContext());
            }
        } else {
            this.encodeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", pfx, nil);
        }
        this.lastEvent = EventType.ATTRIBUTE_XSI_NIL;
    }

    protected void encodeSchemaInvalidAttributeEventCode(int eventCode3) throws IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        int ec2ATdeviated = this.fidelityOptions.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, currentGrammar);
        this.encode2ndLevelEventCode(ec2ATdeviated);
        SchemaInformedGrammar sig = (SchemaInformedGrammar)currentGrammar;
        this.channel.encodeNBitUnsignedInteger(eventCode3, MethodsBag.getCodingLength(sig.getNumberOfDeclaredAttributes() + 1));
    }

    public void encodeAttribute(QName at, Value value) throws EXIException, IOException {
        this.encodeAttribute(at.getNamespaceURI(), at.getLocalPart(), at.getPrefix(), value);
    }

    public void encodeAttribute(String uri, String localName, String prefix, Value value) throws EXIException, IOException {
        Grammar next;
        QNameContext qnc;
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getAttributeProduction(uri, localName);
        if (ei != null) {
            Attribute at = (Attribute)ei.getEvent();
            qnc = at.getQNameContext();
            if (this.isTypeValid(at.getDatatype(), value)) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                SchemaInformedGrammar sig = (SchemaInformedGrammar)currentGrammar;
                int eventCode3 = ei.getEventCode() - sig.getLeastAttributeEventCode();
                this.encodeSchemaInvalidAttributeEventCode(eventCode3);
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
            }
            next = ei.getNextGrammar();
        } else {
            Attribute globalAT;
            switch (this.limitGrammars()) {
                case XSI_TYPE: {
                    this.insertXsiTypeAnyType();
                    currentGrammar = this.getCurrentGrammar();
                    break;
                }
            }
            ei = currentGrammar.getAttributeNSProduction(uri);
            if (ei != null || (ei = currentGrammar.getProduction(EventType.ATTRIBUTE_GENERIC)) == null) {
                // empty if block
            }
            if (currentGrammar.isSchemaInformed() && (globalAT = this.getGlobalAttribute(uri, localName)) != null) {
                if (this.isTypeValid(globalAT.getDatatype(), value)) {
                    if (ei == null) {
                        this.encodeAttributeEventCodeUndeclared(currentGrammar, localName);
                    } else {
                        this.encode1stLevelEventCode(ei.getEventCode());
                    }
                } else {
                    SchemaInformedGrammar sig = (SchemaInformedGrammar)currentGrammar;
                    this.encodeSchemaInvalidAttributeEventCode(sig.getNumberOfDeclaredAttributes());
                    this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
                }
                if (ei == null || ei.getEvent().isEventType(EventType.ATTRIBUTE_GENERIC)) {
                    qnc = this.encodeQName(uri, localName, this.channel);
                    next = ei == null ? currentGrammar : ei.getNextGrammar();
                } else {
                    AttributeNS atNS = (AttributeNS)ei.getEvent();
                    AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(atNS.getNamespaceUriID());
                    qnc = this.encodeLocalName(localName, uc, this.channel);
                    next = ei.getNextGrammar();
                }
            } else {
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, value);
                if (ei == null) {
                    qnc = this.encodeUndeclaredAT(currentGrammar, uri, localName);
                    next = currentGrammar;
                } else {
                    qnc = this.encodeDeclaredAT(ei, uri, localName);
                    next = ei.getNextGrammar();
                }
            }
        }
        assert (qnc != null);
        if (this.preservePrefix) {
            this.encodeQNamePrefix(qnc, prefix, this.channel);
        }
        this.writeValue(qnc);
        assert (next != null);
        this.updateCurrentRule(next);
        if (value.getValueType() == ValueType.STRING && "http://www.w3.org/XML/1998/namespace".equals(uri)) {
            AbstractEXIBodyCoder.ElementContext ec = this.getElementContext();
            if ("preserve".equals(value.toString())) {
                this.isXmlSpacePreserve = true;
                ec.setXmlSpacePreserve(Boolean.TRUE);
            } else if ("default".equals(value.toString())) {
                this.isXmlSpacePreserve = false;
                ec.setXmlSpacePreserve(Boolean.FALSE);
            }
        }
        this.lastEvent = EventType.ATTRIBUTE;
    }

    private void encodeAttributeEventCodeUndeclared(Grammar currentGrammar, String localName) throws IOException, EXIException {
        int ecATundeclared = this.fidelityOptions.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, currentGrammar);
        if (ecATundeclared == -1) {
            assert (this.fidelityOptions.isStrict());
            throw new EXIException("Attribute '" + localName + "' cannot be encoded!");
        }
        assert (ecATundeclared != -1);
        this.encode2ndLevelEventCode(ecATundeclared);
    }

    private QNameContext encodeDeclaredAT(Production ei, String uri, String localName) throws IOException {
        QNameContext qnc;
        this.encode1stLevelEventCode(ei.getEventCode());
        if (ei.getEvent().isEventType(EventType.ATTRIBUTE_NS)) {
            AttributeNS atNS = (AttributeNS)ei.getEvent();
            AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(atNS.getNamespaceUriID());
            qnc = this.encodeLocalName(localName, uc, this.channel);
        } else {
            qnc = this.encodeQName(uri, localName, this.channel);
        }
        return qnc;
    }

    private QNameContext encodeUndeclaredAT(Grammar currentGrammar, String uri, String localName) throws EXIException, IOException {
        this.encodeAttributeEventCodeUndeclared(currentGrammar, localName);
        QNameContext qnc = this.encodeQName(uri, localName, this.channel);
        currentGrammar.learnAttribute(new Attribute(qnc));
        this.productionLearningCounting(currentGrammar);
        return qnc;
    }

    protected Attribute getGlobalAttribute(String uri, String localName) {
        AbstractEXIBodyCoder.RuntimeUriContext uc = this.getUri(uri);
        if (uc != null) {
            return this.getGlobalAttribute(uc, localName);
        }
        return null;
    }

    protected Attribute getGlobalAttribute(AbstractEXIBodyCoder.RuntimeUriContext uc, String localName) {
        assert (uc != null);
        QNameContext qnc = uc.getQNameContext(localName);
        if (qnc != null) {
            return qnc.getGlobalAttribute();
        }
        return null;
    }

    private WhiteSpace getDatatypeWhiteSpace() {
        Production prod;
        Grammar currGr = this.getCurrentGrammar();
        if (currGr.isSchemaInformed() && currGr.getNumberOfEvents() > 0 && (prod = currGr.getProduction(0)).getEvent().getEventType() == EventType.CHARACTERS) {
            Characters ch = (Characters)prod.getEvent();
            return ch.getDatatype().getWhiteSpace();
        }
        return null;
    }

    static void replace(char[] chars, int len) {
        for (int i = 0; i < len; ++i) {
            if (chars[i] != '\t' && chars[i] != '\n' && chars[i] != '\r') continue;
            chars[i] = 32;
        }
    }

    static void shiftLeft(char[] chars, int pos, int len) {
        System.arraycopy(chars, pos + 1, chars, pos, len - 1);
    }

    static int collapse(char[] chars, int len) {
        AbstractEXIBodyEncoder.replace(chars, len);
        int newLen = len;
        if (newLen > 1) {
            int i = 0;
            while (i < newLen - 1) {
                char thisChar = chars[i];
                char nextChar = chars[i + 1];
                if (thisChar == ' ' && nextChar == ' ') {
                    AbstractEXIBodyEncoder.shiftLeft(chars, i, newLen - i);
                    --newLen;
                    continue;
                }
                ++i;
            }
        }
        newLen = AbstractEXIBodyEncoder.trimSpaces(chars, newLen);
        return newLen;
    }

    static int trimSpaces(char[] chars, int len) {
        int newLen;
        for (newLen = len; newLen > 0 && chars[0] == ' '; --newLen) {
            AbstractEXIBodyEncoder.shiftLeft(chars, 0, newLen);
        }
        for (int i = newLen - 1; i >= 0 && chars[i] == ' '; --i) {
            --newLen;
        }
        return newLen;
    }

    static boolean isWS(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    static boolean isSolelyWS(char[] chars, int len) {
        for (int i = 0; i < len; ++i) {
            if (AbstractEXIBodyEncoder.isWS(chars[i])) continue;
            return false;
        }
        return true;
    }

    static int trimWS(char[] chars, int len) {
        int newLen;
        for (newLen = len; newLen > 0 && AbstractEXIBodyEncoder.isWS(chars[0]); --newLen) {
            AbstractEXIBodyEncoder.shiftLeft(chars, 0, newLen);
        }
        for (int i = newLen - 1; i >= 0 && AbstractEXIBodyEncoder.isWS(chars[i]); --i) {
            --newLen;
        }
        return newLen;
    }

    private int modeValuesToCBuffer() {
        int len = 0;
        for (int i = 0; i < this.bChars.size(); ++i) {
            len += this.bChars.get(i).getCharactersLength();
        }
        if (this.cbuffer == null || this.cbuffer.length < len) {
            this.cbuffer = new char[len];
        }
        int pos = 0;
        for (int i = 0; i < this.bChars.size(); ++i) {
            Value v = this.bChars.get(i);
            v.getCharacters(this.cbuffer, pos);
            pos += v.getCharactersLength();
        }
        assert (len == pos);
        return len;
    }

    protected void checkPendingCharacters(EventType nextEvent) throws EXIException, IOException {
        int numberOfValues = this.bChars.size();
        if (numberOfValues > 0) {
            if (numberOfValues == 1 && this.bChars.get(0).getValueType() != ValueType.STRING) {
                this.encodeCharactersForce(this.bChars.get(0));
            } else {
                WhiteSpace ws = this.getDatatypeWhiteSpace();
                if (!this.preserveLexicalValues && !this.isXmlSpacePreserve && ws != WhiteSpace.preserve) {
                    int len = this.modeValuesToCBuffer();
                    if (ws == WhiteSpace.replace) {
                        AbstractEXIBodyEncoder.replace(this.cbuffer, len);
                    } else if (ws == WhiteSpace.collapse) {
                        AbstractEXIBodyEncoder.replace(this.cbuffer, len);
                        len = AbstractEXIBodyEncoder.collapse(this.cbuffer, len);
                    } else if ((this.lastEvent != EventType.START_ELEMENT && this.lastEvent != EventType.ATTRIBUTE && this.lastEvent != EventType.ATTRIBUTE_XSI_NIL && this.lastEvent != EventType.ATTRIBUTE_XSI_TYPE && this.lastEvent != EventType.NAMESPACE_DECLARATION || nextEvent != EventType.END_ELEMENT && nextEvent != EventType.COMMENT && nextEvent != EventType.PROCESSING_INSTRUCTION && nextEvent != EventType.DOC_TYPE) && AbstractEXIBodyEncoder.isSolelyWS(this.cbuffer, len)) {
                        len = 0;
                    }
                    if (len != 0) {
                        StringValue sv = new StringValue(new String(this.cbuffer, 0, len));
                        this.encodeCharactersForce(sv);
                    }
                } else if (numberOfValues == 1) {
                    this.encodeCharactersForce(this.bChars.get(0));
                } else {
                    int len = this.modeValuesToCBuffer();
                    StringValue sv = new StringValue(new String(this.cbuffer, 0, len));
                    this.encodeCharactersForce(sv);
                }
            }
            this.bChars.clear();
        }
    }

    public void encodeCharacters(Value chars) throws EXIException, IOException {
        this.bChars.add(chars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encodeCharactersForce(Value chars) throws EXIException, IOException {
        Grammar currentGrammar = this.getCurrentGrammar();
        Production ei = currentGrammar.getProduction(EventType.CHARACTERS);
        if (ei != null && this.isTypeValid(((DatatypeEvent)ei.getEvent()).getDatatype(), chars)) {
            this.encode1stLevelEventCode(ei.getEventCode());
            this.writeValue(this.getElementContext().qnameContext);
            this.updateCurrentRule(ei.getNextGrammar());
            return;
        } else {
            ei = currentGrammar.getProduction(EventType.CHARACTERS_GENERIC);
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
                this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, chars);
                this.writeValue(this.getElementContext().qnameContext);
                this.updateCurrentRule(ei.getNextGrammar());
                return;
            } else {
                int ecCHundeclared = this.fidelityOptions.get2ndLevelEventCode(EventType.CHARACTERS_GENERIC_UNDECLARED, currentGrammar);
                if (ecCHundeclared == -1) {
                    if (this.exiFactory.isFragment()) {
                        this.throwWarning("Skip CH: '" + chars + "'");
                        return;
                    } else {
                        if (this.isXmlSpacePreserve || !this.fidelityOptions.isStrict() || chars.toString().trim().length() != 0) throw new EXIException("Characters '" + chars + "' cannot be encoded!");
                        this.throwWarning("Skip CH: '" + chars + "'");
                    }
                    return;
                } else {
                    Grammar updContextRule;
                    switch (this.limitGrammars()) {
                        case XSI_TYPE: {
                            this.insertXsiTypeAnyType();
                            currentGrammar = this.getCurrentGrammar();
                            ei = currentGrammar.getProduction(EventType.CHARACTERS_GENERIC);
                            assert (ei != null);
                            this.encode1stLevelEventCode(ei.getEventCode());
                            updContextRule = ei.getNextGrammar();
                            break;
                        }
                        default: {
                            this.encode2ndLevelEventCode(ecCHundeclared);
                            currentGrammar.learnCharacters();
                            this.productionLearningCounting(currentGrammar);
                            updContextRule = currentGrammar.getElementContentGrammar();
                        }
                    }
                    this.isTypeValid(BuiltIn.DEFAULT_DATATYPE, chars);
                    this.writeValue(this.getElementContext().qnameContext);
                    this.updateCurrentRule(updContextRule);
                }
            }
        }
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            this.checkPendingCharacters(EventType.DOC_TYPE);
            int ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.DOC_TYPE, this.getCurrentGrammar());
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
            this.writeString(publicID);
            this.writeString(systemID);
            this.writeString(text);
        }
    }

    private final void doLimitGrammarLearningForErCmPi() throws EXIException, IOException {
        switch (this.limitGrammars()) {
            case XSI_TYPE: {
                this.insertXsiTypeAnyType();
                break;
            }
        }
    }

    public void encodeEntityReference(String name) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            this.checkPendingCharacters(EventType.ENTITY_REFERENCE);
            this.doLimitGrammarLearningForErCmPi();
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec2 = this.fidelityOptions.get2ndLevelEventCode(EventType.ENTITY_REFERENCE, currentGrammar);
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
            this.checkPendingCharacters(EventType.COMMENT);
            this.doLimitGrammarLearningForErCmPi();
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec3 = this.fidelityOptions.get3rdLevelEventCode(EventType.COMMENT);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(new String(ch, start, length));
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
            this.checkPendingCharacters(EventType.PROCESSING_INSTRUCTION);
            this.doLimitGrammarLearningForErCmPi();
            Grammar currentGrammar = this.getCurrentGrammar();
            int ec3 = this.fidelityOptions.get3rdLevelEventCode(EventType.PROCESSING_INSTRUCTION);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(target);
            this.writeString(data);
            this.updateCurrentRule(currentGrammar.getElementContentGrammar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfileDisablingMechanism {
        NONE,
        XSI_TYPE,
        GHOST_PRODUCTION;

    }
}

