/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LinePositionComparator;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.pobjects.graphics.text.WordPositionComparator;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageText
implements TextSelect {
    private static boolean checkForDuplicates = Defs.booleanProperty("org.icepdf.core.views.page.text.trim.duplicates", false);
    private static boolean preserveColumns = Defs.booleanProperty("org.icepdf.core.views.page.text.preserveColumns", true);
    private LineText currentLine;
    private ArrayList<LineText> pageLines = new ArrayList(64);
    private ArrayList<LineText> sortedPageLines;
    private AffineTransform previousTextTransform;
    private LinkedHashMap<OptionalContents, PageText> optionalPageLines;

    public void newLine(LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            OptionalContents optionalContent;
            PageText pageText;
            if (this.optionalPageLines == null) {
                this.optionalPageLines = new LinkedHashMap(10);
            }
            if ((pageText = this.optionalPageLines.get(optionalContent = oCGs.peek())) == null) {
                pageText = new PageText();
                pageText.newLine();
                this.optionalPageLines.put(optionalContent, pageText);
            } else {
                pageText.newLine();
            }
        }
    }

    public void newLine() {
        if (this.currentLine != null && this.currentLine.getWords().size() == 0) {
            return;
        }
        this.currentLine = new LineText();
        this.pageLines.add(this.currentLine);
    }

    protected void addGlyph(GlyphText sprite) {
        if (this.currentLine == null) {
            this.newLine();
        }
        this.currentLine.addText(sprite);
    }

    public ArrayList<LineText> getPageLines() {
        if (this.sortedPageLines == null) {
            this.sortAndFormatText();
        }
        return this.sortedPageLines;
    }

    private ArrayList<LineText> getVisiblePageLines(boolean skip) {
        ArrayList<LineText> visiblePageLines;
        ArrayList<LineText> arrayList = visiblePageLines = skip ? new ArrayList<LineText>() : new ArrayList<LineText>(this.pageLines);
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> pageLines = this.optionalPageLines.get(key).getVisiblePageLines(false);
                LineText currentLine = new LineText();
                visiblePageLines.add(currentLine);
                for (LineText lineText : pageLines) {
                    currentLine.addAll(lineText.getWords());
                    currentLine.getBounds();
                }
            }
        }
        return visiblePageLines;
    }

    private ArrayList<LineText> getAllPageLines() {
        ArrayList<LineText> visiblePageLines = new ArrayList<LineText>(this.pageLines);
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            LineText currentLine = new LineText();
            visiblePageLines.add(currentLine);
            for (OptionalContents key : keys) {
                if (key == null) continue;
                ArrayList<LineText> pageLines = this.optionalPageLines.get(key).getVisiblePageLines(true);
                for (LineText lineText : pageLines) {
                    currentLine.addAll(lineText.getWords());
                }
            }
            currentLine.getBounds();
        }
        return visiblePageLines;
    }

    public void addPageLines(ArrayList<LineText> pageLines) {
        if (pageLines != null) {
            this.pageLines.addAll(pageLines);
        }
    }

    public void setTextTransform(AffineTransform affineTransform) {
        if (this.previousTextTransform != null && this.currentLine != null && (this.previousTextTransform.getShearX() < 0.0 && (int)affineTransform.getShearX() > 0 || this.previousTextTransform.getShearX() > 0.0 && (int)affineTransform.getShearX() < 0 || this.previousTextTransform.getShearY() < 0.0 && (int)affineTransform.getShearY() > 0 || this.previousTextTransform.getShearY() > 0.0 && (int)affineTransform.getShearY() < 0)) {
            this.currentLine.clearCurrentWord();
        }
        this.previousTextTransform = affineTransform;
    }

    public void addGlyph(GlyphText glyphText, LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            if (oCGs.peek() != null) {
                this.addOptionalPageLines(oCGs.peek(), glyphText);
            }
        } else {
            this.addGlyph(glyphText);
        }
    }

    protected void addOptionalPageLines(OptionalContents optionalContent, GlyphText sprite) {
        PageText pageText;
        if (this.optionalPageLines == null) {
            this.optionalPageLines = new LinkedHashMap(10);
        }
        if ((pageText = this.optionalPageLines.get(optionalContent)) == null) {
            pageText = new PageText();
            pageText.addGlyph(sprite);
            this.optionalPageLines.put(optionalContent, pageText);
        } else {
            pageText.addGlyph(sprite);
        }
    }

    public void applyXObjectTransform(AffineTransform transform) {
        for (LineText lineText : this.pageLines) {
            lineText.clearBounds();
            for (WordText wordText : lineText.getWords()) {
                wordText.clearBounds();
                for (GlyphText glyph : wordText.getGlyphs()) {
                    glyph.normalizeToUserSpace(transform, null);
                }
            }
        }
    }

    @Override
    public void clearSelected() {
        if (this.pageLines != null) {
            for (LineText lineText : this.pageLines) {
                lineText.clearSelected();
            }
        }
        if (this.sortedPageLines != null) {
            for (LineText lineText : this.sortedPageLines) {
                lineText.clearSelected();
            }
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                ArrayList<LineText> optionalLines;
                if (key == null || (optionalLines = this.optionalPageLines.get(key).getAllPageLines()) == null) continue;
                for (LineText lineText : optionalLines) {
                    lineText.clearSelected();
                }
            }
        }
    }

    @Override
    public void clearHighlighted() {
        for (LineText lineText : this.pageLines) {
            lineText.clearHighlighted();
        }
        for (LineText lineText : this.sortedPageLines) {
            lineText.clearHighlighted();
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getAllPageLines();
                for (LineText lineText : optionalLines) {
                    lineText.clearHighlighted();
                }
            }
        }
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        ArrayList<LineText> pageLines = this.getPageLines();
        if (pageLines != null) {
            for (LineText lineText : pageLines) {
                StringBuilder selectedLineText = lineText.getSelected();
                if (selectedLineText == null || selectedLineText.length() <= 0) continue;
                selectedText.append((CharSequence)selectedLineText);
                selectedText.append("\n");
            }
        }
        return selectedText;
    }

    @Override
    public void selectAll() {
        ArrayList<LineText> pageLines = this.getPageLines();
        if (pageLines != null) {
            for (LineText lineText : pageLines) {
                lineText.selectAll();
            }
        }
    }

    public void deselectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
    }

    public String toString() {
        StringBuilder extractedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            for (WordText wordText : lineText.getWords()) {
                extractedText.append(wordText.getText());
            }
            extractedText.append('\n');
        }
        return extractedText.toString();
    }

    private ArrayList<LineText> sortLinesVertically(ArrayList<LineText> pageLines) {
        ArrayList<LineText> sortedPageLines = new ArrayList<LineText>(64);
        for (LineText pageLine : pageLines) {
            List<WordText> words = pageLine.getWords();
            if (words == null || words.size() <= 0) continue;
            double lastY = Math.round(words.get((int)0).getTextExtractionBounds().y);
            int start = 0;
            int end = 0;
            for (WordText word : words) {
                double currentY = Math.round(word.getTextExtractionBounds().getY());
                double diff = Math.abs(currentY - lastY);
                if (diff != 0.0 && diff > word.getTextExtractionBounds().getHeight() / 2.0) {
                    LineText lineText = new LineText();
                    lineText.addAll(words.subList(start, end));
                    sortedPageLines.add(lineText);
                    start = end;
                }
                ++end;
                lastY = currentY;
            }
            if (start >= end) continue;
            LineText lineText = new LineText();
            lineText.addAll(words.subList(start, end));
            sortedPageLines.add(lineText);
        }
        return sortedPageLines;
    }

    private void insertOptionalLines(ArrayList<LineText> sortedPageLines) {
        ArrayList<LineText> optionalPageLines = this.getVisiblePageLines(true);
        if (optionalPageLines != null) {
            for (LineText optionalPageLine : optionalPageLines) {
                float yOptional = optionalPageLine.getBounds().y;
                boolean found = false;
                for (LineText sortedPageLine : sortedPageLines) {
                    Rectangle sortedBounds = sortedPageLine.getBounds().getBounds();
                    float height = sortedBounds.height;
                    float y = sortedBounds.y;
                    float diff = Math.abs(yOptional - y);
                    if (!(diff < height)) continue;
                    sortedPageLine.addAll(optionalPageLine.getWords());
                    found = true;
                    break;
                }
                if (found) continue;
                sortedPageLines.add(optionalPageLine);
            }
        }
    }

    public void sortAndFormatText() {
        ArrayList<LineText> visiblePageLines = new ArrayList<LineText>(this.pageLines);
        ArrayList<LineText> sortedPageLines = this.sortLinesVertically(visiblePageLines);
        if (sortedPageLines.size() == 0) {
            sortedPageLines = this.getVisiblePageLines(true);
        } else {
            this.insertOptionalLines(sortedPageLines);
        }
        sortedPageLines = this.sortLinesVertically(sortedPageLines);
        if (checkForDuplicates) {
            for (LineText lineText : sortedPageLines) {
                List<WordText> words = lineText.getWords();
                if (words.size() <= 0) continue;
                ArrayList<WordText> trimmedWords = new ArrayList<WordText>();
                HashSet<String> refs = new HashSet<String>();
                for (WordText wordText : words) {
                    String key = wordText.getText() + wordText.getBounds().getBounds();
                    if (!refs.add(key)) continue;
                    trimmedWords.add(wordText);
                }
                lineText.setWords(trimmedWords);
            }
        }
        if (sortedPageLines.size() > 0) {
            for (LineText lineText : sortedPageLines) {
                Collections.sort(lineText.getWords(), new WordPositionComparator());
            }
        }
        if (sortedPageLines.size() > 0) {
            for (LineText lineText : sortedPageLines) {
                lineText.getBounds();
            }
        }
        if (sortedPageLines.size() > 0 && !preserveColumns) {
            Collections.sort(sortedPageLines, new LinePositionComparator());
        }
        this.sortedPageLines = sortedPageLines;
    }
}

