/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.util.Library;

public class LineAnnotation
extends MarkupAnnotation {
    private static final Logger logger = Logger.getLogger(LineAnnotation.class.toString());
    public static final Name L_KEY = new Name("L");
    public static final Name LE_KEY = new Name("LE");
    public static final Name LL_KEY = new Name("LL");
    public static final Name LLE_KEY = new Name("LLE");
    public static final Name IC_KEY = new Name("IC");
    public static final Name CAP_KEY = new Name("Cap");
    public static final Name LLO_KEY = new Name("LLO");
    public static final Name CP_KEY = new Name("CP");
    public static final Name MEASURE_KEY = new Name("Measure");
    public static final Name CO_KEY = new Name("CO");
    public static final Name LINE_END_NONE = new Name("None");
    public static final Name LINE_END_SQUARE = new Name("Square");
    public static final Name LINE_END_CIRCLE = new Name("Circle");
    public static final Name LINE_END_DIAMOND = new Name("Diamond");
    public static final Name LINE_END_OPEN_ARROW = new Name("OpenArrow");
    public static final Name LINE_END_CLOSED_ARROW = new Name("ClosedArrow");
    protected Point2D startOfLine;
    protected Point2D endOfLine;
    protected Color interiorColor;
    protected Name startArrow = LINE_END_NONE;
    protected Name endArrow = LINE_END_NONE;

    public LineAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    public static LineAnnotation getInstance(Library library, Rectangle rect) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, Annotation.SUBTYPE_LINE);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        LineAnnotation lineAnnotation = null;
        try {
            lineAnnotation = new LineAnnotation(library, entries);
            lineAnnotation.init();
            lineAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
            lineAnnotation.setNew(true);
        }
        catch (InterruptedException e) {
            logger.fine("Line annotation instance creation was interrupted");
        }
        return lineAnnotation;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void drawLineStart(Graphics2D g, Name lineEnding, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        if (lineEnding.equals(LINE_END_OPEN_ARROW)) {
            LineAnnotation.drawOpenArrowStart(g, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_CLOSED_ARROW)) {
            LineAnnotation.drawClosedArrowStart(g, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_CIRCLE)) {
            LineAnnotation.drawCircle(g, startOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_DIAMOND)) {
            LineAnnotation.drawDiamond(g, startOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_SQUARE)) {
            LineAnnotation.drawSquare(g, startOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        }
    }

    public static void drawLineEnd(Graphics2D g, Name lineEnding, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        if (lineEnding.equals(LINE_END_OPEN_ARROW)) {
            LineAnnotation.drawOpenArrowEnd(g, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_CLOSED_ARROW)) {
            LineAnnotation.drawClosedArrowEnd(g, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_CIRCLE)) {
            LineAnnotation.drawCircle(g, endOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_DIAMOND)) {
            LineAnnotation.drawDiamond(g, endOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        } else if (lineEnding.equals(LINE_END_SQUARE)) {
            LineAnnotation.drawSquare(g, endOfLine, startOfLine, endOfLine, lineColor, interiorColor);
        }
    }

    public static void circleDrawOps(Shapes shapes, Point2D point, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(point, start, end);
        shapes.add(new TransformDrawCmd(af));
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createCircleEnd()));
        shapes.add(new FillDrawCmd());
    }

    private static Shape createCircleEnd() {
        return new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    }

    private static void drawCircle(Graphics2D g, Point2D point, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(point, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        g.setColor(lineColor);
        g.fill(LineAnnotation.createCircleEnd());
        g.setTransform(oldAf);
    }

    public static void diamondDrawOps(Shapes shapes, Point2D point, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform tx = new AffineTransform();
        Line2D.Double line = new Line2D.Double(start, end);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(point.getX(), point.getY());
        tx.rotate(angle - 0.7853981633974483);
        AffineTransform af = LineAnnotation.createRotation(point, start, end);
        shapes.add(new TransformDrawCmd(af));
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createSquareEnd()));
        shapes.add(new FillDrawCmd());
    }

    private static void drawDiamond(Graphics2D g, Point2D point, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        AffineTransform oldAf = g.getTransform();
        AffineTransform tx = new AffineTransform();
        Line2D.Double line = new Line2D.Double(startOfLine, endOfLine);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(point.getX(), point.getY());
        tx.rotate(angle - 0.7853981633974483);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(tx);
        g.setTransform(gAf);
        g.setColor(lineColor);
        g.fill(LineAnnotation.createSquareEnd());
        g.setTransform(oldAf);
    }

    public static void squareDrawOps(Shapes shapes, Point2D point, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(point, start, end);
        shapes.add(new TransformDrawCmd(af));
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createSquareEnd()));
        shapes.add(new FillDrawCmd());
    }

    private static Shape createSquareEnd() {
        return new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
    }

    private static void drawSquare(Graphics2D g, Point2D point, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(point, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        g.setColor(lineColor);
        g.fill(LineAnnotation.createSquareEnd());
        g.setTransform(oldAf);
    }

    public static void openArrowEndDrawOps(Shapes shapes, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(end, start, end);
        shapes.add(new TransformDrawCmd(af));
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createOpenArrowEnd()));
        shapes.add(new DrawDrawCmd());
    }

    private static Shape createOpenArrowEnd() {
        GeneralPath arrowHead = new GeneralPath();
        arrowHead.moveTo(0.0f, 0.0f);
        arrowHead.lineTo(5.0f, -10.0f);
        arrowHead.moveTo(0.0f, 0.0f);
        arrowHead.lineTo(-5.0f, -10.0f);
        arrowHead.closePath();
        return arrowHead;
    }

    private static void drawOpenArrowEnd(Graphics2D g, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        Shape arrowHead = LineAnnotation.createOpenArrowEnd();
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(endOfLine, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        g.setColor(lineColor);
        g.draw(arrowHead);
        g.setTransform(oldAf);
    }

    public static void openArrowStartDrawOps(Shapes shapes, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(start, start, end);
        shapes.add(new TransformDrawCmd(af));
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createOpenArrowStart()));
        shapes.add(new DrawDrawCmd());
    }

    private static Shape createOpenArrowStart() {
        GeneralPath arrowHead = new GeneralPath();
        arrowHead.moveTo(0.0f, 0.0f);
        arrowHead.lineTo(5.0f, 10.0f);
        arrowHead.moveTo(0.0f, 0.0f);
        arrowHead.lineTo(-5.0f, 10.0f);
        arrowHead.closePath();
        return arrowHead;
    }

    private static void drawOpenArrowStart(Graphics2D g, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        Shape arrowHead = LineAnnotation.createOpenArrowStart();
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(startOfLine, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        g.setColor(lineColor);
        g.draw(arrowHead);
        g.setTransform(oldAf);
    }

    public static void closedArrowStartDrawOps(Shapes shapes, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(start, start, end);
        shapes.add(new TransformDrawCmd(af));
        if (internalColor != null) {
            shapes.add(new ColorDrawCmd(internalColor));
            shapes.add(new ShapeDrawCmd(LineAnnotation.createClosedArrowStart()));
            shapes.add(new FillDrawCmd());
        }
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createClosedArrowStart()));
        shapes.add(new DrawDrawCmd());
    }

    private static Shape createClosedArrowStart() {
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, -5);
        arrowHead.addPoint(-5, 5);
        arrowHead.addPoint(5, 5);
        return arrowHead;
    }

    private static void drawClosedArrowStart(Graphics2D g, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        Shape arrowHead = LineAnnotation.createClosedArrowStart();
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(startOfLine, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        if (interiorColor != null) {
            g.setColor(interiorColor);
            g.fill(arrowHead);
        }
        g.setColor(lineColor);
        g.draw(arrowHead);
        g.setTransform(oldAf);
    }

    public static void closedArrowEndDrawOps(Shapes shapes, Point2D start, Point2D end, Color lineColor, Color internalColor) {
        AffineTransform af = LineAnnotation.createRotation(end, start, end);
        shapes.add(new TransformDrawCmd(af));
        if (internalColor != null) {
            shapes.add(new ColorDrawCmd(internalColor));
            shapes.add(new ShapeDrawCmd(LineAnnotation.createClosedArrowEnd()));
            shapes.add(new FillDrawCmd());
        }
        shapes.add(new ColorDrawCmd(lineColor));
        shapes.add(new ShapeDrawCmd(LineAnnotation.createClosedArrowEnd()));
        shapes.add(new DrawDrawCmd());
    }

    private static Shape createClosedArrowEnd() {
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 5);
        arrowHead.addPoint(-5, -5);
        arrowHead.addPoint(5, -5);
        return arrowHead;
    }

    private static void drawClosedArrowEnd(Graphics2D g, Point2D startOfLine, Point2D endOfLine, Color lineColor, Color interiorColor) {
        Shape arrowHead = LineAnnotation.createClosedArrowEnd();
        AffineTransform oldAf = g.getTransform();
        AffineTransform af = LineAnnotation.createRotation(endOfLine, startOfLine, endOfLine);
        AffineTransform gAf = g.getTransform();
        gAf.concatenate(af);
        g.setTransform(gAf);
        if (interiorColor != null) {
            g.setColor(interiorColor);
            g.fill(arrowHead);
        }
        g.setColor(lineColor);
        g.draw(arrowHead);
        g.setTransform(oldAf);
    }

    private static AffineTransform createRotation(Point2D point, Point2D startOfLine, Point2D endOfLine) {
        AffineTransform tx = new AffineTransform();
        Line2D.Double line = new Line2D.Double(startOfLine, endOfLine);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(point.getX(), point.getY());
        tx.rotate(angle - 1.5707963267948966);
        return tx;
    }

    public void init() throws InterruptedException {
        List value2;
        super.init();
        List value = this.library.getArray(this.entries, L_KEY);
        if (value != null) {
            this.startOfLine = new Point2D.Float(((Number)value.get(0)).floatValue(), ((Number)value.get(1)).floatValue());
            this.endOfLine = new Point2D.Float(((Number)value.get(2)).floatValue(), ((Number)value.get(3)).floatValue());
        }
        if ((value2 = this.library.getArray(this.entries, LE_KEY)) != null) {
            this.startArrow = (Name)value2.get(0);
            this.endArrow = (Name)value2.get(1);
        }
        this.interiorColor = null;
        List C = (List)this.getObject(IC_KEY);
        if (C != null && C.size() >= 3) {
            float red = ((Number)C.get(0)).floatValue();
            float green = ((Number)C.get(1)).floatValue();
            float blue = ((Number)C.get(2)).floatValue();
            red = Math.max(0.0f, Math.min(1.0f, red));
            green = Math.max(0.0f, Math.min(1.0f, green));
            blue = Math.max(0.0f, Math.min(1.0f, blue));
            this.interiorColor = new Color(red, green, blue);
        }
        if (!this.hasAppearanceStream() && this.startOfLine != null && this.endOfLine != null) {
            Object tmp = this.getObject(RECTANGLE_KEY);
            RectangularShape rectangle = null;
            if (tmp instanceof List) {
                rectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
            }
            if (rectangle != null) {
                this.setBBox(rectangle.getBounds());
            }
            this.resetAppearanceStream(new AffineTransform());
        }
        this.resetNullAppearanceStream();
    }

    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        if (this.startOfLine == null || this.endOfLine == null) {
            return;
        }
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        AffineTransform matrix = appearanceState.getMatrix();
        appearanceState.setMatrix(new AffineTransform());
        appearanceState.setShapes(new Shapes());
        AffineTransform af = new AffineTransform();
        af.setToTranslation(dx * pageTransform.getScaleX(), -dy * pageTransform.getScaleY());
        af.transform(this.startOfLine, this.startOfLine);
        af.transform(this.endOfLine, this.endOfLine);
        this.setStartOfLine(this.startOfLine);
        this.setEndOfLine(this.endOfLine);
        Rectangle2D bbox = appearanceState.getBbox();
        bbox.setRect(this.userSpaceRectangle.x, this.userSpaceRectangle.y, this.userSpaceRectangle.width, this.userSpaceRectangle.height);
        this.setUserSpaceRectangle(this.userSpaceRectangle);
        this.setModifiedDate(PDate.formatDateTime(new Date()));
        BasicStroke stroke = this.getBorderStyleStroke();
        GeneralPath line = new GeneralPath();
        line.moveTo((float)this.startOfLine.getX(), (float)this.startOfLine.getY());
        line.lineTo((float)this.endOfLine.getX(), (float)this.endOfLine.getY());
        line.closePath();
        Shapes shapes = appearanceState.getShapes();
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, this.opacity)));
        shapes.add(new ShapeDrawCmd(line));
        shapes.add(new StrokeDrawCmd(stroke));
        shapes.add(new ColorDrawCmd(this.color));
        shapes.add(new DrawDrawCmd());
        if (this.startArrow.equals(LINE_END_OPEN_ARROW)) {
            LineAnnotation.openArrowStartDrawOps(shapes, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.startArrow.equals(LINE_END_CLOSED_ARROW)) {
            LineAnnotation.closedArrowStartDrawOps(shapes, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.startArrow.equals(LINE_END_CIRCLE)) {
            LineAnnotation.circleDrawOps(shapes, this.startOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.startArrow.equals(LINE_END_DIAMOND)) {
            LineAnnotation.diamondDrawOps(shapes, this.startOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.startArrow.equals(LINE_END_SQUARE)) {
            LineAnnotation.squareDrawOps(shapes, this.startOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        }
        if (this.endArrow.equals(LINE_END_OPEN_ARROW)) {
            LineAnnotation.openArrowEndDrawOps(shapes, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.endArrow.equals(LINE_END_CLOSED_ARROW)) {
            LineAnnotation.closedArrowEndDrawOps(shapes, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.endArrow.equals(LINE_END_CIRCLE)) {
            LineAnnotation.circleDrawOps(shapes, this.endOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.endArrow.equals(LINE_END_DIAMOND)) {
            LineAnnotation.diamondDrawOps(shapes, this.endOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        } else if (this.endArrow.equals(LINE_END_SQUARE)) {
            LineAnnotation.squareDrawOps(shapes, this.endOfLine, this.startOfLine, this.endOfLine, this.color, this.interiorColor);
        }
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        this.entries.remove(APPEARANCE_STREAM_KEY);
        StateManager stateManager = this.library.getStateManager();
        stateManager.addChange(new PObject(this, this.getPObjectReference()));
    }

    public Point2D getStartOfLine() {
        return this.startOfLine;
    }

    public void setStartOfLine(Point2D startOfLine) {
        this.startOfLine = startOfLine;
    }

    public Point2D getEndOfLine() {
        return this.endOfLine;
    }

    public void setEndOfLine(Point2D endOfLine) {
        this.endOfLine = endOfLine;
        ArrayList<Float> pointArray = new ArrayList<Float>(4);
        pointArray.add(Float.valueOf((float)this.startOfLine.getX()));
        pointArray.add(Float.valueOf((float)this.startOfLine.getY()));
        pointArray.add(Float.valueOf((float)endOfLine.getX()));
        pointArray.add(Float.valueOf((float)endOfLine.getY()));
        this.entries.put(L_KEY, pointArray);
    }

    public Color getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color interiorColor) {
        this.interiorColor = interiorColor;
        float[] compArray = new float[3];
        this.interiorColor.getColorComponents(compArray);
        ArrayList<Float> colorValues = new ArrayList<Float>(compArray.length);
        for (float comp : compArray) {
            colorValues.add(Float.valueOf(comp));
        }
        this.entries.put(IC_KEY, colorValues);
    }

    public Name getStartArrow() {
        return this.startArrow;
    }

    public void setStartArrow(Name startArrow) {
        this.startArrow = startArrow;
        ArrayList<Name> endNameArray = new ArrayList<Name>(2);
        endNameArray.add(startArrow);
        endNameArray.add(this.endArrow);
        this.entries.put(LE_KEY, endNameArray);
    }

    public Name getEndArrow() {
        return this.endArrow;
    }

    public void setEndArrow(Name endArrow) {
        this.endArrow = endArrow;
        ArrayList<Name> endNameArray = new ArrayList<Name>(2);
        endNameArray.add(this.startArrow);
        endNameArray.add(endArrow);
        this.entries.put(LE_KEY, endNameArray);
    }
}

