/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.BensAR;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class TableModelBensAR
extends TableListaSumarioModel {
    private static final long serialVersionUID = 1L;
    private static final String TITULO_CODIGO = "<html><center>C\u00f3d.</center></html>";
    private static final String TITULO_DISCRIMINACAO = "<html><center>Discrimina\u00e7\u00e3o</center></html>";
    private static final String TITULO_VALOR_ANTERIOR = "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "<br>R$</center></html>";
    private static final String TITULO_VALOR_ATUAL = "<html><center>Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE + "</center></html>";
    private static final String TITULO_PAIS = "<html><center>Pa\u00eds</center></html>";

    public TableModelBensAR(Colecao pObj, boolean isBrasil) {
        super(pObj);
    }

    public int getColumnCount() {
        return 6;
    }

    public Informacao getInformacaoAt(int row, int col) {
        Colecao bens = (Colecao)this.getObjetoNegocio();
        boolean ultimaLinha = row == this.getRowCount() - 1;
        BemAR item = null;
        if (!ultimaLinha) {
            item = (BemAR)bens.itens().get(row);
        }
        switch (col) {
            case 0: {
                return ultimaLinha ? this.labelTotal : super.getInformacaoAt(row, col);
            }
            case 1: {
                return ultimaLinha ? null : item.getCodigo();
            }
            case 2: {
                return ultimaLinha ? null : item.getNomePais();
            }
            case 3: {
                return ultimaLinha ? null : item.getDiscriminacao();
            }
            case 4: {
                return ultimaLinha ? ((BensAR)bens).getTotalAnterior() : item.getValorExercicioAnterior();
            }
            case 5: {
                return ultimaLinha ? ((BensAR)bens).getTotalAtual() : item.getValorExercicioAtual();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return TITULO_CODIGO;
            }
            case 2: {
                return TITULO_PAIS;
            }
            case 3: {
                return TITULO_DISCRIMINACAO;
            }
            case 4: {
                return TITULO_VALOR_ANTERIOR;
            }
            case 5: {
                StringBuilder tituloColuna = new StringBuilder();
                tituloColuna.append("<html><center>");
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio()) {
                    tituloColuna.append("Situa\u00e7\u00e3o na<br>data da partilha");
                } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    tituloColuna.append("Situa\u00e7\u00e3o na<br>data da<br>caracteriza\u00e7\u00e3o<br>da condi\u00e7\u00e3o de<br>n\u00e3o residente");
                } else {
                    tituloColuna.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE);
                }
                tituloColuna.append("<br>R$</center></html>");
                return tituloColuna.toString();
            }
        }
        return "";
    }
}

