/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class MovimentacaoRebanhoCellRenderer
implements TableCellRenderer {
    private static final Color FG_NAO_EDITAVEL = new Color(11, 56, 90);
    private static final Color BG_NAO_EDITAVEL = new Color(213, 231, 245);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel retorno = new JLabel();
        retorno.setOpaque(true);
        String texto = value instanceof Informacao ? ((Informacao)value).formatado() : value.toString();
        retorno.setText(texto);
        if (!table.getModel().isCellEditable(row, column)) {
            retorno.setForeground(FG_NAO_EDITAVEL);
            retorno.setBackground(BG_NAO_EDITAVEL);
        } else {
            retorno.setBackground(Color.WHITE);
            retorno.setFont(retorno.getFont().deriveFont(0));
        }
        if (value instanceof Valor) {
            retorno.setHorizontalAlignment(4);
        } else if (value instanceof Alfa) {
            retorno.setHorizontalAlignment(2);
        } else {
            retorno.setHorizontalAlignment(0);
        }
        if (hasFocus) {
            retorno.setForeground(Color.WHITE);
            retorno.setBackground(table.getSelectionBackground());
        }
        if (retorno instanceof JComponent) {
            JLabel jComp = retorno;
            jComp.setBorder(ConstantesGlobaisIRPF.bordaVazia);
        }
        return retorno;
    }
}

