/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import br.gov.serpro.midas.jasperreports.XPathPredicate;
import br.gov.serpro.midas.jasperreports.XPathUtil;
import br.gov.serpro.midas.negocio.MidasReportElement;
import br.gov.serpro.midas.negocio.MidasReportElementBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathWalker {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger log = LoggerFactory.getLogger(XPathWalker.class);

    public static List<MidasReportElement> nodes(MidasReportElement root, String xPathExpression, boolean flat) {
        List<MidasReportElement> result = XPathWalker.nodes(root, xPathExpression);
        if (log.isDebugEnabled()) {
            log.debug("Result nodes[" + result.size() + "] for expression [" + xPathExpression + "]: \n\t\t" + result);
        }
        if (!flat && result.size() > 1) {
            MidasReportElement newRoot = MidasReportElementBuilder.cloneToEmptyParentNode(root, null);
            for (MidasReportElement element : result) {
                newRoot.add(element);
            }
            result.clear();
            result.add(newRoot);
        }
        if (log.isDebugEnabled()) {
            log.debug("FINAL Result[" + result.size() + "]: " + result);
        }
        return result;
    }

    public static List<MidasReportElement> nodes(MidasReportElement root, String xPathExpression) {
        if (log.isDebugEnabled()) {
            log.debug("Getting nodes for expression: " + xPathExpression);
            log.debug("Root: " + root);
        }
        if (StringUtils.isEmpty((String)xPathExpression)) {
            return Collections.emptyList();
        }
        List<String> tokens = XPathWalker.getTokensForXPath(xPathExpression);
        if (log.isDebugEnabled()) {
            log.debug("All tokens: " + tokens);
        }
        if (xPathExpression.equals(".")) {
            if (log.isDebugEnabled()) {
                log.debug("DOT expression. Return the node itself");
            }
            return Arrays.asList(root);
        }
        try {
            List<MidasReportElement> result = XPathWalker.nodes(tokens, 0, root);
            if (log.isDebugEnabled()) {
                log.debug("Result[" + result.size() + "]: " + result);
            }
            return result;
        }
        catch (RuntimeException ex) {
            log.error(ex.toString(), (Throwable)ex);
            throw ex;
        }
    }

    private static List<MidasReportElement> nodes(List<String> tokens, int tokenIndex, MidasReportElement root) {
        if (log.isDebugEnabled()) {
            log.debug("TokenIndex[" + tokenIndex + "]. All tokens[" + tokens.size() + "]: " + tokens);
        }
        if (tokenIndex >= tokens.size()) {
            if (log.isDebugEnabled()) {
                log.debug("No more tokens to process!");
            }
            return Collections.emptyList();
        }
        String token = tokens.get(tokenIndex);
        if (log.isDebugEnabled()) {
            log.debug("Getting nodes for token: [" + token + "]");
        }
        ArrayList<MidasReportElement> nodes = new ArrayList<MidasReportElement>();
        List<MidasReportElement> queryResult = XPathWalker.executeQueryOnElement(root, token);
        if (log.isDebugEnabled()) {
            log.debug("QueryResult [" + queryResult.size() + "] for token[" + token + "] at TokenIndex[" + tokenIndex + "]: \n\t\t" + queryResult);
        }
        if (XPathWalker.hasMoreTokens(tokenIndex, tokens)) {
            ++tokenIndex;
            if (log.isDebugEnabled()) {
                log.debug("We have more tokens to process!!!");
            }
            XPathWalker.processAllElementsForTokenIndex(tokens, tokenIndex, nodes, queryResult);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("NO more tokens to process.");
            }
            nodes.addAll(queryResult);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning nodes: " + nodes);
        }
        return nodes;
    }

    private static List<MidasReportElement> executeQueryOnElement(MidasReportElement element, String token) {
        if (log.isDebugEnabled()) {
            log.debug("Initial token: " + token);
        }
        List<XPathPredicate> predicates = XPathUtil.getXPathPredicate(token);
        String processedToken = XPathUtil.getTokenWithoutXPathPredicates(token);
        if (log.isDebugEnabled()) {
            log.debug("Predicates: " + predicates);
            log.debug("Processed token: " + processedToken);
        }
        if (".".equals(processedToken)) {
            if (log.isDebugEnabled()) {
                log.debug("Special DOT token. Replace with its own name");
            }
            processedToken = element.getName();
        }
        List<MidasReportElement> queryResult = element.get(processedToken);
        queryResult = XPathWalker.filterByPredicates(queryResult, predicates);
        if (log.isDebugEnabled()) {
            log.debug("FilteredResult: " + queryResult);
        }
        return queryResult;
    }

    private static List<MidasReportElement> filterByPredicates(List<MidasReportElement> queryResult, List<XPathPredicate> predicates) {
        if (predicates.isEmpty()) {
            return queryResult;
        }
        if (queryResult.isEmpty()) {
            return queryResult;
        }
        ArrayList<MidasReportElement> filtered = new ArrayList<MidasReportElement>();
        int record = -1;
        if (predicates != null && predicates.size() > 0) {
            if (XPathWalker.haveSelector(predicates)) {
                record = predicates.get(0).intValue() - 1;
                if (log.isDebugEnabled()) {
                    log.debug("Getting record (base zero)[" + record + "] for query result elements: [" + queryResult.size() + "]");
                }
                if (record < queryResult.size()) {
                    filtered.add(queryResult.get(record));
                }
            } else if (predicates.size() > 0 && predicates.get((int)0).selector) {
                filtered.addAll(XPathWalker.filterUsingSelectors(queryResult, predicates));
            }
        } else if (log.isDebugEnabled()) {
            log.debug("NO predicates provided");
        }
        return filtered;
    }

    private static Collection<? extends MidasReportElement> filterUsingSelectors(List<MidasReportElement> queryResult, List<XPathPredicate> predicates) {
        ArrayList<MidasReportElement> filtered = new ArrayList<MidasReportElement>();
        for (MidasReportElement rootElement : queryResult) {
            boolean haveAllPredicates = true;
            for (XPathPredicate predicate : predicates) {
                if (log.isDebugEnabled()) {
                    log.debug("Current element: " + rootElement + "\n\t\tchildren: " + rootElement.getChildren());
                    log.debug("Current predicate: " + predicate);
                }
                List<MidasReportElement> subElements = rootElement.get(predicate.getFieldName(), predicate.getFieldValue());
                if (log.isDebugEnabled()) {
                    log.debug("SubElements: " + subElements);
                }
                if (!subElements.isEmpty()) continue;
                haveAllPredicates = false;
                break;
            }
            if (!haveAllPredicates) continue;
            filtered.add(rootElement);
        }
        return filtered;
    }

    private static boolean haveSelector(List<XPathPredicate> predicates) {
        return predicates.size() == 1 && !predicates.get((int)0).selector;
    }

    private static void processAllElementsForTokenIndex(List<String> tokens, int tokenIndex, List<MidasReportElement> nodes, List<MidasReportElement> elements) {
        for (MidasReportElement current : elements) {
            if (log.isDebugEnabled()) {
                log.debug("Current element to get nodes: " + current);
            }
            List<MidasReportElement> newNodes = XPathWalker.nodes(tokens, tokenIndex, current);
            if (log.isDebugEnabled()) {
                log.debug("Nodes for element: " + newNodes);
            }
            nodes.addAll(newNodes);
        }
        if (log.isDebugEnabled()) {
            log.debug("All elements[" + elements.size() + "] processed for index[" + tokenIndex + "]");
        }
    }

    private static boolean hasMoreTokens(int tokenIndex, List<String> tokens) {
        return tokenIndex < tokens.size() - 1;
    }

    static List<String> getTokensForXPath(String xPathExpression) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (StringUtils.isEmpty((String)xPathExpression)) {
            return tokens;
        }
        if (xPathExpression.startsWith(PATH_SEPARATOR) && StringUtils.isEmpty((String)(xPathExpression = StringUtils.stripStart((String)xPathExpression, (String)PATH_SEPARATOR)))) {
            xPathExpression = ".";
        }
        tokens.addAll(Arrays.asList(StringUtils.split((String)xPathExpression, (String)PATH_SEPARATOR)));
        return tokens;
    }
}

