/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import org.apache.commons.lang.StringUtils;

public class XPathPredicate {
    private String fieldName;
    private String fieldValue;
    private String operator;
    private String group;
    private String originalGroup;
    private static String OPERATOR_REGEX = "=";
    public boolean selector;

    public XPathPredicate(String fieldName, String fieldValue) {
        this.fieldName = StringUtils.trimToEmpty((String)fieldName);
        this.fieldValue = StringUtils.trimToNull((String)fieldValue);
    }

    public XPathPredicate(String group) {
        this.validate(group);
        this.originalGroup = group;
        group = this.removeBrackets(group);
        group = StringUtils.replace((String)group, (String)"\"", (String)"");
        this.group = group = StringUtils.replace((String)group, (String)"'", (String)"");
        String[] split = this.group.split(OPERATOR_REGEX);
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid token: " + group);
        }
        this.setFieldName(split[0]);
        this.setFieldValue(split[1]);
    }

    private void validate(String value) {
        int quotes = StringUtils.countMatches((String)value, (String)"'");
        if (quotes % 2 != 0) {
            throw new IllegalArgumentException("This value is unbalanced: " + value + ". Expecting one quote.");
        }
    }

    public String removeBrackets(String value) {
        value = StringUtils.replace((String)value, (String)"[", (String)"");
        value = StringUtils.replace((String)value, (String)"]", (String)"");
        return value;
    }

    public Integer intValue() {
        return Integer.valueOf(this.fieldValue);
    }

    public String toString() {
        return "XPathPredicate [fieldName=" + this.fieldName + ",fieldValue=" + this.fieldValue + ", selector=" + this.selector + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.fieldValue == null ? 0 : this.fieldValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathPredicate other = (XPathPredicate)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.fieldValue == null ? other.fieldValue != null : !this.fieldValue.equals(other.fieldValue));
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = StringUtils.trimToEmpty((String)fieldName);
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = StringUtils.trimToNull((String)fieldValue);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = StringUtils.trimToNull((String)group);
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOriginalGroup() {
        return this.originalGroup;
    }
}

