/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.gcap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class MapeamentoXmlReader {
    Document mapeamento;

    public MapeamentoXmlReader() {
        String pathArquivoMapeamento = FabricaUtilitarios.getProperties().getProperty("aplicacao.formatosexternos.mapeamentoXml", "mapeamentoXml");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathArquivoMapeamento);
        this.mapeamento = MapeamentoXmlReader.carregar(is);
    }

    public MapeamentoXmlReader(String chaveMapeamentoXML) {
        String pathArquivoMapeamento = FabricaUtilitarios.getProperties().getProperty(chaveMapeamentoXML, "mapeamentoXml");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathArquivoMapeamento);
        this.mapeamento = MapeamentoXmlReader.carregar(is);
    }

    public static Document carregar(InputStream arq) {
        Document mapeamento = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            mapeamento = builder.parse(arq);
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (SAXException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return mapeamento;
    }

    public Element getMapeamentoTipoArquivo(String tipoArquivo) {
        Element mapeamentoTag = this.getMapeamento().getDocumentElement();
        NodeList list = mapeamentoTag.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String atributo;
            Element arquivoTag;
            Node o = list.item(i);
            if (!(o instanceof Element) || !(arquivoTag = (Element)o).getNodeName().equals("DeclaracaoTXT") || (atributo = arquivoTag.getAttribute("TipoArquivo")) == null || !atributo.toLowerCase().equals(tipoArquivo)) continue;
            return arquivoTag;
        }
        return null;
    }

    public Element getMapeamentoRegistro(String nome, Element tipoArquivo) {
        NodeList list = tipoArquivo.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String atributo;
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element registroTag = (Element)o;
            if (!list.item(i).getNodeName().equals("Registro") || (atributo = registroTag.getAttribute("Nome")) == null || !atributo.toLowerCase().equals(nome)) continue;
            return registroTag;
        }
        return null;
    }

    public Element getMapeamentoCampo(String nome, Element registro) {
        NodeList list = registro.getChildNodes();
        String tagPathRegistro = registro.getAttribute("Nome");
        for (int i = 0; i < list.getLength(); ++i) {
            String atributo;
            Node o = list.item(i);
            if (!(o instanceof Element)) continue;
            Element campoTag = (Element)o;
            if (!list.item(i).getNodeName().equals("Campo") || !(atributo = tagPathRegistro + "/" + campoTag.getAttribute("Nome")).toLowerCase().equals(nome)) continue;
            return campoTag;
        }
        return null;
    }

    public Document getMapeamento() {
        return this.mapeamento;
    }

    public void setMapeamento(Document mapeamento) {
        this.mapeamento = mapeamento;
    }
}

