/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.carneleao;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.txt.importacao.RelatorioRepositorioTxtDadosAb;
import serpro.ppgd.irpf.txt.importacao.VersaoDecInvalidaException;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.util.PLong;

public class RepositorioTxtDadosCarneLeao
extends RelatorioRepositorioTxtDadosAb {
    private String pathArquivo = null;
    private DocumentoTXT[] documentosTXT = null;
    private File[] arquivos = null;

    public RepositorioTxtDadosCarneLeao(File[] _arquivos) {
        this.arquivos = _arquivos;
        this.documentosTXT = new DocumentoTXT[this.arquivos.length];
        for (int i = 0; i < this.documentosTXT.length; ++i) {
            this.documentosTXT[i] = new DocumentoTXTDefault("ARQ_IMPORTACAO_CARNELEAO", this.arquivos[i].getPath()){

                public void ler() throws IOException {
                    File file = new File(this.getPath());
                    try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1");
                         BufferedReader arqDeclaracao = new BufferedReader(isr);){
                        boolean eof = false;
                        while (!eof) {
                            String linha = arqDeclaracao.readLine();
                            if (linha != null && linha.length() > 0) {
                                this.arquivo().add(linha);
                                continue;
                            }
                            eof = true;
                        }
                    }
                    catch (IOException e) {
                        throw new IOException("Erro ao ler arquivo - " + this.getPath());
                    }
                }
            };
        }
        this.setContabilizarSucessosErros(true);
    }

    public RepositorioTxtDadosCarneLeao(String _pathArquivo) {
        this.pathArquivo = _pathArquivo;
        this.documentosTXT = new DocumentoTXT[1];
        this.documentosTXT[0] = new DocumentoTXTDefault("ARQ_IMPORTACAO_CARNELEAO", this.pathArquivo);
        this.setContabilizarSucessosErros(false);
    }

    public ArrayList<String> importaDados() throws Exception {
        ArrayList<String> erros = new ArrayList<String>();
        this.resetQuantidadeSucessos();
        this.resetQuantidadeErros();
        if (this.validarCPFs()) {
            for (int i = 0; i < this.arquivos.length; ++i) {
                String CPFSelecionado = this.arquivos[i].getName().substring(0, 11);
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(CPFSelecionado)) {
                    try {
                        this.validarVersaoCarneLeao(i);
                        this.importaIdentificacao(ControladorGui.getDemonstrativoAberto(), i);
                        this.importaDados(IRPFFacade.getInstancia().getRendPFTitular(), i, IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf());
                        this.incrementarQuantidadeSucessos();
                    }
                    catch (Exception ex) {
                        this.incrementarQuantidadeErros();
                        if (!this.isContabilizarSucessosErros()) {
                            throw ex;
                        }
                        if (ex instanceof VersaoDecInvalidaException) {
                            erros.add(this.arquivos[i].getName() + " ==> " + ex.getMessage());
                            continue;
                        }
                        erros.add(this.arquivos[i].getName() + " ==> Arquivo corrompido. Verifique se o arquivo de exporta\u00e7\u00e3o do Carn\u00ea Le\u00e3o foi gerado na vers\u00e3o mais atual do aplicativo.");
                    }
                    continue;
                }
                this.apagarCarneLeaoParaCPFDependente(CPFSelecionado);
                ItemRendPFDependente itemRendPFDependente = new ItemRendPFDependente();
                itemRendPFDependente.getCpf().setConteudo(CPFSelecionado);
                RendPF rendPF = new RendPF();
                itemRendPFDependente.setRendimentos(rendPF);
                try {
                    this.validarVersaoCarneLeao(i);
                    this.importaDados(rendPF, i, itemRendPFDependente.getCpf());
                    IRPFFacade.getInstancia().getRendPFDependente().itens().add(itemRendPFDependente);
                    this.incrementarQuantidadeSucessos();
                    continue;
                }
                catch (Exception ex) {
                    this.incrementarQuantidadeErros();
                    if (!this.isContabilizarSucessosErros()) {
                        throw ex;
                    }
                    if (ex instanceof VersaoDecInvalidaException) {
                        erros.add(this.arquivos[i].getName() + " ==> " + ex.getMessage());
                        continue;
                    }
                    erros.add(this.arquivos[i].getName() + " ==> Arquivo corrompido. Verifique se o arquivo de exporta\u00e7\u00e3o do Carn\u00ea Le\u00e3o foi gerado na vers\u00e3o mais atual do aplicativo.");
                }
            }
        }
        return erros;
    }

    public void validarVersaoCarneLeao(int posicaoDocumento) throws Exception {
        try {
            this.documentosTXT[posicaoDocumento].ler();
            this.verificaCRC(posicaoDocumento);
        }
        catch (IOException | GeracaoTxtException gex) {
            throw new GeracaoTxtException("Arquivo corrompido.");
        }
        List header = this.documentosTXT[posicaoDocumento].getRegistrosTxt("IR");
        int versaoCLEAO = 0;
        int versaoValidaCLEAO = 100;
        if (header != null && !header.isEmpty()) {
            versaoCLEAO = Integer.valueOf(((RegistroTxt)header.get(0)).fieldByName("NR_VERSAO").asString());
            String sistemaCLEAO = ((RegistroTxt)header.get(0)).fieldByName("SISTEMA").asString();
            if (ConstantesGlobaisIRPF.VERSAO_CARNE_LEAO.containsKey(sistemaCLEAO)) {
                versaoValidaCLEAO = (Integer)ConstantesGlobaisIRPF.VERSAO_CARNE_LEAO.get(sistemaCLEAO);
            }
        }
        if (versaoCLEAO != versaoValidaCLEAO) {
            throw new VersaoDecInvalidaException(MensagemUtil.getMensagem((String)"versao_arquivo_leao_errado", (String[])new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR, ConstantesGlobais.EXERCICIO_ANTERIOR}));
        }
    }

    public void importaIdentificacao(DeclaracaoIRPF dec, int posicaoDocumento) throws GeracaoTxtException, IOException {
        Iterator it = this.documentosTXT[posicaoDocumento].getRegistrosTxt("01").iterator();
        if (it.hasNext()) {
            RegistroTxt reg = (RegistroTxt)it.next();
            String codOcupacaoPrincipal = reg.fieldByName("COD_OCUPACAO_PRINCIPAL").asString().trim();
            String registroProfissional = reg.fieldByName("NR_REG_PROFISSIONAL").asString().trim();
            if (!dec.getIdentificadorDeclaracao().isEspolio() && codOcupacaoPrincipal.matches("225|226|229|230|231|232|255|241")) {
                if (dec.getContribuinte().getOcupacaoPrincipal().isVazio()) {
                    dec.getContribuinte().getOcupacaoPrincipal().setConteudo(codOcupacaoPrincipal);
                    dec.getContribuinte().getRegistroProfissional().setConteudo(registroProfissional);
                } else if (dec.getContribuinte().getOcupacaoPrincipal().naoFormatado().equals(codOcupacaoPrincipal)) {
                    dec.getContribuinte().getRegistroProfissional().setConteudo(registroProfissional);
                } else if (GuiUtil.mostrarConfirma((String)"confirmacao_substituicao_ocupacao_principal")) {
                    dec.getContribuinte().getOcupacaoPrincipal().setConteudo(codOcupacaoPrincipal);
                    dec.getContribuinte().getRegistroProfissional().setConteudo(registroProfissional);
                }
            }
        }
    }

    public void importaDados(RendPF rendPF, int posicaoDocumento, CPF cpfContribuinte) throws GeracaoTxtException, IOException {
        for (RegistroTxt reg : this.documentosTXT[posicaoDocumento].getRegistrosTxt("02")) {
            String strMes = reg.fieldByName("Mes").asString().trim();
            MesRendPF mes = this.getMesRendPFTitular(strMes, rendPF);
            boolean importar = true;
            if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
                Espolio espolio = IRPFFacade.getInstancia().getEspolio();
                String mesLimite = espolio.obterDataLimiteParaCalculos().getMes();
                if (mes.getMes().asInteger() + 1 > Integer.valueOf(mesLimite)) {
                    importar = false;
                }
            } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
                String mesCondicaoResidente;
                Saida saida = IRPFFacade.getInstancia().getSaida();
                String mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
                String string = mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
                if (mes.getMes().asInteger() + 1 < Integer.valueOf(mesCondicaoResidente) || mes.getMes().asInteger() + 1 > Integer.valueOf(mesCondicaoNaoResidente)) {
                    importar = false;
                }
            }
            if (!importar) continue;
            mes.getAlugueis().setConteudo(reg.fieldByName("Alugueis").asValor());
            mes.getOutros().setConteudo(reg.fieldByName("Outros").asValor());
            mes.getExterior().setConteudo(reg.fieldByName("Exterior").asValor());
            mes.getPrevidencia().setConteudo(reg.fieldByName("previdenciaOficial").asValor());
            mes.getDependentes().setConteudo(reg.fieldByName("dependentes").asValor());
            mes.getPensao().setConteudo(reg.fieldByName("pensaoAlimenticia").asValor());
            mes.getLivroCaixa().setConteudo(reg.fieldByName("livroCaixa").asValor());
            mes.getCarneLeao().setConteudo(reg.fieldByName("impostoAPagar").asValor());
            mes.getDarfPago().setConteudo(reg.fieldByName("impostoPago").asValor());
        }
        Iterator it = this.documentosTXT[posicaoDocumento].getRegistrosTxt("03").iterator();
        for (int i = 0; i < 12; ++i) {
            rendPF.getContasAno().getArrayMeses()[i].getTotalRendTrabNaoAssPF().clear();
            rendPF.getContasAno().getArrayMeses()[i].itens().clear();
        }
        boolean[] meses = new boolean[12];
        for (int i = 0; i < 12; ++i) {
            meses[i] = IRPFFacade.getInstancia().getDeclaracao().permiteInformarRendimento(i + 1);
        }
        while (it.hasNext()) {
            RegistroTxt reg = (RegistroTxt)it.next();
            String strMes = reg.fieldByName("mes").asString();
            int mes = Integer.valueOf(strMes.substring(0, 2));
            if (!meses[mes - 1]) continue;
            ContasMes contasMes = rendPF.getContasAno().getArrayMeses()[mes - 1];
            Conta conta = new Conta();
            conta.getCpfContribuinte().setConteudo(cpfContribuinte);
            conta.getDataMesAno().setConteudo(strMes);
            conta.getCpfTitularPagamento().setConteudo(reg.fieldByName("cpftitularpagamento").asString());
            conta.getCpfBeneficiarioServico().setConteudo(reg.fieldByName("cpfbeneficiarioservico").asString());
            conta.getValor().setConteudo(reg.fieldByName("valor").asValor());
            if (conta.getCpfTitularPagamento().naoFormatado().equals(conta.getCpfBeneficiarioServico().naoFormatado())) {
                conta.getIndTitularEhBeneficiario().setConteudo("1");
            } else {
                conta.getIndTitularEhBeneficiario().setConteudo("0");
            }
            if (conta.getCpfBeneficiarioServico().naoFormatado().length() != 11) {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("1");
            } else {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("0");
            }
            contasMes.itens().add(conta);
        }
        boolean heTitular = cpfContribuinte.naoFormatado().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado());
        String ocupacaoPrincipal = ControladorGui.getDemonstrativoAberto().getContribuinte().getOcupacaoPrincipal().getConteudoAtual(0);
        if (heTitular && ocupacaoPrincipal.equals("117")) {
            GuiUtil.mostrarAviso((String)"titular_cartorio");
        }
    }

    private MesRendPF getMesRendPFTitular(String mes, RendPF aRendPF) {
        mes = mes.toUpperCase();
        RendPF rendPF = aRendPF;
        MesRendPF retorno = null;
        if (mes.equals("JANEIRO")) {
            retorno = rendPF.getJaneiro();
            retorno.getMes().setConteudo(0);
            return retorno;
        }
        if (mes.equals("FEVEREIRO")) {
            retorno = rendPF.getFevereiro();
            retorno.getMes().setConteudo(1);
            return retorno;
        }
        if (mes.equals("MARCO")) {
            retorno = rendPF.getMarco();
            retorno.getMes().setConteudo(2);
            return retorno;
        }
        if (mes.equals("ABRIL")) {
            retorno = rendPF.getAbril();
            retorno.getMes().setConteudo(3);
            return retorno;
        }
        if (mes.equals("MAIO")) {
            retorno = rendPF.getMaio();
            retorno.getMes().setConteudo(4);
            return retorno;
        }
        if (mes.equals("JUNHO")) {
            retorno = rendPF.getJunho();
            retorno.getMes().setConteudo(5);
            return retorno;
        }
        if (mes.equals("JULHO")) {
            retorno = rendPF.getJulho();
            retorno.getMes().setConteudo(6);
            return retorno;
        }
        if (mes.equals("AGOSTO")) {
            retorno = rendPF.getAgosto();
            retorno.getMes().setConteudo(7);
            return retorno;
        }
        if (mes.equals("SETEMBRO")) {
            retorno = rendPF.getSetembro();
            retorno.getMes().setConteudo(8);
            return retorno;
        }
        if (mes.equals("OUTUBRO")) {
            retorno = rendPF.getOutubro();
            retorno.getMes().setConteudo(9);
            return retorno;
        }
        if (mes.equals("NOVEMBRO")) {
            retorno = rendPF.getNovembro();
            retorno.getMes().setConteudo(10);
            return retorno;
        }
        if (mes.equals("DEZEMBRO")) {
            retorno = rendPF.getDezembro();
            retorno.getMes().setConteudo(11);
            return retorno;
        }
        throw new IllegalArgumentException("M\u00eas inv\u00e1lido!");
    }

    public void verificaCRC(int indiceArquivo) throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        try {
            for (int i = 0; i < this.documentosTXT[indiceArquivo].arquivo().size() - 1; ++i) {
                String linha = (String)this.documentosTXT[indiceArquivo].arquivo().get(i);
                if (hashCalculadoLinhaAnterior != 0L) {
                    pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
                }
                hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
            }
            String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
            RegistroTxt reg = (RegistroTxt)this.documentosTXT[indiceArquivo].getRegistrosTxt("99").get(0);
            String crcLido = reg.fieldByName("HASHCODE").asString();
            crcLido = String.format("%010d", Long.parseLong(crcLido));
            if (!crcLido.equals(crcAcumuladoFinal = String.format("%010d", Long.parseLong(crcAcumuladoFinal)))) {
                throw new GeracaoTxtException("Arquivo corrompido");
            }
        }
        catch (Exception ex) {
            throw new GeracaoTxtException(ex.getMessage());
        }
    }

    private boolean validarCPFs() {
        boolean todosValidos = true;
        for (int i = 0; i < this.arquivos.length; ++i) {
            String CPFSelecionado = this.arquivos[i].getName().substring(0, 11);
            if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(CPFSelecionado) || IRPFFacade.getInstancia().getDependentes().isExisteCpf(CPFSelecionado)) continue;
            todosValidos = false;
            break;
        }
        return todosValidos;
    }

    public boolean temCarneLeaoJaImportado(File[] arquivosImportar) {
        boolean encontrouCarnePreenchido = false;
        for (int i = 0; i < this.arquivos.length; ++i) {
            String CPFSelecionado = this.arquivos[i].getName().substring(0, 11);
            if (!IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(CPFSelecionado) || IRPFFacade.getInstancia().getRendPFTitular().isVazio()) continue;
            encontrouCarnePreenchido = true;
            break;
        }
        if (!encontrouCarnePreenchido) {
            ColecaoRendPFDependente colecaoRendPFDependente = IRPFFacade.getInstancia().getRendPFDependente();
            List listaItemRendPFDependente = colecaoRendPFDependente.itens();
            for (ItemRendPFDependente itemRendPFDependente : listaItemRendPFDependente) {
                for (int i = 0; i < this.arquivos.length; ++i) {
                    String CPFSelecionado = this.arquivos[i].getName().substring(0, 11);
                    if (!itemRendPFDependente.getCpf().naoFormatado().equals(CPFSelecionado)) continue;
                    encontrouCarnePreenchido = true;
                    break;
                }
                if (!encontrouCarnePreenchido) continue;
                break;
            }
        }
        return encontrouCarnePreenchido;
    }

    private void apagarCarneLeaoParaCPFDependente(String cpf) {
        for (ItemRendPFDependente itemRendPFDependente : IRPFFacade.getInstancia().getRendPFDependente().itens()) {
            if (!itemRendPFDependente.getCpf().naoFormatado().equals(cpf)) continue;
            IRPFFacade.getInstancia().getRendPFDependente().itens().remove(itemRendPFDependente);
            break;
        }
    }
}

